/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.storage.sqlite;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.Door;
import nl.pim16aap2.bigDoors.storage.sqlite.V2ExportUtil;
import nl.pim16aap2.bigDoors.util.DoorDirection;
import nl.pim16aap2.bigDoors.util.DoorOwner;
import nl.pim16aap2.bigDoors.util.DoorType;
import nl.pim16aap2.bigDoors.util.RotateDirection;
import nl.pim16aap2.bigDoors.util.Util;
import nl.pim16aap2.bigDoors.util.VersionScheme;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public class SQLiteJDBCDriverConnection {
    private static final String FAKEUUID = "0000";
    private static final String DRIVER = "org.sqlite.JDBC";
    private static final int DATABASE_VERSION = 9;
    private static final int DOOR_ID = 1;
    private static final int DOOR_NAME = 2;
    private static final int DOOR_WORLD = 3;
    private static final int DOOR_OPEN = 4;
    private static final int DOOR_MIN_X = 5;
    private static final int DOOR_MIN_Y = 6;
    private static final int DOOR_MIN_Z = 7;
    private static final int DOOR_MAX_X = 8;
    private static final int DOOR_MAX_Y = 9;
    private static final int DOOR_MAX_Z = 10;
    private static final int DOOR_ENG_X = 11;
    private static final int DOOR_ENG_Y = 12;
    private static final int DOOR_ENG_Z = 13;
    private static final int DOOR_LOCKED = 14;
    private static final int DOOR_TYPE = 15;
    private static final int DOOR_ENG_SIDE = 16;
    private static final int DOOR_POWER_X = 17;
    private static final int DOOR_POWER_Y = 18;
    private static final int DOOR_POWER_Z = 19;
    private static final int DOOR_OPEN_DIR = 20;
    private static final int DOOR_AUTO_CLOSE = 21;
    private static final int DOOR_CHUNK_HASH = 22;
    private static final int DOOR_BLOCKS_TO_MOVE = 23;
    private static final int DOOR_NOTIFY = 24;
    private static final int DOOR_BYPASS_PROTECTIONS = 25;
    private static final int PLAYERS_ID = 1;
    private static final int PLAYERS_UUID = 2;
    private static final int PLAYERS_NAME = 3;
    private static final int UNION_ID = 1;
    private static final int UNION_PERM = 2;
    private static final int UNION_PLAYER_ID = 3;
    private static final int UNION_DOOR_ID = 4;
    private final String dbName;
    private boolean validVersion = true;
    private boolean supportsReturningClause = false;
    private final BigDoors plugin;
    private final File dbFile;
    private final String url;
    private volatile boolean enabled = true;
    private final AtomicBoolean locked = new AtomicBoolean(false);

    public SQLiteJDBCDriverConnection(BigDoors plugin, String dbName) {
        this.plugin = plugin;
        this.dbName = dbName;
        this.dbFile = new File(plugin.getDataFolder(), dbName);
        this.url = SQLiteJDBCDriverConnection.getConnectionUrl(this.dbFile);
        this.init();
        this.upgrade();
    }

    private static String getConnectionUrl(File file) {
        return "jdbc:sqlite:" + file;
    }

    private Connection getConnection() {
        if (this.locked.get()) {
            this.plugin.getMyLogger().logMessage("Database locked! Please try again later! Please contact pim16aap2 if the issue persists.", true, false);
            return null;
        }
        if (!this.validVersion) {
            this.plugin.getMyLogger().logMessage("Database disabled! Reason: Version too high! Please update the plugin!", true, false);
            return null;
        }
        if (!this.enabled) {
            this.plugin.getMyLogger().logMessage("Database disabled! This probably means an upgrade failed! Please contact pim16aap2.", true, false);
            return null;
        }
        Connection conn = null;
        try {
            Class.forName(DRIVER);
            conn = DriverManager.getConnection(this.url);
            conn.createStatement().execute("PRAGMA foreign_keys=ON");
        }
        catch (NullPointerException | SQLException ex) {
            this.plugin.getMyLogger().logMessage("53: Failed to open connection!", true, false);
        }
        catch (ClassNotFoundException e) {
            this.plugin.getMyLogger().logMessage("57: Failed to open connection: CLass not found!!", true, false);
        }
        return conn;
    }

    private Connection getConnectionUnsafe(String connectionUrl) {
        Connection conn = null;
        try {
            Class.forName(DRIVER);
            conn = DriverManager.getConnection(connectionUrl);
            conn.createStatement().execute("PRAGMA foreign_keys=ON");
        }
        catch (NullPointerException | SQLException ex) {
            this.plugin.getMyLogger().logMessage("148: Failed to open connection!", true, false);
        }
        catch (ClassNotFoundException e) {
            this.plugin.getMyLogger().logMessage("152: Failed to open connection: CLass not found!!", true, false);
        }
        return conn;
    }

    private Connection getConnectionUnsafe() {
        return this.getConnectionUnsafe(this.url);
    }

    private void disableDatabase(@Nullable String reason) {
        this.plugin.getMyLogger().severe("The database has been disabled!" + (reason == null ? "" : " Reason: " + reason));
        this.enabled = false;
    }

    private void disableDatabase() {
        this.disableDatabase(null);
    }

    @Nonnull
    private String getDriverVersion(Connection conn) {
        try {
            return Objects.requireNonNull(conn).getMetaData().getDriverVersion();
        }
        catch (NullPointerException | SQLException e) {
            throw new RuntimeException("Failed to get driver version!", e);
        }
    }

    private void init() {
        if (!this.dbFile.exists()) {
            try {
                this.dbFile.createNewFile();
                this.plugin.getMyLogger().logMessageToLogFile("New file created at " + this.dbFile);
            }
            catch (IOException e) {
                this.plugin.getMyLogger().logMessageToLogFile("File write error: " + this.dbFile);
            }
        }
        try (Connection conn = this.getConnection();){
            Objects.requireNonNull(conn);
            String driverVersion = this.getDriverVersion(conn);
            this.supportsReturningClause = driverVersion.equals(VersionScheme.DECIMAL.compareVersions(driverVersion, "3.35.0"));
            if (!this.supportsReturningClause && !conn.getMetaData().supportsGetGeneratedKeys()) {
                this.plugin.getMyLogger().severe("SQLite Driver version: " + driverVersion);
                this.plugin.getMyLogger().severe("Driver does not support RETURNING clause or getGeneratedKeys()!");
                this.plugin.getMyLogger().severe("Please update your driver!");
                this.disableDatabase();
                return;
            }
            if (!conn.getMetaData().getTables(null, null, "doors", new String[]{"TABLE"}).next()) {
                Statement stmt1 = conn.createStatement();
                String sql1 = "CREATE TABLE IF NOT EXISTS doors (id            INTEGER    PRIMARY KEY autoincrement,  name          TEXT       NOT NULL,  world         TEXT       NOT NULL,  isOpen        INTEGER    NOT NULL,  xMin          INTEGER    NOT NULL,  yMin          INTEGER    NOT NULL,  zMin          INTEGER    NOT NULL,  xMax          INTEGER    NOT NULL,  yMax          INTEGER    NOT NULL,  zMax          INTEGER    NOT NULL,  engineX       INTEGER    NOT NULL,  engineY       INTEGER    NOT NULL,  engineZ       INTEGER    NOT NULL,  isLocked      INTEGER    NOT NULL,  type          INTEGER    NOT NULL,  engineSide    INTEGER    NOT NULL,  powerBlockX   INTEGER    NOT NULL,  powerBlockY   INTEGER    NOT NULL,  powerBlockZ   INTEGER    NOT NULL,  openDirection INTEGER    NOT NULL,  autoClose     INTEGER    NOT NULL,  chunkHash     INTEGER    NOT NULL,  blocksToMove  INTEGER    NOT NULL,  notify        INTEGER    NOT NULL,  bypass_protections INTEGER NOT NULL) ";
                stmt1.executeUpdate(sql1);
                stmt1.close();
                Statement stmt2 = conn.createStatement();
                String sql2 = "CREATE TABLE IF NOT EXISTS players \n(id          INTEGER    PRIMARY KEY AUTOINCREMENT, \n playerUUID  TEXT       NOT NULL, \n playerName  TEXT       NOT NULL, \n unique(playerUUID));";
                stmt2.executeUpdate(sql2);
                stmt2.close();
                Statement stmt3 = conn.createStatement();
                String sql3 = "CREATE TABLE IF NOT EXISTS sqlUnion (id          INTEGER    PRIMARY KEY AUTOINCREMENT,  permission  INTEGER    NOT NULL,  playerID    REFERENCES players(id) ON UPDATE CASCADE ON DELETE CASCADE,  doorUID     REFERENCES doors(id)   ON UPDATE CASCADE ON DELETE CASCADE, unique (playerID, doorUID))";
                stmt3.executeUpdate(sql3);
                stmt3.close();
                this.setDBVersion(conn, 9);
            }
        }
        catch (RuntimeException | SQLException e) {
            this.logMessage("Database Initialization", e);
            this.disableDatabase("Database initialization failed!");
        }
    }

    public void prepareForV2() {
        this.plugin.getMyLogger().logMessage("Upgrading database to v2 of BigDoors!", true, true);
        if (this.getDatabaseVersion() != 9) {
            this.plugin.getMyLogger().logMessage("Failed to upgrade database. Reason: Invalid version. Is the plugin up to date?", true, true);
            return;
        }
        File v2File = new File(this.plugin.getDataFolder(), "structures.db");
        try {
            if (v2File.exists()) {
                this.plugin.getMyLogger().severe("File already exists: '" + v2File + "'! Database cannot be exported!");
                return;
            }
            if (!v2File.createNewFile()) {
                this.plugin.getMyLogger().severe("Failed to create file: '" + v2File + "'! Database cannot be exported!");
                return;
            }
        }
        catch (Exception e) {
            this.plugin.getMyLogger().severe("Failed to create v2 file!\n" + Util.throwableToString(e));
        }
        String v2Url = SQLiteJDBCDriverConnection.getConnectionUrl(v2File);
        long startTime = System.nanoTime();
        this.locked.set(true);
        try (Connection connV2 = this.getConnectionUnsafe(v2Url);){
            this.setDBVersion(connV2, 99);
        }
        catch (NullPointerException | SQLException e) {
            this.logMessage("486", e);
        }
        try (Connection connV1 = this.getConnectionUnsafe();
             Connection connV2 = this.getConnectionUnsafe(v2Url);){
            int seqPlayers;
            this.plugin.getMyLogger().warn("Optimizing database!");
            SQLiteJDBCDriverConnection.optimizeDatabase(connV1);
            this.plugin.getMyLogger().warn("Upgrading database!");
            try (ResultSet seqPlayersRs = connV1.prepareStatement("SELECT * FROM sqlite_sequence WHERE name = 'players'").executeQuery();){
                if (!seqPlayersRs.next()) {
                    this.plugin.getMyLogger().severe("Could not find sequence for player table!");
                    return;
                }
                seqPlayers = Math.max(10, seqPlayersRs.getInt("seq"));
            }
            new V2ExportUtil(this.plugin, seqPlayers).export(connV1, connV2);
        }
        catch (NullPointerException | SQLException e) {
            this.logMessage("434", e);
        }
        this.locked.set(false);
        long endTime = System.nanoTime();
        long duration = (endTime - startTime) / 1000000L;
        this.plugin.getMyLogger().warn("Database upgrade completed in " + duration + "ms! Please upgrade to replace BigDoors with Animated Architecture now!");
    }

    static void optimizeDatabase(Connection conn) throws SQLException {
        conn.prepareStatement("VACUUM;").execute();
        conn.prepareStatement("PRAGMA integrity_check(1);").execute();
        conn.prepareStatement("PRAGMA foreign_key_check;").execute();
        conn.prepareStatement("PRAGMA analysis_limit=0; PRAGMA optimize;").execute();
    }

    private void disableForeignKeys(Connection conn) throws SQLException {
        conn.createStatement().execute("PRAGMA foreign_keys=OFF");
        conn.createStatement().execute("PRAGMA legacy_alter_table=ON");
    }

    private void reEnableForeignKeys(Connection conn) throws SQLException {
        conn.createStatement().execute("PRAGMA foreign_keys=ON");
        conn.createStatement().execute("PRAGMA legacy_alter_table=OFF");
    }

    public void recreateTables() {
        PreparedStatement insertStatement;
        String insert;
        ResultSet rs1;
        Connection conn;
        try {
            conn = DriverManager.getConnection(this.url);
            try {
                this.disableForeignKeys(conn);
                this.plugin.getMyLogger().warn("Upgrading database: Recreating doors table now!");
                conn.createStatement().execute("ALTER TABLE doors RENAME TO doors_old;");
                conn.createStatement().execute("CREATE TABLE IF NOT EXISTS doors\n(id            INTEGER    PRIMARY KEY autoincrement,\n name          TEXT       NOT NULL,\n world         TEXT       NOT NULL,\n xMin          INTEGER    NOT NULL,\n yMin          INTEGER    NOT NULL,\n zMin          INTEGER    NOT NULL,\n xMax          INTEGER    NOT NULL,\n yMax          INTEGER    NOT NULL,\n zMax          INTEGER    NOT NULL,\n engineX       INTEGER    NOT NULL,\n engineY       INTEGER    NOT NULL,\n engineZ       INTEGER    NOT NULL,\n bitflag       INTEGER    NOT NULL DEFAULT 0,\n type          INTEGER    NOT NULL DEFAULT  0,\n powerBlockX   INTEGER    NOT NULL DEFAULT -1,\n powerBlockY   INTEGER    NOT NULL DEFAULT -1,\n powerBlockZ   INTEGER    NOT NULL DEFAULT -1,\n openDirection INTEGER    NOT NULL DEFAULT  0,\n autoClose     INTEGER    NOT NULL DEFAULT -1,\n chunkHash     INTEGER    NOT NULL DEFAULT -1,\n blocksToMove  INTEGER    NOT NULL DEFAULT -1);");
                rs1 = conn.prepareStatement("SELECT * FROM doors_old;").executeQuery();
                while (rs1.next()) {
                    insert = "INSERT INTO doors(id, name,world,xMin,yMin,zMin,xMax,yMax,zMax,\n                  engineX,engineY,engineZ,bitflag,type,\n                  powerBlockX,powerBlockY,powerBlockZ,openDirection,\n                  autoClose,chunkHash,blocksToMove) \n                  VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
                    insertStatement = conn.prepareStatement(insert);
                    insertStatement.setLong(1, rs1.getLong("id"));
                    insertStatement.setString(2, rs1.getString("name"));
                    insertStatement.setString(3, rs1.getString("world"));
                    insertStatement.setLong(4, rs1.getLong("xMin"));
                    insertStatement.setLong(5, rs1.getLong("yMin"));
                    insertStatement.setLong(6, rs1.getLong("zMin"));
                    insertStatement.setLong(7, rs1.getLong("xMax"));
                    insertStatement.setLong(8, rs1.getLong("yMax"));
                    insertStatement.setLong(9, rs1.getLong("zMax"));
                    insertStatement.setLong(10, rs1.getLong("engineX"));
                    insertStatement.setLong(11, rs1.getLong("engineY"));
                    insertStatement.setLong(12, rs1.getLong("engineZ"));
                    insertStatement.setLong(13, rs1.getLong("bitflag"));
                    insertStatement.setLong(14, rs1.getLong("type"));
                    insertStatement.setLong(15, rs1.getLong("powerBlockX"));
                    insertStatement.setLong(16, rs1.getLong("powerBlockY"));
                    insertStatement.setLong(17, rs1.getLong("powerBlockZ"));
                    insertStatement.setLong(18, rs1.getLong("openDirection"));
                    insertStatement.setLong(19, rs1.getLong("autoClose"));
                    insertStatement.setLong(20, rs1.getLong("chunkHash"));
                    insertStatement.setLong(21, rs1.getLong("blocksToMove"));
                    insertStatement.executeUpdate();
                    insertStatement.close();
                }
                rs1.close();
                conn.createStatement().execute("DROP TABLE IF EXISTS 'doors_old';");
                this.plugin.getMyLogger().info("Doors table has been recreated! On the the next step!");
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (NullPointerException | SQLException e) {
            this.logMessage("670", e);
        }
        try {
            conn = DriverManager.getConnection(this.url);
            try {
                this.disableForeignKeys(conn);
                this.plugin.getMyLogger().warn("Upgrading database: Recreating players table now!");
                conn.createStatement().execute("ALTER TABLE players RENAME TO players_old;");
                conn.createStatement().execute("CREATE TABLE IF NOT EXISTS players \n(id          INTEGER    PRIMARY KEY AUTOINCREMENT, \n playerUUID  TEXT       NOT NULL, \n playerName  TEXT       NOT NULL, \n unique(playerUUID));");
                rs1 = conn.prepareStatement("SELECT * FROM players_old;").executeQuery();
                while (rs1.next()) {
                    insert = "INSERT INTO players(id, playerUUID, playerName) VALUES(?,?,?);";
                    insertStatement = conn.prepareStatement(insert);
                    insertStatement.setLong(1, rs1.getLong("id"));
                    insertStatement.setString(2, rs1.getString("playerUUID"));
                    insertStatement.setString(3, rs1.getString("playerName"));
                    insertStatement.executeUpdate();
                    insertStatement.close();
                }
                rs1.close();
                conn.createStatement().execute("DROP TABLE IF EXISTS 'players_old';");
                this.plugin.getMyLogger().info("Players table has been recreated! On the the next step!");
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (NullPointerException | SQLException e) {
            this.logMessage("314", e);
        }
        try {
            conn = DriverManager.getConnection(this.url);
            try {
                this.disableForeignKeys(conn);
                this.plugin.getMyLogger().warn("Upgrading database: Recreating slqUnion table now!");
                conn.createStatement().execute("ALTER TABLE sqlUnion RENAME TO sqlUnion_old;");
                conn.createStatement().execute("CREATE TABLE IF NOT EXISTS sqlUnion\n(id          INTEGER    PRIMARY KEY AUTOINCREMENT,\n permission  INTEGER    NOT NULL,\n playerID    REFERENCES players(id) ON UPDATE CASCADE ON DELETE CASCADE,\n doorUID     REFERENCES doors(id)   ON UPDATE CASCADE ON DELETE CASCADE, \n unique (playerID, doorUID));");
                rs1 = conn.prepareStatement("SELECT * FROM sqlUnion_old;").executeQuery();
                while (rs1.next()) {
                    insert = "INSERT INTO sqlUnion(id, permission, playerID, doorUID) VALUES(?,?,?,?);";
                    insertStatement = conn.prepareStatement(insert);
                    insertStatement.setLong(1, rs1.getLong("id"));
                    insertStatement.setLong(2, rs1.getLong("permission"));
                    insertStatement.setLong(3, rs1.getLong("playerID"));
                    insertStatement.setLong(4, rs1.getLong("doorUID"));
                    insertStatement.executeUpdate();
                    insertStatement.close();
                }
                rs1.close();
                conn.createStatement().execute("DROP TABLE IF EXISTS 'sqlUnion_old';");
                this.plugin.getMyLogger().info("slqUnion table has been recreated! On the the next step!");
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (NullPointerException | SQLException e) {
            this.logMessage("314", e);
        }
    }

    private long getPlayerID(Connection conn, String playerUUID) throws SQLException {
        long playerID = -1L;
        PreparedStatement ps1 = conn.prepareStatement("SELECT * FROM players WHERE playerUUID = '" + playerUUID + "';");
        ResultSet rs1 = ps1.executeQuery();
        while (rs1.next()) {
            playerID = rs1.getLong(1);
        }
        ps1.close();
        rs1.close();
        return playerID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getOrInsertPlayerID(Connection conn, UUID playerUUID) throws SQLException {
        long playerID = this.getPlayerID(conn, playerUUID.toString());
        if (playerID >= 0L) {
            return playerID;
        }
        String statementString = "INSERT INTO players (playerUUID, playerName) VALUES (?,?)";
        if (this.supportsReturningClause) {
            statementString = statementString + " RETURNING id";
        }
        statementString = statementString + ";";
        String userName = Objects.requireNonNull(Util.nameFromUUID(playerUUID), "player name cannot be null!");
        try (PreparedStatement statement = conn.prepareStatement(statementString);){
            long l;
            block15: {
                statement.setString(1, playerUUID.toString());
                statement.setString(2, userName);
                ResultSet insertedPlayerId = null;
                try {
                    if (this.supportsReturningClause) {
                        insertedPlayerId = statement.executeQuery();
                    } else {
                        statement.executeUpdate();
                        insertedPlayerId = statement.getGeneratedKeys();
                    }
                    if (!insertedPlayerId.next()) {
                        throw new SQLException("Failed to find ID of recently inserted door! RETURNING clause supported: " + this.supportsReturningClause);
                    }
                    l = insertedPlayerId.getLong(1);
                    if (insertedPlayerId == null) break block15;
                }
                catch (Throwable throwable) {
                    if (insertedPlayerId != null) {
                        insertedPlayerId.close();
                    }
                    throw throwable;
                }
                insertedPlayerId.close();
            }
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPermission(String playerUUID, long doorUID) {
        Connection conn = null;
        int ret = -1;
        try {
            conn = this.getConnection();
            long playerID = this.getPlayerID(conn, playerUUID);
            if (playerID == -1L) {
                int n = -1;
                return n;
            }
            PreparedStatement ps2 = conn.prepareStatement("SELECT * FROM sqlUnion WHERE playerID = '" + playerID + "' AND doorUID = '" + doorUID + "';");
            ResultSet rs2 = ps2.executeQuery();
            while (rs2.next()) {
                ret = rs2.getInt(2);
            }
            ps2.close();
            rs2.close();
        }
        catch (NullPointerException | SQLException e) {
            this.logMessage("244", e);
        }
        finally {
            try {
                conn.close();
            }
            catch (NullPointerException | SQLException e) {
                this.logMessage("254", e);
            }
        }
        return ret;
    }

    public Map<DoorType, Integer> getDatabaseStatistics() {
        EnumMap<DoorType, Integer> stats = new EnumMap<DoorType, Integer>(DoorType.class);
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement("SELECT type, COUNT(type) AS count FROM doors GROUP BY type ORDER BY type;");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                DoorType type = DoorType.valueOf(rs.getInt("type"));
                if (type == null) continue;
                int count = rs.getInt("count");
                stats.put(type, count);
            }
        }
        catch (NullPointerException | SQLException e) {
            this.logMessage("747", e);
        }
        return stats;
    }

    private Door newDoorFromRS(ResultSet rs, long doorUID, int permission, UUID playerUUID, String playerName, UUID primeOwner) {
        try {
            World world = Bukkit.getServer().getWorld(UUID.fromString(rs.getString(3)));
            Location min = new Location(world, (double)rs.getInt(5), (double)rs.getInt(6), (double)rs.getInt(7));
            Location max = new Location(world, (double)rs.getInt(8), (double)rs.getInt(9), (double)rs.getInt(10));
            Location engine = new Location(world, (double)rs.getInt(11), (double)rs.getInt(12), (double)rs.getInt(13));
            Location powerB = new Location(world, (double)rs.getInt(17), (double)rs.getInt(18), (double)rs.getInt(19));
            Door door = new Door(playerUUID, playerName, primeOwner, world, min, max, engine, rs.getString(2), rs.getInt(4) == 1, doorUID, rs.getInt(14) == 1, permission, DoorType.valueOf(rs.getInt(15)), DoorDirection.valueOf(rs.getInt(16)), powerB, RotateDirection.valueOf(rs.getInt(20)), rs.getInt(21), rs.getBoolean(24), rs.getBoolean(25));
            door.setBlocksToMove(rs.getInt(23));
            return door;
        }
        catch (NullPointerException | SQLException e) {
            this.logMessage("282", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Door removeDoor(long doorID) {
        Door door = this.getDoor(null, doorID);
        if (door == null) {
            return null;
        }
        Connection conn = null;
        try {
            conn = this.getConnection();
            conn.setAutoCommit(false);
            PreparedStatement ps0 = conn.prepareStatement("SELECT chunkHash FROM doors WHERE id = ?;");
            ps0.setLong(1, doorID);
            ResultSet rs0 = ps0.executeQuery();
            if (rs0.next()) {
                String deleteDoor = "DELETE FROM doors WHERE id = '" + doorID + "';";
                PreparedStatement ps = conn.prepareStatement(deleteDoor);
                ps.executeUpdate();
                ps.close();
            }
            ps0.close();
            rs0.close();
            conn.commit();
        }
        catch (NullPointerException | SQLException e) {
            this.plugin.getMyLogger().logMessageToLogFile("271: " + Util.throwableToString(e));
            Door door2 = null;
            return door2;
        }
        finally {
            try {
                conn.close();
            }
            catch (NullPointerException | SQLException e) {
                this.logMessage("311", e);
            }
        }
        return door;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Door> removeDoorsFromWorld(World world) {
        ArrayList<Door> doors = this.getDoorsInWorld(world);
        Connection conn = null;
        try {
            conn = this.getConnection();
            conn.setAutoCommit(false);
            PreparedStatement ps = conn.prepareStatement("DELETE FROM doors WHERE world = ?;");
            ps.setString(1, world.getUID().toString());
            ps.executeUpdate();
            ps.close();
            conn.commit();
        }
        catch (NullPointerException | SQLException e) {
            this.plugin.getMyLogger().logMessageToLogFile("271: " + Util.throwableToString(e));
            List<Door> list = Collections.emptyList();
            return list;
        }
        finally {
            try {
                conn.close();
            }
            catch (NullPointerException | SQLException e) {
                this.logMessage("807", e);
            }
        }
        return doors;
    }

    public Door getDoor(@Nullable UUID playerUUID, long doorUID) {
        return this.getDoor(playerUUID, doorUID, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Door getDoor(@Nullable UUID playerUUID, long doorUID, boolean includeNonOwners) {
        Door door = null;
        Connection conn = null;
        try {
            conn = this.getConnection();
            int permission = -1;
            String playerName = null;
            UUID primeOwner = null;
            if (playerUUID != null) {
                long playerID = this.getPlayerID(conn, playerUUID.toString());
                if (playerID == -1L) {
                    Door door2 = null;
                    return door2;
                }
                playerName = this.getPlayerName(playerUUID);
                PreparedStatement ps2 = conn.prepareStatement("SELECT * FROM sqlUnion WHERE playerID = '" + playerID + "' AND doorUID = '" + doorUID + "';");
                ResultSet rs2 = ps2.executeQuery();
                while (rs2.next()) {
                    permission = rs2.getInt(2);
                }
                ps2.close();
                rs2.close();
                if (permission == -1 && !includeNonOwners) {
                    Door door3 = null;
                    return door3;
                }
                if (permission == 0) {
                    primeOwner = playerUUID;
                }
            }
            if (playerUUID == null || playerName == null) {
                permission = 2;
                DoorOwner doorOwner = this.getOwnerOfDoor(conn, doorUID);
                if (doorOwner == null) {
                    BigDoors.get().getMyLogger().warn("Door retrieval failure: No default DoorOwner for door " + doorUID + "!");
                    Door door4 = null;
                    return door4;
                }
                playerUUID = doorOwner.getPlayerUUID();
                playerName = doorOwner.getPlayerName();
                primeOwner = playerUUID;
            }
            if (primeOwner == null) {
                primeOwner = this.getPrimeOwner(conn, doorUID);
            }
            if (primeOwner == null) {
                Door doorOwner = null;
                return doorOwner;
            }
            PreparedStatement ps3 = conn.prepareStatement("SELECT * FROM doors WHERE id = '" + doorUID + "';");
            ResultSet rs3 = ps3.executeQuery();
            while (rs3.next()) {
                door = this.newDoorFromRS(rs3, doorUID, permission, playerUUID, playerName, primeOwner);
            }
            ps3.close();
            rs3.close();
        }
        catch (NullPointerException | SQLException e) {
            this.logMessage("521", e);
        }
        finally {
            try {
                conn.close();
            }
            catch (NullPointerException | SQLException e) {
                this.logMessage("531", e);
            }
        }
        return door;
    }

    @Nullable
    private UUID getPrimeOwner(Connection conn, long doorUID) throws SQLException {
        UUID primeOwner = null;
        PreparedStatement ps = conn.prepareStatement("SELECT playerUUID \nFROM sqlUnion \nINNER JOIN players ON sqlUnion.playerID = players.id\nWHERE doorUID = '" + doorUID + "' AND permission = 0;");
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            primeOwner = UUID.fromString(rs.getString(1));
        }
        ps.close();
        rs.close();
        if (primeOwner == null) {
            BigDoors.get().getMyLogger().warn("Failed to find prime owner of door " + doorUID);
        }
        return primeOwner;
    }

    public Set<Door> getDoors() {
        HashSet<Door> doors = new HashSet<Door>();
        try (Connection conn = this.getConnection();
             PreparedStatement stmp = conn.prepareStatement("SELECT DISTINCT (d.id), name, world, isopen, xmin, ymin, zmin, xmax, ymax, zmax, enginex, enginey, enginez, islocked, type, engineside, powerblockx, powerblocky, powerblockz, opendirection, autoclose, chunkhash, blockstomove, notify, p.playername, p.playeruuid from (SELECT d.*, u.playerid FROM doors d left join sqlUnion u on d.id = u.doorUID where u.permission = 0) d left join players p on p.id = d.playerid");
             ResultSet rs = stmp.executeQuery();){
            while (rs.next()) {
                UUID playerUUID = UUID.fromString(rs.getString("playerUUID"));
                doors.add(this.newDoorFromRS(rs, rs.getInt(1), 0, playerUUID, rs.getString("playername"), playerUUID));
            }
        }
        catch (NullPointerException | SQLException e) {
            this.logMessage("541", e);
            return Collections.emptySet();
        }
        return doors;
    }

    public ArrayList<Door> getDoors(String playerUUID, String name) {
        return this.getDoors(playerUUID, name, 0L, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Door> getDoors(String name) {
        ArrayList<Door> doors = new ArrayList<Door>();
        Connection conn = null;
        try {
            conn = this.getConnection();
            PreparedStatement ps1 = conn.prepareStatement("SELECT * FROM doors WHERE name = '" + name + "';");
            ResultSet rs1 = ps1.executeQuery();
            while (rs1.next()) {
                UUID foundPlayerUUID = null;
                String playerName = null;
                int permission = -1;
                PreparedStatement ps2 = conn.prepareStatement("SELECT * FROM sqlUnion WHERE doorUID = '" + rs1.getLong(1) + "';");
                ResultSet rs2 = ps2.executeQuery();
                while (rs2.next()) {
                    permission = rs2.getInt(2);
                    PreparedStatement ps3 = conn.prepareStatement("SELECT * FROM players WHERE id = '" + rs2.getInt(3) + "';");
                    ResultSet rs3 = ps3.executeQuery();
                    while (rs3.next()) {
                        foundPlayerUUID = UUID.fromString(rs3.getString(2));
                        playerName = rs3.getString(3);
                    }
                    ps3.close();
                    rs3.close();
                }
                ps2.close();
                rs2.close();
                long doorUID = rs1.getLong(1);
                UUID primeOwner = null;
                primeOwner = permission == 0 ? foundPlayerUUID : this.getPrimeOwner(conn, doorUID);
                if (primeOwner == null) {
                    ArrayList<Door> arrayList = null;
                    return arrayList;
                }
                doors.add(this.newDoorFromRS(rs1, doorUID, permission, foundPlayerUUID, playerName, primeOwner));
            }
            ps1.close();
            rs1.close();
        }
        catch (NullPointerException | SQLException e) {
            this.logMessage("582", e);
        }
        finally {
            try {
                conn.close();
            }
            catch (NullPointerException | SQLException e) {
                this.logMessage("592", e);
            }
        }
        return doors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Door> getDoors(String playerUUIDStr, String name, long start, long end) {
        ArrayList<Door> doors = new ArrayList<Door>();
        Connection conn = null;
        try {
            conn = this.getConnection();
            long playerID = this.getPlayerID(conn, playerUUIDStr);
            UUID playerUUID = UUID.fromString(playerUUIDStr);
            String playerName = this.getPlayerName(playerUUID);
            PreparedStatement ps2 = conn.prepareStatement("SELECT * FROM sqlUnion WHERE playerID = '" + playerID + "';");
            ResultSet rs2 = ps2.executeQuery();
            int count = 0;
            while (rs2.next()) {
                PreparedStatement ps3 = conn.prepareStatement("SELECT * FROM doors WHERE id = '" + rs2.getInt(4) + "';");
                ResultSet rs3 = ps3.executeQuery();
                while (rs3.next()) {
                    if ((name == null || rs3.getString(2).equals(name)) && (long)count >= start && (long)count <= end) {
                        int permission = rs2.getInt(2);
                        long doorUID = rs3.getLong(1);
                        UUID primeOwner = null;
                        primeOwner = permission == 0 ? playerUUID : this.getPrimeOwner(conn, doorUID);
                        if (primeOwner == null) continue;
                        doors.add(this.newDoorFromRS(rs3, doorUID, permission, playerUUID, playerName, primeOwner));
                    }
                    ++count;
                }
                ps3.close();
                rs3.close();
            }
            ps2.close();
            rs2.close();
        }
        catch (NullPointerException | SQLException e) {
            this.logMessage("631", e);
        }
        finally {
            try {
                conn.close();
            }
            catch (NullPointerException | SQLException e) {
                this.logMessage("641", e);
            }
        }
        return doors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Door> getDoorsInWorld(World world) {
        ArrayList<Door> doors = new ArrayList<Door>();
        Connection conn = null;
        try {
            conn = this.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT * FROM doors WHERE world = ?;");
            ps.setString(1, world.getUID().toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                long doorUID = rs.getLong(1);
                DoorOwner doorOwner = this.getOwnerOfDoor(conn, doorUID);
                if (doorOwner == null) {
                    this.plugin.getMyLogger().logMessageToConsole("Failed to obtain doorOwner of door: " + doorUID + ". This door cannot be constructed!");
                    continue;
                }
                doors.add(this.newDoorFromRS(rs, doorUID, doorOwner.getPermission(), doorOwner.getPlayerUUID(), doorOwner.getPlayerName(), doorOwner.getPlayerUUID()));
            }
            ps.close();
            rs.close();
        }
        catch (NullPointerException | SQLException e) {
            this.logMessage("1051", e);
        }
        finally {
            try {
                conn.close();
            }
            catch (NullPointerException | SQLException e) {
                this.logMessage("1061", e);
            }
        }
        return doors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePlayerName(UUID playerUUID, String playerName) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT * FROM players WHERE playerUUID = '" + playerUUID.toString() + "';");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                if (rs.getString(3) != null && rs.getString(3).equals(playerName)) continue;
                conn.setAutoCommit(false);
                String update = "UPDATE players SET playerName='" + playerName + "' WHERE playerUUID = '" + playerUUID.toString() + "';";
                conn.prepareStatement(update).executeUpdate();
                conn.commit();
            }
            ps.close();
            rs.close();
        }
        catch (NullPointerException | SQLException e) {
            this.logMessage("671", e);
        }
        finally {
            try {
                conn.close();
            }
            catch (NullPointerException | SQLException e) {
                this.logMessage("681", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID getUUIDFromName(String playerName) {
        UUID uuid = null;
        Connection conn = null;
        try {
            conn = this.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT * FROM players WHERE playerName = '" + playerName + "';");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                uuid = UUID.fromString(rs.getString(2));
            }
            ps.close();
            rs.close();
        }
        catch (NullPointerException | SQLException e) {
            this.logMessage("703", e);
        }
        finally {
            try {
                conn.close();
            }
            catch (NullPointerException | SQLException e) {
                this.logMessage("713", e);
            }
        }
        return uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPlayerName(UUID playerUUID) {
        String playerName = null;
        Connection conn = null;
        try {
            conn = this.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT * FROM players WHERE playerUUID = '" + playerUUID.toString() + "';");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                playerName = rs.getString(3);
            }
            ps.close();
            rs.close();
        }
        catch (NullPointerException | SQLException e) {
            this.logMessage("736", e);
        }
        finally {
            try {
                conn.close();
            }
            catch (NullPointerException | SQLException e) {
                this.logMessage("746", e);
            }
        }
        return playerName;
    }

    private DoorOwner getOwnerOfDoor(Connection conn, long doorUID) throws SQLException {
        DoorOwner doorOwner = null;
        String command = "SELECT * FROM sqlUnion WHERE doorUID = '" + doorUID + "' AND permission = '" + 0 + "';";
        PreparedStatement ps1 = conn.prepareStatement(command);
        ResultSet rs1 = ps1.executeQuery();
        while (rs1.next()) {
            PreparedStatement ps2 = conn.prepareStatement("SELECT * FROM players WHERE id = '" + rs1.getInt(3) + "';");
            ResultSet rs2 = ps2.executeQuery();
            while (rs2.next()) {
                doorOwner = new DoorOwner(this.plugin, doorUID, UUID.fromString(rs2.getString(2)), rs1.getInt(2), rs2.getString(3));
            }
            ps2.close();
            rs2.close();
        }
        ps1.close();
        rs1.close();
        return doorOwner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoorOwner getOwnerOfDoor(long doorUID) {
        DoorOwner doorOwner = null;
        Connection conn = null;
        try {
            conn = this.getConnection();
            doorOwner = this.getOwnerOfDoor(conn, doorUID);
        }
        catch (NullPointerException | SQLException e) {
            this.logMessage("788", e);
        }
        finally {
            try {
                conn.close();
            }
            catch (NullPointerException | SQLException e) {
                this.logMessage("798", e);
            }
        }
        return doorOwner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<Long, Long> getPowerBlockData(long chunkHash) {
        HashMap<Long, Long> doors = new HashMap<Long, Long>();
        Connection conn = null;
        try {
            conn = this.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT * FROM doors WHERE chunkHash = '" + chunkHash + "';");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                long locationHash = Util.locationHash(rs.getInt(17), rs.getInt(18), rs.getInt(19), UUID.fromString(rs.getString(3)));
                doors.put(locationHash, rs.getLong(1));
            }
            ps.close();
            rs.close();
        }
        catch (NullPointerException | SQLException e) {
            this.logMessage("828", e);
        }
        finally {
            try {
                conn.close();
            }
            catch (NullPointerException | SQLException e) {
                this.logMessage("838", e);
            }
        }
        return doors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recalculatePowerBlockHashes() {
        Connection conn = null;
        try {
            conn = this.getConnection();
            PreparedStatement ps1 = conn.prepareStatement("SELECT * FROM doors;");
            ResultSet rs1 = ps1.executeQuery();
            while (rs1.next()) {
                long UID = rs1.getLong(1);
                UUID worldUUID = UUID.fromString(rs1.getString(3));
                int x = rs1.getInt(17);
                int z = rs1.getInt(19);
                String update = "UPDATE doors SET chunkHash='" + Util.chunkHashFromLocation(x, z, worldUUID) + "' WHERE id = '" + UID + "';";
                conn.prepareStatement(update).executeUpdate();
            }
            ps1.close();
            rs1.close();
        }
        catch (NullPointerException | SQLException e) {
            this.logMessage("893", e);
        }
        finally {
            try {
                conn.close();
            }
            catch (NullPointerException | SQLException e) {
                this.logMessage("903", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDoorBlocksToMove(long doorID, int blocksToMove) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            conn.setAutoCommit(false);
            String update = "UPDATE doors SET blocksToMove='" + blocksToMove + "' WHERE id = '" + doorID + "';";
            conn.prepareStatement(update).executeUpdate();
            conn.commit();
        }
        catch (NullPointerException | SQLException e) {
            this.logMessage("859", e);
        }
        finally {
            try {
                conn.close();
            }
            catch (NullPointerException | SQLException e) {
                this.logMessage("869", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDoorCoords(long doorID, boolean isOpen, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, DoorDirection engSide) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            conn.setAutoCommit(false);
            String update = "UPDATE doors SET xMin='" + xMin + "',yMin='" + yMin + "',zMin='" + zMin + "',xMax='" + xMax + "',yMax='" + yMax + "',zMax='" + zMax + "',isOpen='" + (isOpen ? 1 : 0) + "',engineSide='" + (engSide == null ? -1 : DoorDirection.getValue(engSide)) + "' WHERE id = '" + doorID + "';";
            conn.prepareStatement(update).executeUpdate();
            conn.commit();
        }
        catch (NullPointerException | SQLException e) {
            this.logMessage("897", e);
        }
        finally {
            try {
                conn.close();
            }
            catch (NullPointerException | SQLException e) {
                this.logMessage("907", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDoorAutoClose(long doorID, int autoClose) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            conn.setAutoCommit(false);
            String update = "UPDATE doors SET autoClose='" + autoClose + "' WHERE id = '" + doorID + "';";
            conn.prepareStatement(update).executeUpdate();
            conn.commit();
        }
        catch (NullPointerException | SQLException e) {
            this.logMessage("928", e);
        }
        finally {
            try {
                conn.close();
            }
            catch (NullPointerException | SQLException e) {
                this.logMessage("938", e);
            }
        }
    }

    public void updateNotify(long doorUID, boolean notify) {
        try (Connection conn = Objects.requireNonNull(this.getConnection());
             PreparedStatement ps = conn.prepareStatement("UPDATE doors SET notify=? WHERE id = ?;");){
            ps.setInt(1, notify ? 1 : 0);
            ps.setLong(2, doorUID);
            ps.executeUpdate();
        }
        catch (Exception e) {
            this.logMessage("Updating notify for door " + doorUID, e);
        }
    }

    public void updateBypassProtections(long doorUID, boolean bypassProtections) {
        try (Connection conn = Objects.requireNonNull(this.getConnection());
             PreparedStatement ps = conn.prepareStatement("UPDATE doors SET bypass_protections=? WHERE id = ?;");){
            ps.setInt(1, bypassProtections ? 1 : 0);
            ps.setLong(2, doorUID);
            ps.executeUpdate();
        }
        catch (Exception e) {
            this.logMessage("Updating BypassProtections for door " + doorUID, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDoorOpenDirection(long doorID, RotateDirection openDir) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            conn.setAutoCommit(false);
            String update = "UPDATE doors SET openDirection='" + RotateDirection.getValue(openDir) + "' WHERE id = '" + doorID + "';";
            conn.prepareStatement(update).executeUpdate();
            conn.commit();
        }
        catch (NullPointerException | SQLException e) {
            this.logMessage("958", e);
        }
        finally {
            try {
                conn.close();
            }
            catch (NullPointerException | SQLException e) {
                this.logMessage("966", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDoorPowerBlockLoc(long doorID, int xPos, int yPos, int zPos, UUID worldUUID) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            conn.setAutoCommit(false);
            String update = "UPDATE doors SET powerBlockX='" + xPos + "',powerBlockY='" + yPos + "',powerBlockZ='" + zPos + "',chunkHash='" + Util.chunkHashFromLocation(xPos, zPos, worldUUID) + "' WHERE id = '" + doorID + "';";
            conn.prepareStatement(update).executeUpdate();
            conn.commit();
        }
        catch (NullPointerException | SQLException e) {
            this.logMessage("992", e);
        }
        finally {
            try {
                conn.close();
            }
            catch (NullPointerException | SQLException e) {
                this.logMessage("1002", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPowerBlockLocationEmpty(Location loc) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT * FROM doors WHERE powerBlockX = '" + loc.getBlockX() + "' AND powerBlockY = '" + loc.getBlockY() + "' AND powerBlockZ = '" + loc.getBlockZ() + "' AND world = '" + loc.getWorld().getUID().toString() + "';");
            ResultSet rs = ps.executeQuery();
            boolean isAvailable = true;
            if (rs.next()) {
                isAvailable = false;
            }
            ps.close();
            rs.close();
            boolean bl = isAvailable;
            return bl;
        }
        catch (NullPointerException | SQLException e) {
            this.logMessage("1033", e);
        }
        finally {
            try {
                conn.close();
            }
            catch (NullPointerException | SQLException e) {
                this.logMessage("1043", e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLock(long doorID, boolean newLockStatus) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            conn.setAutoCommit(false);
            String update = "UPDATE doors SET isLocked='" + (newLockStatus ? 1 : 0) + "' WHERE id='" + doorID + "';";
            conn.prepareStatement(update).executeUpdate();
            conn.commit();
        }
        catch (NullPointerException | SQLException e) {
            this.logMessage("1066", e);
        }
        finally {
            try {
                conn.close();
            }
            catch (NullPointerException | SQLException e) {
                this.logMessage("1076", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long insert(Door door) {
        long l;
        block17: {
            Connection conn = this.getConnection();
            try {
                long doorUID;
                long playerID = this.getOrInsertPlayerID(conn, door.getPlayerUUID());
                String doorInsertsql = "INSERT INTO doors(name,world,isOpen,xMin,yMin,zMin,xMax,yMax,zMax,engineX,engineY,engineZ,isLocked,type,engineSide,powerBlockX,powerBlockY,powerBlockZ,openDirection,autoClose,chunkHash,blocksToMove,notify,bypass_protections) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                if (this.supportsReturningClause) {
                    doorInsertsql = doorInsertsql + " RETURNING id";
                }
                PreparedStatement doorstatement = conn.prepareStatement(doorInsertsql);
                doorstatement.setString(1, door.getName());
                doorstatement.setString(2, door.getWorld().getUID().toString());
                doorstatement.setInt(3, door.isOpen() ? 1 : 0);
                doorstatement.setInt(4, door.getMinimum().getBlockX());
                doorstatement.setInt(5, door.getMinimum().getBlockY());
                doorstatement.setInt(6, door.getMinimum().getBlockZ());
                doorstatement.setInt(7, door.getMaximum().getBlockX());
                doorstatement.setInt(8, door.getMaximum().getBlockY());
                doorstatement.setInt(9, door.getMaximum().getBlockZ());
                doorstatement.setInt(10, door.getEngine().getBlockX());
                doorstatement.setInt(11, door.getEngine().getBlockY());
                doorstatement.setInt(12, door.getEngine().getBlockZ());
                doorstatement.setInt(13, door.isLocked() ? 1 : 0);
                doorstatement.setInt(14, DoorType.getValue(door.getType()));
                doorstatement.setInt(15, door.getEngSide() == null ? -1 : DoorDirection.getValue(door.getEngSide()));
                doorstatement.setInt(16, door.getEngine().getBlockX());
                doorstatement.setInt(17, door.getEngine().getBlockY() - 1);
                doorstatement.setInt(18, door.getEngine().getBlockZ());
                doorstatement.setInt(19, RotateDirection.getValue(door.getOpenDir()));
                doorstatement.setInt(20, door.getAutoClose());
                doorstatement.setLong(21, door.getPowerBlockChunkHash());
                doorstatement.setLong(22, door.getBlocksToMove());
                doorstatement.setInt(23, door.notificationEnabled() ? 1 : 0);
                doorstatement.setInt(24, door.bypassProtections() ? 1 : 0);
                try (ResultSet insertedDoorId = null;){
                    if (this.supportsReturningClause) {
                        insertedDoorId = doorstatement.executeQuery();
                    } else {
                        doorstatement.executeUpdate();
                        insertedDoorId = doorstatement.getGeneratedKeys();
                    }
                    if (!insertedDoorId.next()) {
                        throw new SQLException("Failed to find ID of recently inserted door! RETURNING clause supported: " + this.supportsReturningClause);
                    }
                    doorUID = insertedDoorId.getLong(1);
                }
                Statement stmt3 = conn.createStatement();
                String sql3 = "INSERT INTO sqlUnion (permission, playerID, doorUID) VALUES ('" + door.getPermission() + "', '" + playerID + "', '" + doorUID + "');";
                stmt3.executeUpdate(sql3);
                stmt3.close();
                l = doorUID;
                if (conn == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NullPointerException | SQLException e) {
                    this.logMessage("1153", e);
                    return -1L;
                }
            }
            conn.close();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeOwner(long doorUID, UUID playerUUID) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            long playerID = this.getPlayerID(conn, playerUUID.toString());
            if (playerID == -1L) {
                this.plugin.getMyLogger().logMessage("Trying to remove player " + playerUUID.toString() + " as ownwer of door " + doorUID + ". But player does not exist!", true, false);
            } else {
                PreparedStatement ps2 = conn.prepareStatement("DELETE FROM sqlUnion WHERE playerID = '" + playerID + "' AND doorUID = '" + doorUID + "' AND permission > '" + 0 + "';");
                ps2.execute();
                ps2.close();
            }
        }
        catch (NullPointerException | SQLException e) {
            this.logMessage("1193", e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                conn.close();
            }
            catch (NullPointerException | SQLException e) {
                this.logMessage("1204", e);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<DoorOwner> getOwnersOfDoor(long doorUID, @Nullable UUID playerUUID) {
        ArrayList<DoorOwner> ret = new ArrayList<DoorOwner>();
        Connection conn = null;
        try {
            conn = this.getConnection();
            PreparedStatement ps1 = conn.prepareStatement("SELECT * FROM sqlUnion WHERE doorUID = '" + doorUID + "';");
            ResultSet rs1 = ps1.executeQuery();
            while (rs1.next()) {
                PreparedStatement ps2 = conn.prepareStatement("SELECT * FROM players WHERE id = '" + rs1.getInt(3) + "';");
                ResultSet rs2 = ps2.executeQuery();
                if (playerUUID == null || !UUID.fromString(rs2.getString(2)).equals(playerUUID)) {
                    ret.add(new DoorOwner(this.plugin, doorUID, UUID.fromString(rs2.getString(2)), rs1.getInt(2), rs2.getString(3)));
                }
                ps2.close();
                rs2.close();
            }
            ps1.close();
            rs1.close();
        }
        catch (NullPointerException | SQLException e) {
            this.logMessage("1234", e);
        }
        finally {
            try {
                conn.close();
            }
            catch (NullPointerException | SQLException e) {
                this.logMessage("1244", e);
            }
        }
        return ret;
    }

    public void addOwner(long doorUID, UUID playerUUID, int permission) {
        try (Connection conn = this.getConnection();){
            long playerID = this.getOrInsertPlayerID(conn, playerUUID);
            PreparedStatement ps3 = conn.prepareStatement("SELECT * FROM sqlUnion WHERE playerID = '" + playerID + "' AND doorUID = '" + doorUID + "';");
            ResultSet rs3 = ps3.executeQuery();
            if (rs3.next()) {
                if (rs3.getInt(2) != permission) {
                    Statement stmt4 = conn.createStatement();
                    String sql4 = "UPDATE sqlUnion SET permission = '" + permission + "' WHERE playerID = '" + playerID + "' AND doorUID = '" + doorUID + "';";
                    stmt4.executeUpdate(sql4);
                    stmt4.close();
                }
            } else {
                Statement stmt4 = conn.createStatement();
                String sql4 = "INSERT INTO sqlUnion (permission, playerID, doorUID) VALUES ('" + permission + "', '" + playerID + "', '" + doorUID + "');";
                stmt4.executeUpdate(sql4);
                stmt4.close();
            }
            ps3.close();
            rs3.close();
        }
        catch (NullPointerException | SQLException e) {
            this.logMessage("1306", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long countDoors(String playerUUID, String name) {
        long count = 0L;
        Connection conn = null;
        try {
            conn = this.getConnection();
            long playerID = this.getPlayerID(conn, playerUUID.toString());
            PreparedStatement ps2 = conn.prepareStatement("SELECT * FROM sqlUnion WHERE playerID = ? AND permission <= ?;");
            ps2.setString(1, Long.toString(playerID));
            ps2.setInt(2, this.plugin.getConfigLoader().countDoorsLevel());
            ResultSet rs2 = ps2.executeQuery();
            while (rs2.next()) {
                PreparedStatement ps3 = conn.prepareStatement("SELECT * FROM doors WHERE id = '" + rs2.getInt(4) + "';");
                ResultSet rs3 = ps3.executeQuery();
                while (rs3.next()) {
                    if (name != null && !rs3.getString(2).equals(name)) continue;
                    ++count;
                }
                ps3.close();
                rs3.close();
            }
            ps2.close();
            rs2.close();
        }
        catch (NullPointerException | SQLException e) {
            this.logMessage("1352", e);
        }
        finally {
            try {
                conn.close();
            }
            catch (NullPointerException | SQLException e) {
                this.logMessage("1362", e);
            }
        }
        return count;
    }

    private int getDatabaseVersion(Connection conn) {
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("PRAGMA user_version;");
            int dbVersion = rs.getInt(1);
            stmt.close();
            rs.close();
            return dbVersion;
        }
        catch (NullPointerException | SQLException e) {
            this.logMessage("1503", e);
            return Integer.MAX_VALUE;
        }
    }

    private int getDatabaseVersion() {
        int n;
        block8: {
            Connection conn = this.getConnection();
            try {
                n = this.getDatabaseVersion(conn);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NullPointerException | SQLException e) {
                    this.logMessage("1498", e);
                    return Integer.MAX_VALUE;
                }
            }
            conn.close();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgrade() {
        Connection conn = null;
        boolean replaceTempPlayerNames = false;
        try {
            conn = DriverManager.getConnection(this.url);
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("PRAGMA user_version;");
            int dbVersion = rs.getInt(1);
            stmt.close();
            rs.close();
            if (dbVersion == 9) {
                conn.close();
                return;
            }
            this.validVersion = false;
            if (dbVersion > 9) {
                this.plugin.getMyLogger().logMessage("Trying to load a database that is incompatible with this version of the plugin! Database version = " + dbVersion + ". Please update the plugin.", true, false);
                conn.close();
                return;
            }
            if (this.plugin.getConfigLoader().dbBackup()) {
                conn.close();
                this.makeBackup();
                conn = this.getConnectionUnsafe();
            }
            if (dbVersion < 1) {
                this.upgradeToV1(conn);
            }
            if (dbVersion < 2) {
                this.upgradeToV2(conn);
            }
            if (dbVersion < 3) {
                this.upgradeToV3(conn);
            }
            if (dbVersion < 4) {
                this.upgradeToV4(conn);
            }
            if (dbVersion < 5) {
                conn.close();
                this.upgradeToV5();
                replaceTempPlayerNames = true;
                conn = this.getConnectionUnsafe();
            }
            if (dbVersion < 6) {
                conn.close();
                this.upgradeToV6();
                conn = this.getConnectionUnsafe();
            }
            if (dbVersion < 7) {
                this.upgradeToV7(conn);
            }
            if (dbVersion < 8) {
                this.upgradeToV8(conn);
            }
            if (dbVersion < 9) {
                this.upgradeToV9(conn);
            }
            if (!replaceTempPlayerNames && this.fakeUUIDExists(conn)) {
                replaceTempPlayerNames = true;
            }
            this.setDBVersion(conn, 9);
            this.validVersion = true;
        }
        catch (NullPointerException | SQLException e) {
            this.logMessage("Database Upgrade", e);
            this.disableDatabase("Failed to upgrade the database! Please check the logs for more information.");
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (NullPointerException | SQLException e) {
                this.logMessage("Closing connection after upgrading the database", e);
            }
        }
        if (replaceTempPlayerNames) {
            this.replaceTempPlayerNames();
        }
    }

    private boolean fakeUUIDExists(Connection conn) {
        try {
            return conn.createStatement().executeQuery("SELECT * FROM players WHERE playerUUID='0000';").next();
        }
        catch (NullPointerException | SQLException e) {
            this.logMessage("1461", e);
            return false;
        }
    }

    private void makeBackup() {
        String extension = ".BACKUP";
        File dbFileBackup = new File(this.plugin.getDataFolder(), this.dbName + ".BACKUP");
        try {
            Files.copy(this.dbFile.toPath(), dbFileBackup.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create a backup of the database!", e);
        }
    }

    private void setDBVersion(Connection conn, int version) {
        try {
            conn.createStatement().execute("PRAGMA user_version = " + version + ";");
        }
        catch (NullPointerException | SQLException e) {
            this.logMessage("Setting DB Version", e);
        }
    }

    private void upgradeToV1(Connection conn) {
        try {
            String update;
            int z;
            long UID;
            ResultSet rs1;
            PreparedStatement ps1;
            String addColumn;
            DatabaseMetaData md = conn.getMetaData();
            ResultSet rs = md.getColumns(null, null, "doors", "type");
            if (!rs.next()) {
                this.plugin.getMyLogger().logMessage("Upgrading database! Adding type!", true, true);
                addColumn = "ALTER TABLE doors ADD COLUMN type int NOT NULL DEFAULT 0";
                conn.createStatement().execute(addColumn);
            }
            rs.close();
            rs = md.getColumns(null, null, "doors", "engineSide");
            if (!rs.next()) {
                this.plugin.getMyLogger().logMessage("Upgrading database! Adding engineSide!", true, true);
                addColumn = "ALTER TABLE doors ADD COLUMN engineSide int NOT NULL DEFAULT -1";
                conn.createStatement().execute(addColumn);
            }
            rs.close();
            rs = md.getColumns(null, null, "doors", "powerBlockX");
            if (!rs.next()) {
                this.plugin.getMyLogger().logMessage("Upgrading database! Adding powerBlockLoc!", true, true);
                addColumn = "ALTER TABLE doors ADD COLUMN powerBlockX int NOT NULL DEFAULT -1";
                conn.createStatement().execute(addColumn);
                addColumn = "ALTER TABLE doors ADD COLUMN powerBlockY int NOT NULL DEFAULT -1";
                conn.createStatement().execute(addColumn);
                addColumn = "ALTER TABLE doors ADD COLUMN powerBlockZ int NOT NULL DEFAULT -1";
                conn.createStatement().execute(addColumn);
                ps1 = conn.prepareStatement("SELECT * FROM doors;");
                rs1 = ps1.executeQuery();
                while (rs1.next()) {
                    UID = rs1.getLong(1);
                    int x = rs1.getInt(11);
                    int y = rs1.getInt(12) - 1;
                    z = rs1.getInt(13);
                    update = "UPDATE doors SET powerBlockX='" + x + "',powerBlockY='" + y + "',powerBlockZ='" + z + "' WHERE id = '" + UID + "';";
                    conn.prepareStatement(update).executeUpdate();
                }
                ps1.close();
                rs1.close();
            }
            rs.close();
            rs = md.getColumns(null, null, "doors", "openDirection");
            if (!rs.next()) {
                this.plugin.getMyLogger().logMessage("Upgrading database! Adding openDirection!", true, true);
                addColumn = "ALTER TABLE doors ADD COLUMN openDirection int NOT NULL DEFAULT 0";
                conn.createStatement().execute(addColumn);
                this.plugin.getMyLogger().logMessage("Upgrading database! Swapping open-status of drawbridges to conform to the new standard!", true, true);
                String update2 = "UPDATE doors SET isOpen='2' WHERE isOpen = '0' AND type = '" + DoorType.getValue(DoorType.DRAWBRIDGE) + "';";
                conn.createStatement().execute(update2);
                update2 = "UPDATE doors SET isOpen='0' WHERE isOpen = '1' AND type = '" + DoorType.getValue(DoorType.DRAWBRIDGE) + "';";
                conn.createStatement().execute(update2);
                update2 = "UPDATE doors SET isOpen='1' WHERE isOpen = '2' AND type = '" + DoorType.getValue(DoorType.DRAWBRIDGE) + "';";
                conn.createStatement().execute(update2);
            }
            rs.close();
            rs = md.getColumns(null, null, "doors", "autoClose");
            if (!rs.next()) {
                this.plugin.getMyLogger().logMessage("Upgrading database! Adding autoClose!", true, true);
                addColumn = "ALTER TABLE doors ADD COLUMN autoClose int NOT NULL DEFAULT -1";
                conn.createStatement().execute(addColumn);
            }
            rs.close();
            rs = md.getColumns(null, null, "doors", "chunkHash");
            if (!rs.next()) {
                this.plugin.getMyLogger().logMessage("Upgrading database! Adding chunkHash!", true, true);
                addColumn = "ALTER TABLE doors ADD COLUMN chunkHash int NOT NULL DEFAULT -1";
                conn.createStatement().execute(addColumn);
                ps1 = conn.prepareStatement("SELECT * FROM doors;");
                rs1 = ps1.executeQuery();
                while (rs1.next()) {
                    UID = rs1.getLong(1);
                    UUID worldUUID = UUID.fromString(rs1.getString(3));
                    int x = rs1.getInt(17);
                    z = rs1.getInt(19);
                    update = "UPDATE doors SET chunkHash='" + Util.chunkHashFromLocation(x, z, worldUUID) + "' WHERE id = '" + UID + "';";
                    conn.prepareStatement(update).executeUpdate();
                }
                ps1.close();
                rs1.close();
            }
            rs.close();
            this.plugin.getMyLogger().logMessage("Database has been upgraded to V1!", true, true);
        }
        catch (NullPointerException | SQLException e) {
            this.logMessage("1593", e);
        }
    }

    private void upgradeToV2(Connection conn) {
        this.plugin.getMyLogger().logMessage("Upgrading database to V2! Adding blocksToMove!", true, true);
        try {
            conn.createStatement().execute("ALTER TABLE doors ADD COLUMN blocksToMove int NOT NULL DEFAULT 0");
        }
        catch (NullPointerException | SQLException e) {
            throw new RuntimeException("Failed to upgrade database to v2!", e);
        }
    }

    private void upgradeToV3(Connection conn) {
        this.plugin.getMyLogger().logMessage("Upgrading database to V3! Recreating sqlUnion!", true, true);
        try {
            conn.setAutoCommit(false);
            this.disableForeignKeys(conn);
            conn.createStatement().execute("ALTER TABLE sqlUnion RENAME TO sqlUnion_old;");
            conn.createStatement().execute("CREATE TABLE IF NOT EXISTS sqlUnion (id          INTEGER    PRIMARY KEY AUTOINCREMENT,  permission  INTEGER    NOT NULL,  playerID    REFERENCES players(id) ON UPDATE CASCADE ON DELETE CASCADE,  doorUID     REFERENCES doors(id)   ON UPDATE CASCADE ON DELETE CASCADE, unique (playerID, doorUID));");
            conn.createStatement().execute("INSERT INTO sqlUnion SELECT * FROM sqlUnion_old;");
            conn.createStatement().execute("DROP TABLE IF EXISTS 'sqlUnion_old';");
            conn.commit();
            conn.setAutoCommit(true);
        }
        catch (NullPointerException | SQLException e) {
            try {
                conn.rollback();
            }
            catch (NullPointerException | SQLException e1) {
                e.addSuppressed(e1);
            }
            throw new RuntimeException("Failed to upgrade database to v3!", e);
        }
        finally {
            try {
                this.reEnableForeignKeys(conn);
            }
            catch (NullPointerException | SQLException e) {
                this.logMessage("Re-enabling foreign keys after upgrading to v3", e);
                this.disableDatabase();
            }
        }
    }

    private void upgradeToV4(Connection conn) {
        this.plugin.getMyLogger().logMessage("Upgrading database to V4! Adding playerName!", true, true);
        try {
            conn.createStatement().execute("ALTER TABLE players ADD COLUMN playerName TEXT DEFAULT NULL");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to upgrade database to v4!", e);
        }
    }

    private void upgradeToV5() {
        Connection conn;
        try {
            conn = this.getConnectionUnsafe();
            try {
                this.plugin.getMyLogger().logMessageToLogFile("Upgrading database to V5!");
                String countStr = "SELECT COUNT(*) AS total FROM players WHERE playerName IS NULL";
                int count = conn.createStatement().executeQuery(countStr).getInt("total");
                if (count > 0) {
                    String fakeName = Util.randomString(12);
                    boolean exists = true;
                    while (exists) {
                        PreparedStatement ps = conn.prepareStatement("SELECT * FROM players WHERE playerName = '" + fakeName + "';");
                        ResultSet rs = ps.executeQuery();
                        if (!rs.next()) {
                            exists = false;
                        }
                        ps.close();
                        rs.close();
                        if (!exists) continue;
                        fakeName = Util.randomString(12);
                    }
                    this.plugin.getMyLogger().logMessageToLogFile("UpgradeToV5: Using fakeName = " + fakeName);
                    Statement stmt = conn.createStatement();
                    String sql = "INSERT INTO players (playerUUID, playerName) VALUES ('0000', '" + fakeName + "');";
                    stmt.executeUpdate(sql);
                    stmt.close();
                    String update = "UPDATE players SET playerName='" + fakeName + "' WHERE playerName IS NULL;";
                    conn.prepareStatement(update).executeUpdate();
                }
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to upgrade database to V5!", e);
        }
        conn = null;
        try {
            conn = DriverManager.getConnection(this.url);
            this.disableForeignKeys(conn);
            conn.setAutoCommit(false);
            conn.createStatement().execute("ALTER TABLE players RENAME TO players_old;");
            conn.createStatement().execute("CREATE TABLE IF NOT EXISTS players (id          INTEGER PRIMARY KEY AUTOINCREMENT,  playerUUID  TEXT    NOT NULL, playerName  TEXT    NOT NULL)");
            conn.createStatement().execute("INSERT INTO players SELECT * FROM players_old;");
            conn.createStatement().execute("DROP TABLE IF EXISTS 'players_old';");
            conn.commit();
            conn.setAutoCommit(true);
        }
        catch (NullPointerException | SQLException e) {
            if (conn != null) {
                try {
                    conn.setAutoCommit(true);
                    conn.rollback();
                }
                catch (Exception e1) {
                    e.addSuppressed(e1);
                }
            }
            throw new RuntimeException("Failed to upgrade database to V5!", e);
        }
        finally {
            try {
                if (conn != null) {
                    this.reEnableForeignKeys(conn);
                    conn.close();
                }
            }
            catch (NullPointerException | SQLException e) {
                this.logMessage("Cleanup after upgrade to V5", e);
                this.disableDatabase();
            }
        }
    }

    private void upgradeToV6() {
        this.plugin.getMyLogger().logMessage("Upgrading database to V6! Recreating table \"players\"!", true, true);
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(this.url);
            this.disableForeignKeys(conn);
            conn.setAutoCommit(false);
            conn.createStatement().execute("ALTER TABLE players RENAME TO players_old;");
            conn.createStatement().execute("CREATE TABLE IF NOT EXISTS players \n(id          INTEGER    PRIMARY KEY AUTOINCREMENT, \n playerUUID  TEXT       NOT NULL, \n playerName  TEXT       NOT NULL, \n unique(playerUUID));");
            ResultSet rs1 = conn.prepareStatement("SELECT * FROM players_old;").executeQuery();
            while (rs1.next()) {
                String insert = "INSERT INTO players(id, playerUUID, playerName) VALUES(?,?,?);";
                PreparedStatement insertStatement = conn.prepareStatement(insert);
                insertStatement.setLong(1, rs1.getLong("id"));
                insertStatement.setString(2, rs1.getString("playerUUID"));
                insertStatement.setString(3, rs1.getString("playerName"));
                insertStatement.executeUpdate();
                insertStatement.close();
            }
            rs1.close();
            conn.createStatement().execute("DROP TABLE IF EXISTS 'players_old';");
            conn.commit();
        }
        catch (Exception e) {
            if (conn != null) {
                try {
                    conn.setAutoCommit(true);
                    conn.rollback();
                }
                catch (Exception e1) {
                    e.addSuppressed(e1);
                }
            }
            throw new RuntimeException("Failed to upgrade database to V6!", e);
        }
        finally {
            try {
                if (conn != null) {
                    this.reEnableForeignKeys(conn);
                    conn.close();
                }
            }
            catch (SQLException e) {
                this.logMessage("Failed to clean up after upgrading to V6! Disabling database", e);
                this.disableDatabase("Cleanup after upgrade to V6");
            }
        }
    }

    private void upgradeToV7(Connection conn) {
        this.plugin.getMyLogger().logMessage("Upgrading database to V7!", true, true);
        try (PreparedStatement statement = conn.prepareStatement("ALTER TABLE doors ADD COLUMN notify INTEGER DEFAULT 0;");){
            statement.execute();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to upgrade database to V7!", e);
        }
    }

    private void upgradeToV8(Connection conn) {
        this.plugin.getMyLogger().logMessage("Upgrading database to V8!", true, true);
        try (PreparedStatement statement = conn.prepareStatement("UPDATE doors set type = type - 1 WHERE type >= 3;");){
            statement.execute();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to upgrade database to V8!", e);
        }
    }

    private void upgradeToV9(Connection conn) {
        this.plugin.getMyLogger().logMessage("Upgrading database to V9!", true, true);
        try (PreparedStatement statement = conn.prepareStatement("ALTER TABLE doors ADD COLUMN bypass_protections INTEGER DEFAULT 0");){
            statement.execute();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to upgrade database to V9!", e);
        }
    }

    private void replaceTempPlayerNames() {
        this.locked.set(true);
        Thread thread = new Thread(() -> {
            Connection conn = null;
            try {
                Class.forName(DRIVER);
                conn = DriverManager.getConnection(this.url);
                conn.createStatement().execute("PRAGMA foreign_keys=ON");
                ResultSet rs1 = conn.createStatement().executeQuery("SELECT * FROM players WHERE playerUUID='0000';");
                String fakeName = null;
                while (rs1.next()) {
                    fakeName = rs1.getString("playerName");
                }
                rs1.close();
                ResultSet rs2 = conn.createStatement().executeQuery("SELECT * FROM players WHERE playerName='" + fakeName + "';");
                while (rs2.next()) {
                    if (rs2.getString("playerUUID").equals(FAKEUUID)) continue;
                    UUID playerUUID = UUID.fromString(rs2.getString("playerUUID"));
                    String playerName = Bukkit.getOfflinePlayer((UUID)playerUUID).getName();
                    String update = "UPDATE players SET playerName='" + playerName + "' WHERE playerUUID='" + playerUUID.toString() + "';";
                    conn.prepareStatement(update).executeUpdate();
                }
                rs2.close();
                String deleteFakePlayer = "DELETE FROM players WHERE playerUUID = '0000';";
                conn.createStatement().executeUpdate(deleteFakePlayer);
            }
            catch (ClassNotFoundException | SQLException e) {
                this.logMessage("1729", e);
            }
            finally {
                try {
                    conn.close();
                }
                catch (NullPointerException | SQLException e) {
                    this.logMessage("1739", e);
                }
                this.locked.set(false);
            }
        });
        thread.start();
    }

    private void logMessage(String str, Exception e) {
        if (!this.locked.get()) {
            this.plugin.getMyLogger().logMessageToLogFile("[" + str + "] " + Util.throwableToString(e));
        } else if (!this.validVersion) {
            this.plugin.getMyLogger().logMessageToLogFile("This version of the database is not supported by this version of the plugin!");
        } else {
            this.plugin.getMyLogger().logMessageToLogFile("Database locked! Failed at: [" + str + "]. Message: " + e.getMessage());
        }
    }
}

