/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.toolUsers;

import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.toolUsers.ToolUser;
import nl.pim16aap2.bigDoors.util.DoorDirection;
import nl.pim16aap2.bigDoors.util.DoorType;
import nl.pim16aap2.bigDoors.util.RotateDirection;
import nl.pim16aap2.bigDoors.util.Util;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

public class DrawbridgeCreator
extends ToolUser {
    public DrawbridgeCreator(BigDoors plugin, Player player, String name) {
        super(plugin, player, name, DoorType.DRAWBRIDGE);
        Util.messagePlayer(player, this.messages.getString("CREATOR.DRAWBRIDGE.Init"));
        this.engineSide = null;
        if (name == null) {
            Util.messagePlayer(player, this.messages.getString("CREATOR.GENERAL.GiveNameInstruc"));
        } else {
            this.triggerGiveTool();
        }
    }

    @Override
    protected void triggerGiveTool() {
        this.giveToolToPlayer(this.messages.getString("CREATOR.DRAWBRIDGE.StickLore").split("\n"), this.messages.getString("CREATOR.DRAWBRIDGE.StickReceived").split("\n"));
    }

    @Override
    protected void triggerFinishUp() {
        this.finishUp(this.messages.getString("CREATOR.DRAWBRIDGE.Success"));
    }

    @Override
    protected boolean isReadyToCreateDoor() {
        return this.one != null && this.two != null && this.engine != null && this.engineSide != null;
    }

    private boolean isEngineValid(Location loc) {
        boolean inArea;
        if (loc.getBlockY() != this.one.getBlockY()) {
            return false;
        }
        boolean onEdge = loc.getBlockX() == this.one.getBlockX() || loc.getBlockX() == this.two.getBlockX() || loc.getBlockZ() == this.one.getBlockZ() || loc.getBlockZ() == this.two.getBlockZ();
        boolean bl = inArea = Util.between(loc.getBlockX(), this.one.getBlockX(), this.two.getBlockX()) && Util.between(loc.getBlockZ(), this.one.getBlockZ(), this.two.getBlockZ());
        if (!onEdge || !inArea || this.engine != null && loc.equals((Object)this.engine)) {
            return false;
        }
        int xDepth = Math.abs(this.one.getBlockX() - this.two.getBlockX());
        int yDepth = Math.abs(this.one.getBlockY() - this.two.getBlockY());
        int zDepth = Math.abs(this.one.getBlockZ() - this.two.getBlockZ());
        if (yDepth == 0) {
            if (xDepth == 0) {
                if (loc.equals((Object)this.one)) {
                    this.engine = this.one;
                    this.engineSide = DoorDirection.NORTH;
                } else if (loc.equals((Object)this.two)) {
                    this.engine = this.two;
                    this.engineSide = DoorDirection.SOUTH;
                }
                return this.engineSide != null;
            }
            if (zDepth == 0) {
                if (loc.equals((Object)this.one)) {
                    this.engine = this.one;
                    this.engineSide = DoorDirection.WEST;
                } else if (loc.equals((Object)this.two)) {
                    this.engine = this.two;
                    this.engineSide = DoorDirection.EAST;
                }
                return this.engineSide != null;
            }
        }
        if (this.engine == null) {
            int posX = loc.getBlockX();
            int posZ = loc.getBlockZ();
            if (loc.equals((Object)this.one) || loc.equals((Object)this.two) || posX == this.one.getBlockX() && posZ == this.two.getBlockZ() || posX == this.two.getBlockX() && posZ == this.one.getBlockZ()) {
                this.engine = loc;
            } else {
                if (posZ == this.one.getBlockZ()) {
                    this.engineSide = DoorDirection.NORTH;
                } else if (posZ == this.two.getBlockZ()) {
                    this.engineSide = DoorDirection.SOUTH;
                } else if (posX == this.one.getBlockX()) {
                    this.engineSide = DoorDirection.WEST;
                } else if (posX == this.two.getBlockX()) {
                    this.engineSide = DoorDirection.EAST;
                }
                this.drawBridgeEngineFix();
            }
            return true;
        }
        if (loc.equals((Object)this.engine)) {
            return false;
        }
        int posXa = this.engine.getBlockX();
        int posZa = this.engine.getBlockZ();
        Vector vector = loc.toVector().subtract(this.engine.toVector());
        vector.normalize();
        if (Math.abs(vector.getX() + vector.getY() + vector.getZ()) != 1.0) {
            return false;
        }
        if (this.engine.equals((Object)this.one)) {
            if (vector.getBlockX() == 1) {
                this.engineSide = DoorDirection.NORTH;
            } else if (vector.getBlockZ() == 1) {
                this.engineSide = DoorDirection.WEST;
            }
        } else if (this.engine.equals((Object)this.two)) {
            if (vector.getBlockX() == -1) {
                this.engineSide = DoorDirection.SOUTH;
            } else if (vector.getBlockZ() == -1) {
                this.engineSide = DoorDirection.EAST;
            }
        } else if (posXa == this.one.getBlockX() && posZa == this.two.getBlockZ()) {
            if (vector.getBlockX() == 1) {
                this.engineSide = DoorDirection.SOUTH;
            } else if (vector.getBlockZ() == -1) {
                this.engineSide = DoorDirection.WEST;
            }
        } else if (posXa == this.two.getBlockX() && posZa == this.one.getBlockZ()) {
            if (vector.getBlockX() == -1) {
                this.engineSide = DoorDirection.NORTH;
            } else if (vector.getBlockZ() == 1) {
                this.engineSide = DoorDirection.EAST;
            }
        } else {
            return false;
        }
        this.drawBridgeEngineFix();
        return this.engineSide != null;
    }

    private void drawBridgeEngineFix() {
        if (this.engineSide == null || this.engine == null) {
            return;
        }
        if (this.engineSide == DoorDirection.NORTH || this.engineSide == DoorDirection.SOUTH) {
            this.engine.setX(this.one.getX() + (this.two.getX() - this.one.getX()) / 2.0);
        } else {
            this.engine.setZ(this.one.getZ() + (this.two.getZ() - this.one.getZ()) / 2.0);
        }
        if (this.isOpen) {
            if (this.engineSide == DoorDirection.NORTH) {
                this.openDir = RotateDirection.SOUTH;
            } else if (this.engineSide == DoorDirection.EAST) {
                this.openDir = RotateDirection.WEST;
            } else if (this.engineSide == DoorDirection.SOUTH) {
                this.openDir = RotateDirection.NORTH;
            } else if (this.engineSide == DoorDirection.WEST) {
                this.openDir = RotateDirection.EAST;
            }
        }
    }

    private boolean isPosTwoValid(Location loc) {
        int xDepth = Math.abs(this.one.getBlockX() - loc.getBlockX());
        int yDepth = Math.abs(this.one.getBlockY() - loc.getBlockY());
        int zDepth = Math.abs(this.one.getBlockZ() - loc.getBlockZ());
        if (yDepth == 0) {
            return xDepth != 0 || zDepth != 0;
        }
        return xDepth != 0 ^ zDepth != 0;
    }

    private void selector(Location loc, @Nullable String canBreakBlock) {
        if (canBreakBlock != null) {
            Util.messagePlayer(this.player, this.messages.getString("CREATOR.GENERAL.NoPermissionHere") + " " + canBreakBlock);
            return;
        }
        if (this.one == null) {
            this.one = loc;
            String[] message = this.messages.getString("CREATOR.DRAWBRIDGE.Step1").split("\n");
            Util.messagePlayer(this.player, message);
        } else if (this.two == null) {
            if (this.isPosTwoValid(loc)) {
                this.two = loc;
                this.isOpen = Math.abs(this.one.getBlockY() - this.two.getBlockY()) <= 0;
                String[] message = this.messages.getString("CREATOR.DRAWBRIDGE.Step2").split("\n");
                Util.messagePlayer(this.player, message);
                this.minMaxFix();
            } else {
                Util.messagePlayer(this.player, this.messages.getString("CREATOR.GENERAL.InvalidPoint"));
            }
        } else if (this.engine == null) {
            if (this.isEngineValid(loc)) {
                this.engine = loc;
                if (this.engineSide != null) {
                    this.drawBridgeEngineFix();
                    this.setIsDone(true);
                } else {
                    Util.messagePlayer(this.player, this.messages.getString("CREATOR.DRAWBRIDGE.Step3"));
                }
            } else {
                Util.messagePlayer(this.player, this.messages.getString("CREATOR.GENERAL.InvalidRotation"));
            }
        } else if (this.engineSide == null) {
            if (this.isEngineValid(loc)) {
                this.drawBridgeEngineFix();
                this.setIsDone(true);
            } else {
                Util.messagePlayer(this.player, this.messages.getString("CREATOR.GENERAL.InvalidRotation"));
            }
        } else {
            this.setIsDone(true);
        }
    }

    @Override
    public void selector(Location loc) {
        if (this.name == null) {
            Util.messagePlayer(this.player, this.messages.getString("CREATOR.GENERAL.GiveNameInstruc"));
            return;
        }
        this.plugin.canBreakBlock(this.player.getUniqueId(), this.player.getName(), loc).thenApply(canBreakBlock -> BigDoors.getScheduler().runTask(loc, () -> this.selector(loc, (String)canBreakBlock)));
    }
}

