/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.util;

import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public enum DoorAttribute {
    LOCK(2, "bigdoors.user.lock", "bigdoors.admin.bypass.lock"),
    TOGGLE(2, "bigdoors.user.toggledoor", "bigdoors.admin.bypass.toggle"),
    INFO(2, "bigdoors.user.doorinfo", "bigdoors.admin.bypass.info"),
    DELETE(0, "bigdoors.user.delete", "bigdoors.admin.bypass.delete"),
    RELOCATEPOWERBLOCK(1, "bigdoors.user.relocatepowerblock", "bigdoors.admin.bypass.relocatepowerblock"),
    CHANGETIMER(1, "bigdoors.user.setautoclosetime", "bigdoors.admin.bypass.changetimer"),
    DIRECTION_STRAIGHT(1, "bigdoors.user.direction", "bigdoors.admin.bypass.direction"),
    DIRECTION_ROTATE(1, DoorAttribute.DIRECTION_STRAIGHT.userPermission, DoorAttribute.DIRECTION_STRAIGHT.adminPermission),
    BLOCKSTOMOVE(1, "bigdoors.user.setblockstomove", "bigdoors.admin.bypass.blockstomove"),
    ADDOWNER(0, "bigdoors.user.addowner", "bigdoors.admin.bypass.addowner"),
    REMOVEOWNER(0, "bigdoors.user.removeowner", "bigdoors.admin.bypass.removeowner"),
    NOTIFICATIONS(0, "bigdoors.user.receivenotifications", null),
    BYPASS_PROTECTIONS(2, null, "bigdoors.admin.setbypassprotections");

    @Nullable
    private final String userPermission;
    @Nullable
    private final String adminPermission;
    private final int permissionLevel;

    private DoorAttribute(@Nullable int permissionLevel, String userPermission, String adminPermission) {
        this.permissionLevel = permissionLevel;
        this.adminPermission = adminPermission;
        this.userPermission = userPermission;
    }

    public int getPermissionLevel() {
        return this.permissionLevel;
    }

    public boolean hasUserPermission(Player player) {
        return this.userPermission != null && player.hasPermission(this.userPermission);
    }

    public boolean hasAdminPermission(Player player) {
        return this.adminPermission != null && player.hasPermission(this.adminPermission);
    }

    public boolean hasAnyPermission(Player player) {
        return this.hasUserPermission(player) || this.hasAdminPermission(player);
    }
}

