/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.util;

import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LazyInit<T> {
    @NotNull
    private final Supplier<T> supplier;
    @Nullable
    private volatile T obj;

    public LazyInit(@NotNull Supplier<T> supplier) {
        this.supplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        @Nullable T tmp = this.obj;
        if (tmp != null) {
            return tmp;
        }
        LazyInit lazyInit = this;
        synchronized (lazyInit) {
            tmp = this.obj;
            if (tmp == null) {
                tmp = this.obj = this.supplier.get();
            }
            return Objects.requireNonNull(tmp, "Instance obtained from supplier must not be null!");
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LazyInit)) {
            return false;
        }
        @NotNull LazyInit other = (LazyInit)o;
        return Objects.equals(this.supplier, other.supplier) && Objects.equals(this.get(), other.get());
    }

    public int hashCode() {
        return Objects.hash(this.get(), this.supplier);
    }

    @NotNull
    public String toString() {
        return "LazyInit(obj=" + this.obj + ")";
    }
}

