/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import nl.pim16aap2.bigDoors.BigDoors;

public class Messages {
    private static final List<String> DEFAULT_LOCALES = Collections.unmodifiableList(Arrays.asList("en_US.txt", "zh_CN.txt"));
    private final HashMap<String, String> messageMap = new HashMap();
    private final BigDoors plugin;
    private String locale;
    private File textFile;

    public Messages(BigDoors plugin) {
        this.plugin = plugin;
        this.reloadMessages();
    }

    public void reloadMessages() {
        this.messageMap.clear();
        this.locale = this.plugin.getLocale();
        String fileName = this.locale.endsWith(".txt") ? this.locale : this.locale + ".txt";
        this.textFile = new File(this.plugin.getDataFolder(), fileName);
        this.readFile();
    }

    private void writeDefaultFile(String fileName) {
        boolean replace;
        File defaultFile = new File(this.plugin.getDataFolder(), fileName);
        if (defaultFile.exists() && !defaultFile.setWritable(true)) {
            this.plugin.getMyLogger().myLogger(Level.SEVERE, "Failed to make file \"" + defaultFile + "\" writable!");
        }
        if ((replace = "en_US.txt".equals(fileName)) || !defaultFile.exists()) {
            this.plugin.saveResource(fileName, replace);
            defaultFile.setWritable(false);
        }
    }

    private void readFile() {
        DEFAULT_LOCALES.forEach(this::writeDefaultFile);
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.textFile), StandardCharsets.UTF_8));){
            String sCurrentLine;
            while ((sCurrentLine = br.readLine()) != null) {
                String value;
                if (sCurrentLine.startsWith("#") || sCurrentLine.isEmpty()) continue;
                String[] parts = sCurrentLine.split("=", 2);
                String key = parts[0];
                if (parts.length == 1) {
                    this.plugin.getMyLogger().myLogger(Level.WARNING, "Invalid syntax for translation: \"" + sCurrentLine + "\"");
                    value = "Invalid translation";
                } else {
                    value = parts[1].replaceAll("&((?i)[0-9a-fk-or])", "\u00a7$1");
                }
                String[] newLineSplitter = value.split("\\\\n");
                String values = newLineSplitter[0];
                for (int idx = 1; idx < newLineSplitter.length; ++idx) {
                    values = values + "\n" + newLineSplitter[idx];
                }
                this.messageMap.put(key, values);
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            this.plugin.getMyLogger().myLogger(Level.SEVERE, "Locale file " + this.locale + ".txt does not exist!");
        }
        catch (IOException e) {
            this.plugin.getMyLogger().myLogger(Level.SEVERE, "Could not read locale file! (" + this.locale + ".txt)");
            e.printStackTrace();
        }
    }

    public String getString(String key) {
        String value = this.messageMap.get(key);
        if (value != null) {
            return value;
        }
        this.plugin.getMyLogger().warn("Failed to get the translation for key " + key);
        return "Translation for key \"" + key + "\" not found! Contact server admin!";
    }

    public String getStringReverse(String value) {
        return this.messageMap.entrySet().stream().filter(e -> ((String)e.getValue()).equals(value)).map(Map.Entry::getKey).findFirst().orElse(null);
    }
}

