/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.util;

import java.util.Objects;
import nl.pim16aap2.bigDoors.util.DoorDirection;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.Stairs;

public final class NMSUtil {
    private NMSUtil() {
    }

    public static void rotateVerticallyInDirection(DoorDirection openDirection, Object craftBlockData) {
        BlockFace newBlockFace;
        if (!(craftBlockData instanceof Directional)) {
            return;
        }
        Directional directional = (Directional)craftBlockData;
        BlockFace currentBlockFace = directional.getFacing();
        BlockFace openingDirFace = openDirection.getBlockFace();
        BlockFace oppositeDirFace = Objects.requireNonNull(DoorDirection.getOpposite(openDirection)).getBlockFace();
        if (craftBlockData instanceof Stairs) {
            NMSUtil.rotateVerticallyInDirection((Stairs)craftBlockData, openingDirFace, oppositeDirFace);
        }
        if (currentBlockFace == openingDirFace) {
            newBlockFace = BlockFace.DOWN;
        } else if (currentBlockFace == oppositeDirFace) {
            newBlockFace = BlockFace.UP;
        } else if (currentBlockFace == BlockFace.UP) {
            newBlockFace = openingDirFace;
        } else if (currentBlockFace == BlockFace.DOWN) {
            newBlockFace = oppositeDirFace;
        } else {
            return;
        }
        if (directional.getFaces().contains(newBlockFace)) {
            directional.setFacing(newBlockFace);
        }
    }

    private static void rotateVerticallyInDirection(Stairs stairs, BlockFace openingDirFace, BlockFace oppositeDirFace) {
        BlockFace currentBlockFace = stairs.getFacing();
        BlockFace newBlockFace = null;
        Bisected.Half newHalf = null;
        if (currentBlockFace == openingDirFace) {
            if (stairs.getHalf() == Bisected.Half.TOP) {
                newHalf = Bisected.Half.BOTTOM;
            } else {
                newBlockFace = oppositeDirFace;
            }
        } else if (currentBlockFace == oppositeDirFace) {
            if (stairs.getHalf() == Bisected.Half.BOTTOM) {
                newHalf = Bisected.Half.TOP;
            } else {
                newBlockFace = openingDirFace;
            }
        } else {
            return;
        }
        if (newHalf != null) {
            stairs.setHalf(newHalf);
        }
        if (newBlockFace != null && stairs.getFaces().contains(newBlockFace)) {
            stairs.setFacing(newBlockFace);
        }
    }
}

