/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.util;

import java.util.HashMap;
import java.util.Map;

public enum RotateDirection {
    NONE(0, "GUI.Direction.Any"),
    CLOCKWISE(1, "GUI.Direction.Clock"),
    COUNTERCLOCKWISE(2, "GUI.Direction.Counter"),
    UP(3, "GUI.Direction.Up"),
    DOWN(4, "GUI.Direction.Down"),
    NORTH(5, "GUI.Direction.North"),
    EAST(6, "GUI.Direction.East"),
    SOUTH(7, "GUI.Direction.South"),
    WEST(8, "GUI.Direction.West");

    private int val;
    private String nameKey;
    private static Map<Integer, RotateDirection> map;
    private static final RotateDirection[] ROTATE_DIRECTIONS;

    private RotateDirection(int val, String nameKey) {
        this.val = val;
        this.nameKey = nameKey;
    }

    public int getVal() {
        return this.val;
    }

    public static int getValue(RotateDirection dir) {
        return dir.getVal();
    }

    public static RotateDirection valueOf(int dir) {
        return map.get(dir);
    }

    public static String getNameKey(RotateDirection dir) {
        return dir.nameKey;
    }

    private static RotateDirection cycleCardinalDirection(boolean reverse, RotateDirection dir) {
        switch (dir.ordinal()) {
            case 5: {
                return reverse ? EAST : WEST;
            }
            case 6: {
                return reverse ? SOUTH : NORTH;
            }
            case 7: {
                return reverse ? WEST : EAST;
            }
            case 8: {
                return reverse ? NORTH : SOUTH;
            }
        }
        return null;
    }

    public static RotateDirection cycleCardinalDirection(RotateDirection dir) {
        return RotateDirection.cycleCardinalDirection(false, dir);
    }

    public static RotateDirection cycleCardinalDirectionReverse(RotateDirection dir) {
        return RotateDirection.cycleCardinalDirection(true, dir);
    }

    public static RotateDirection getOpposite(RotateDirection dir) {
        switch (dir.ordinal()) {
            case 0: {
                return NONE;
            }
            case 1: {
                return COUNTERCLOCKWISE;
            }
            case 2: {
                return CLOCKWISE;
            }
            case 3: {
                return DOWN;
            }
            case 4: {
                return UP;
            }
            case 5: {
                return SOUTH;
            }
            case 6: {
                return WEST;
            }
            case 7: {
                return NORTH;
            }
            case 8: {
                return EAST;
            }
        }
        return null;
    }

    static {
        map = new HashMap<Integer, RotateDirection>();
        ROTATE_DIRECTIONS = RotateDirection.values();
        for (RotateDirection dir : RotateDirection.values()) {
            map.put(dir.val, dir);
        }
    }
}

