/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.math.NumberUtils;

@FunctionalInterface
public interface VersionScheme {
    public static final VersionScheme DECIMAL = new Decimal();

    @Nullable
    public String compareVersions(String var1, String var2);

    public static final class Decimal
    implements VersionScheme {
        private static final Pattern DECIMAL_SCHEME_PATTERN = Pattern.compile("\\d+(?:\\.\\d+)*");

        private Decimal() {
        }

        @Override
        @Nullable
        public String compareVersions(String first, String second) {
            String[] firstSplit = Decimal.splitVersionInfo(first);
            String[] secondSplit = Decimal.splitVersionInfo(second);
            if (firstSplit == null || secondSplit == null) {
                return null;
            }
            for (int i = 0; i < Math.min(firstSplit.length, secondSplit.length); ++i) {
                int currentValue = NumberUtils.toInt((String)firstSplit[i]);
                int newestValue = NumberUtils.toInt((String)secondSplit[i]);
                if (newestValue > currentValue) {
                    return second;
                }
                if (newestValue >= currentValue) continue;
                return first;
            }
            return secondSplit.length > firstSplit.length ? second : first;
        }

        private static String[] splitVersionInfo(String version) {
            Matcher matcher = DECIMAL_SCHEME_PATTERN.matcher(version);
            if (!matcher.find()) {
                return null;
            }
            return matcher.group().split("\\.");
        }
    }
}

