/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.Door;
import nl.pim16aap2.bigDoors.lib.universalScheduler.UniversalRunnable;
import nl.pim16aap2.bigDoors.lib.universalScheduler.scheduling.tasks.MyScheduledTask;
import org.bukkit.plugin.Plugin;

public class AutoCloseScheduler {
    private final BigDoors plugin;
    private final Map<Long, MyScheduledTask> timers = new ConcurrentHashMap<Long, MyScheduledTask>();

    public AutoCloseScheduler(BigDoors plugin) {
        this.plugin = plugin;
    }

    public boolean isDoorWaiting(long doorUID) {
        return this.timers.containsKey(doorUID);
    }

    private void deleteTimer(long doorUID) {
        if (this.timers.containsKey(doorUID)) {
            this.timers.get(doorUID).cancel();
            this.timers.remove(doorUID);
        }
    }

    public void cancelTimer(long doorUID) {
        this.deleteTimer(doorUID);
    }

    public void scheduleAutoClose(final Door door, final double time, final boolean instantOpen) {
        if (door.getAutoClose() < 0 || !door.isOpen()) {
            return;
        }
        int timeLimit = this.plugin.getConfigLoader().maxAutoCloseTimer();
        if (timeLimit >= 0 && door.getAutoClose() > timeLimit) {
            BigDoors.get().getMyLogger().warn("Aborted autoCloseTimer for door: " + door.getDoorUID() + ", because it's autoCloseTimer (" + door.getAutoClose() + ") exceeds the global limit (" + BigDoors.get().getConfigLoader().maxAutoCloseTimer() + ").");
            BigDoors.get().getMyLogger().warn("Either change the door's autoCloseTimer or increase the global limit in the config.");
            return;
        }
        this.deleteTimer(door.getDoorUID());
        int delay = Math.max(this.plugin.getMinimumDoorDelay(), door.getAutoClose() * 20);
        this.timers.put(door.getDoorUID(), new UniversalRunnable(){

            @Override
            public void run() {
                if (door.isOpen()) {
                    if (AutoCloseScheduler.this.plugin.getCommander().isDoorBusy(door.getDoorUID())) {
                        AutoCloseScheduler.this.deleteTimer(door.getDoorUID());
                        this.cancel();
                    } else {
                        AutoCloseScheduler.this.plugin.getDoorOpener(door.getType()).openDoorFuture(AutoCloseScheduler.this.plugin.getCommander().getDoor(null, door.getDoorUID()), time, instantOpen, false);
                    }
                }
                AutoCloseScheduler.this.deleteTimer(door.getDoorUID());
            }
        }.runTaskLater((Plugin)this.plugin, delay));
    }
}

