/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.Door;
import nl.pim16aap2.bigDoors.events.DoorDeleteEvent;
import nl.pim16aap2.bigDoors.moveBlocks.BlockMover;
import nl.pim16aap2.bigDoors.storage.sqlite.SQLiteJDBCDriverConnection;
import nl.pim16aap2.bigDoors.util.DoorAttribute;
import nl.pim16aap2.bigDoors.util.DoorDirection;
import nl.pim16aap2.bigDoors.util.DoorOwner;
import nl.pim16aap2.bigDoors.util.Messages;
import nl.pim16aap2.bigDoors.util.RotateDirection;
import nl.pim16aap2.bigDoors.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class Commander {
    private final BigDoors plugin;
    private Map<Long, BlockMover> busyDoors;
    private HashMap<UUID, String> players;
    private boolean goOn = true;
    private boolean paused = false;
    private SQLiteJDBCDriverConnection db;
    private Messages messages;
    private static final DummyMover DUMMYMOVER = new DummyMover();

    public Commander(BigDoors plugin, SQLiteJDBCDriverConnection db) {
        this.plugin = plugin;
        this.db = db;
        this.busyDoors = new ConcurrentHashMap<Long, BlockMover>();
        this.messages = plugin.getMessages();
        this.players = new HashMap();
    }

    public void prepareDatabaseForV2() {
        this.db.prepareForV2();
    }

    public void emptyBusyDoors() {
        this.busyDoors.clear();
    }

    public void stopMovers(boolean onDisable) {
        Iterator<BlockMover> it = this.busyDoors.values().iterator();
        while (it.hasNext()) {
            it.next().cancel(onDisable);
        }
    }

    public boolean isDoorBusy(long doorUID) {
        return this.busyDoors.containsKey(doorUID);
    }

    public boolean isDoorBusyRegisterIfNot(long doorUID) {
        return this.busyDoors.putIfAbsent(doorUID, DUMMYMOVER) != null;
    }

    public void setDoorAvailable(long doorUID) {
        this.busyDoors.remove(doorUID);
    }

    public void addBlockMover(BlockMover mover) {
        this.busyDoors.replace(mover.getDoorUID(), mover);
    }

    public BlockMover getBlockMover(long doorUID) {
        BlockMover mover = this.busyDoors.get(doorUID);
        return mover instanceof DummyMover ? null : mover;
    }

    public Stream<BlockMover> getBlockMovers() {
        return this.busyDoors.values().stream().filter(BM -> !(BM instanceof DummyMover));
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void togglePaused() {
        this.paused = !this.paused;
    }

    public boolean canGo() {
        return this.goOn;
    }

    public void setCanGo(boolean bool) {
        this.goOn = bool;
    }

    public void printDoors(Player player, ArrayList<Door> doors) {
        for (Door door : doors) {
            Util.messagePlayer(player, door.toSimpleString());
        }
    }

    public Door getDoor(String doorStr, @Nullable Player player) {
        return this.getDoor(doorStr, player, false);
    }

    public Door getDoor(String doorStr, @Nullable Player player, boolean bypass) {
        try {
            long doorUID = Long.parseLong(doorStr);
            return this.db.getDoor(player == null ? null : player.getUniqueId(), doorUID, bypass);
        }
        catch (NumberFormatException e) {
            if (player == null) {
                return null;
            }
            ArrayList<Object> doors = new ArrayList();
            doors = this.db.getDoors(player.getUniqueId().toString(), doorStr);
            if (doors.size() == 1) {
                return (Door)doors.get(0);
            }
            if (doors.size() == 0) {
                Util.messagePlayer(player, this.messages.getString("GENERAL.NoDoorsFound"));
            } else {
                Util.messagePlayer(player, this.messages.getString("GENERAL.MoreThan1DoorFound"));
            }
            this.printDoors(player, doors);
            return null;
        }
    }

    public long addDoor(Door newDoor) {
        this.plugin.getPBCache().invalidate(Util.chunkHashFromLocation(newDoor.getPowerBlockLoc()));
        return this.db.insert(newDoor);
    }

    public long addDoor(Door newDoor, Player player, int permission) {
        if (newDoor.getPlayerUUID() != player.getUniqueId()) {
            newDoor.setPlayerUUID(player.getUniqueId());
        }
        if (newDoor.getPermission() != permission) {
            newDoor.setPermission(permission);
        }
        this.plugin.getPBCache().invalidate(Util.chunkHashFromLocation(newDoor.getPowerBlockLoc()));
        return this.db.insert(newDoor);
    }

    public long addDoor(Door newDoor, Player player) {
        return this.addDoor(newDoor, player, 0);
    }

    private void onDoorDelete(@Nullable Door door) {
        if (door == null) {
            return;
        }
        Bukkit.getPluginManager().callEvent((Event)new DoorDeleteEvent(door));
        this.plugin.getPBCache().invalidate(door.getPowerBlockChunkHash());
        if (this.plugin.getConfigLoader().refundOnDelete()) {
            this.plugin.getVaultManager().refundDoor(door);
        }
    }

    public boolean removeDoor(Player player, long doorUID) {
        if (!this.hasPermissionForAction(player, doorUID, DoorAttribute.DELETE)) {
            return false;
        }
        this.removeDoor(doorUID);
        return true;
    }

    public void removeDoor(long doorUID) {
        this.onDoorDelete(this.db.removeDoor(doorUID));
    }

    public void removeDoorsFromWorld(World world) {
        this.db.removeDoorsFromWorld(world).forEach(this::onDoorDelete);
    }

    public long countDoors(String playerUUID, @Nullable String doorName) {
        return this.db.countDoors(playerUUID, doorName);
    }

    public ArrayList<Door> getDoors(String playerUUID, @Nullable String name) {
        if (playerUUID == null && name == null) {
            return new ArrayList<Door>();
        }
        return playerUUID == null ? this.getDoors(name) : this.db.getDoors(playerUUID, name);
    }

    public Set<Door> getDoors() {
        return this.db.getDoors();
    }

    private ArrayList<Door> getDoors(String name) {
        return this.db.getDoors(name);
    }

    public ArrayList<Door> getDoorsInWorld(World world) {
        return this.db.getDoorsInWorld(world);
    }

    public ArrayList<Door> getDoorsInRange(String playerUUID, @Nullable String name, int start, int end) {
        return this.db.getDoors(playerUUID, name, start, end);
    }

    public UUID playerUUIDFromName(String playerName) {
        UUID uuid = this.players.entrySet().stream().filter(e -> ((String)e.getValue()).equals(playerName)).map(Map.Entry::getKey).findFirst().orElse(null);
        if (uuid != null) {
            return uuid;
        }
        uuid = this.db.getUUIDFromName(playerName);
        if (uuid != null) {
            return uuid;
        }
        uuid = Util.playerUUIDFromString(playerName);
        if (uuid != null) {
            this.updatePlayer(uuid, playerName);
        }
        return uuid;
    }

    public String playerNameFromUUID(UUID playerUUID) {
        if (this.players.containsKey(playerUUID)) {
            return this.players.get(playerUUID);
        }
        Player player = Bukkit.getPlayer((UUID)playerUUID);
        if (player != null) {
            return player.getName();
        }
        String name = this.db.getPlayerName(playerUUID);
        if (name != null) {
            return name;
        }
        name = Util.nameFromUUID(playerUUID);
        this.updatePlayer(playerUUID, name);
        return name;
    }

    public void updatePlayer(UUID uuid, String playerName) {
        this.db.updatePlayerName(uuid, playerName);
        this.players.put(uuid, playerName);
    }

    public void updatePlayer(Player player) {
        this.updatePlayer(player.getUniqueId(), player.getName());
    }

    public void removePlayer(Player player) {
        this.players.remove(player.getUniqueId());
    }

    public Door getDoor(@Nullable UUID playerUUID, long doorUID) {
        return this.getDoor(playerUUID, doorUID, false);
    }

    public Door getDoor(@Nullable UUID playerUUID, long doorUID, boolean bypass) {
        return this.db.getDoor(playerUUID, doorUID, bypass);
    }

    public boolean hasPermissionNodeForAction(Player player, @Nullable DoorAttribute attr) {
        return attr != null && attr.hasAnyPermission(player);
    }

    public boolean hasPermissionForAction(Player player, long doorUID, DoorAttribute attr) {
        return this.hasPermissionForAction(player, doorUID, attr, true);
    }

    public boolean hasPermissionForAction(Player player, long doorUID, DoorAttribute attr, boolean printMessage) {
        boolean hasPermission;
        if (player.isOp() || this.hasPermissionNodeForAction(player, attr)) {
            return true;
        }
        int playerPermission = this.getPermission(player.getUniqueId().toString(), doorUID);
        boolean bl = hasPermission = playerPermission >= 0 && playerPermission <= attr.getPermissionLevel();
        if (!hasPermission && printMessage) {
            Util.messagePlayer(player, this.plugin.getMessages().getString("GENERAL.NoPermissionForAction"));
        }
        return hasPermission;
    }

    public int getPermission(String playerUUID, long doorUID) {
        return this.db.getPermission(playerUUID, doorUID);
    }

    public void updateDoorCoords(long doorUID, boolean isOpen, int blockXMin, int blockYMin, int blockZMin, int blockXMax, int blockYMax, int blockZMax) {
        this.db.updateDoorCoords(doorUID, isOpen, blockXMin, blockYMin, blockZMin, blockXMax, blockYMax, blockZMax, null);
    }

    public void updateDoorCoords(long doorUID, boolean isOpen, int blockXMin, int blockYMin, int blockZMin, int blockXMax, int blockYMax, int blockZMax, DoorDirection newEngSide) {
        this.db.updateDoorCoords(doorUID, isOpen, blockXMin, blockYMin, blockZMin, blockXMax, blockYMax, blockZMax, newEngSide);
    }

    public void addOwner(UUID playerUUID, Door door) {
        this.addOwner(playerUUID, door, 1);
    }

    public boolean addOwner(UUID playerUUID, Door door, int permission) {
        if (permission < 1 || permission > 2 || door.getPermission() != 0 || door.getPlayerUUID().equals(playerUUID)) {
            return false;
        }
        this.db.addOwner(door.getDoorUID(), playerUUID, permission);
        return true;
    }

    public boolean removeOwner(Door door, UUID playerUUID, Player executor) {
        return this.removeOwner(door.getDoorUID(), playerUUID, executor);
    }

    public boolean removeOwner(long doorUID, UUID playerUUID, Player executor) {
        if (this.db.getPermission(playerUUID.toString(), doorUID) == 0) {
            return false;
        }
        if (!this.hasPermissionForAction(executor, doorUID, DoorAttribute.REMOVEOWNER)) {
            return false;
        }
        return this.db.removeOwner(doorUID, playerUUID);
    }

    public ArrayList<DoorOwner> getDoorOwners(long doorUID, @Nullable UUID playerUUID) {
        return this.db.getOwnersOfDoor(doorUID, playerUUID);
    }

    public void updateDoorOpenDirection(long doorUID, RotateDirection openDir) {
        if (openDir == null) {
            return;
        }
        this.db.updateDoorOpenDirection(doorUID, openDir);
    }

    public void updateDoorAutoClose(long doorUID, int autoClose) {
        this.db.updateDoorAutoClose(doorUID, autoClose);
    }

    public void updateDoorBypassProtections(long doorUID, boolean bypass) {
        this.db.updateBypassProtections(doorUID, bypass);
    }

    public void updateDoorNotify(long doorUID, boolean notify) {
        this.db.updateNotify(doorUID, notify);
    }

    public void updateDoorBlocksToMove(long doorID, int blocksToMove) {
        this.db.updateDoorBlocksToMove(doorID, blocksToMove);
    }

    public void setLock(long doorUID, boolean newLockStatus) {
        this.db.setLock(doorUID, newLockStatus);
    }

    public Door doorFromPowerBlockLoc(Location loc) {
        Long doorUID;
        long chunkHash = Util.chunkHashFromLocation(loc);
        HashMap<Long, Long> powerBlockData = this.plugin.getPBCache().get(chunkHash);
        if (powerBlockData == null) {
            powerBlockData = this.db.getPowerBlockData(chunkHash);
            this.plugin.getPBCache().put(chunkHash, powerBlockData);
        }
        return (doorUID = powerBlockData.get(Util.locationHash(loc))) == null ? null : this.db.getDoor(null, doorUID);
    }

    public void recalculatePowerBlockHashes() {
        this.db.recalculatePowerBlockHashes();
    }

    public void updatePowerBlockLoc(long doorUID, Location loc) {
        this.plugin.getPBCache().invalidate(this.db.getDoor(null, doorUID).getPowerBlockChunkHash());
        this.db.updateDoorPowerBlockLoc(doorUID, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), loc.getWorld().getUID());
        this.plugin.getPBCache().invalidate(Util.chunkHashFromLocation(loc));
    }

    public boolean isPowerBlockLocationValid(Location loc) {
        return this.db.isPowerBlockLocationEmpty(loc);
    }

    private static final class DummyMover
    extends BlockMover {
        private DummyMover() {
            super(BigDoors.get(), null, false);
        }

        @Override
        public synchronized void cancel(boolean onDisable) {
        }

        @Override
        public void putBlocks(boolean onDisable) {
        }

        @Override
        public long getDoorUID() {
            return -1L;
        }

        @Override
        public Door getDoor() {
            return null;
        }
    }
}

