/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.NMS;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.v1_14_R1.AxisAlignedBB;
import net.minecraft.server.v1_14_R1.Block;
import net.minecraft.server.v1_14_R1.BlockConcretePowder;
import net.minecraft.server.v1_14_R1.BlockFalling;
import net.minecraft.server.v1_14_R1.BlockPosition;
import net.minecraft.server.v1_14_R1.Blocks;
import net.minecraft.server.v1_14_R1.CrashReportSystemDetails;
import net.minecraft.server.v1_14_R1.DataWatcher;
import net.minecraft.server.v1_14_R1.DataWatcherObject;
import net.minecraft.server.v1_14_R1.DataWatcherRegistry;
import net.minecraft.server.v1_14_R1.DataWatcherSerializer;
import net.minecraft.server.v1_14_R1.Entity;
import net.minecraft.server.v1_14_R1.EntityFallingBlock;
import net.minecraft.server.v1_14_R1.EntityTypes;
import net.minecraft.server.v1_14_R1.EnumDirection;
import net.minecraft.server.v1_14_R1.EnumMoveType;
import net.minecraft.server.v1_14_R1.GameProfileSerializer;
import net.minecraft.server.v1_14_R1.IBlockData;
import net.minecraft.server.v1_14_R1.MovingObjectPosition;
import net.minecraft.server.v1_14_R1.MovingObjectPositionBlock;
import net.minecraft.server.v1_14_R1.NBTBase;
import net.minecraft.server.v1_14_R1.NBTTagCompound;
import net.minecraft.server.v1_14_R1.RayTrace;
import net.minecraft.server.v1_14_R1.TagsBlock;
import net.minecraft.server.v1_14_R1.TagsFluid;
import net.minecraft.server.v1_14_R1.Vec3D;
import net.minecraft.server.v1_14_R1.World;
import nl.pim16aap2.bigDoors.NMS.CustomEntityFallingBlock;
import org.bukkit.craftbukkit.v1_14_R1.CraftWorld;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class CustomEntityFallingBlock_V1_14_R1
extends EntityFallingBlock
implements CustomEntityFallingBlock {
    private IBlockData block;
    public int ticksLived;
    public boolean dropItem;
    private boolean f;
    public boolean hurtEntities;
    private int fallHurtMax;
    private float fallHurtAmount;
    public NBTTagCompound tileEntityData;
    protected static final DataWatcherObject<BlockPosition> d = DataWatcher.a(EntityFallingBlock.class, (DataWatcherSerializer)DataWatcherRegistry.l);
    private org.bukkit.World bukkitWorld;

    public CustomEntityFallingBlock_V1_14_R1(org.bukkit.World world, double d0, double d1, double d2, IBlockData iblockdata) {
        super(EntityTypes.FALLING_BLOCK, (World)((CraftWorld)world).getHandle());
        this.bukkitWorld = world;
        this.block = iblockdata;
        this.i = true;
        this.setPosition(d0, d1 + (double)((1.0f - this.getHeight()) / 2.0f), d2);
        this.dropItem = false;
        this.noclip = true;
        this.setNoGravity(true);
        this.fallHurtMax = 0;
        this.fallHurtAmount = 0.0f;
        this.setMot(0.0, 0.0, 0.0);
        this.lastX = d0;
        this.lastY = d1;
        this.lastZ = d2;
        this.a(new BlockPosition((Entity)this));
        this.spawn();
    }

    public void die() {
        for (Entity ent : this.passengers) {
            ent.dead = true;
        }
        this.dead = true;
    }

    public void spawn() {
        ((CraftWorld)this.bukkitWorld).getHandle().addEntity((Entity)this, CreatureSpawnEvent.SpawnReason.CUSTOM);
    }

    protected boolean playStepSound() {
        return false;
    }

    public boolean isInteractable() {
        return !this.dead;
    }

    private List<Entity> getFallingBlocksOnSide(AxisAlignedBB bb, EnumDirection dir) {
        double minX = bb.minX;
        double minY = bb.minY;
        double minZ = bb.minZ;
        double maxX = bb.maxX;
        double maxY = bb.maxY;
        double maxZ = bb.maxZ;
        switch (dir) {
            case DOWN: {
                minY -= 1.0;
                maxY -= 1.0;
                break;
            }
            case UP: {
                minY += 1.0;
                maxY += 1.0;
                break;
            }
            case NORTH: {
                minZ -= 1.0;
                maxZ -= 1.0;
                break;
            }
            case SOUTH: {
                minZ += 1.0;
                maxZ += 1.0;
                break;
            }
            case WEST: {
                minX -= 1.0;
                maxX -= 1.0;
                break;
            }
            case EAST: {
                minX += 1.0;
                maxX += 1.0;
            }
        }
        AxisAlignedBB newBB = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
        List list = this.world.getEntities((Entity)this, newBB);
        ArrayList ret = Lists.newArrayList();
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (!(entity instanceof CustomEntityFallingBlock_V1_14_R1)) continue;
                ret.add(entity);
            }
        }
        return ret;
    }

    public void tick() {
        if (this.block.isAir()) {
            this.die();
        } else {
            BlockPosition blockposition;
            this.lastX = this.locX;
            this.lastY = this.locY;
            this.lastZ = this.locZ;
            Block block = this.block.getBlock();
            if (this.ticksLived++ == 0 && this.world.getType(blockposition = new BlockPosition((Entity)this)).getBlock() == block) {
                this.world.a(blockposition, false);
            }
            if (!this.isNoGravity()) {
                this.setMot(this.getMot().add(0.0, -0.04, 0.0));
            }
            this.move(EnumMoveType.SELF, this.getMot());
            if (!this.world.isClientSide) {
                MovingObjectPositionBlock movingobjectpositionblock;
                blockposition = new BlockPosition((Entity)this);
                boolean isConcretePowder = this.block.getBlock() instanceof BlockConcretePowder;
                boolean flag1 = isConcretePowder && this.world.getFluid(blockposition).a(TagsFluid.WATER);
                Vec3D mot = this.getMot();
                double d0 = mot.x * mot.x + mot.y * mot.y + mot.z * mot.z;
                if (isConcretePowder && d0 > 1.0 && (movingobjectpositionblock = this.world.rayTrace(new RayTrace(new Vec3D(this.lastX, this.lastY, this.lastZ), new Vec3D(this.locX, this.locY, this.locZ), RayTrace.BlockCollisionOption.COLLIDER, RayTrace.FluidCollisionOption.SOURCE_ONLY, (Entity)this))).getType() != MovingObjectPosition.EnumMovingObjectType.MISS && this.world.getFluid(movingobjectpositionblock.getBlockPosition()).a(TagsFluid.WATER)) {
                    blockposition = movingobjectpositionblock.getBlockPosition();
                    flag1 = true;
                }
                if (!this.onGround && !flag1) {
                    if (this.ticksLived > 100 && !this.world.isClientSide && (blockposition.getY() < 1 || blockposition.getY() > 256) || this.ticksLived > 12000) {
                        this.die();
                    }
                } else {
                    IBlockData iblockdata = this.world.getType(blockposition);
                    Vec3D newMot = this.getMot();
                    double motX = newMot.x * (double)0.7f;
                    double motY = newMot.y * 0.0;
                    double motZ = newMot.z * (double)0.7f;
                    this.setMot(motX, motY, motZ);
                    if (iblockdata.getBlock() != Blocks.MOVING_PISTON) {
                        this.die();
                        if (block instanceof BlockFalling) {
                            ((BlockFalling)block).a(this.world, blockposition);
                        }
                    }
                }
            }
            Vec3D mot = this.getMot();
            double motX = mot.x * (double)0.98f;
            double motY = mot.y * 1.0;
            double motZ = mot.z * (double)0.98f;
            this.setMot(motX, motY, motZ);
        }
    }

    protected void b(NBTTagCompound nbttagcompound) {
        nbttagcompound.set("BlockState", (NBTBase)GameProfileSerializer.a((IBlockData)this.block));
        nbttagcompound.setInt("Time", this.ticksLived);
        nbttagcompound.setBoolean("DropItem", this.dropItem);
        nbttagcompound.setBoolean("HurtEntities", this.hurtEntities);
        nbttagcompound.setFloat("FallHurtAmount", this.fallHurtAmount);
        nbttagcompound.setInt("FallHurtMax", this.fallHurtMax);
        if (this.tileEntityData != null) {
            nbttagcompound.set("TileEntityData", (NBTBase)this.tileEntityData);
        }
    }

    protected void a(NBTTagCompound nbttagcompound) {
        this.block = GameProfileSerializer.d((NBTTagCompound)nbttagcompound.getCompound("BlockState"));
        this.ticksLived = nbttagcompound.getInt("Time");
        if (nbttagcompound.hasKeyOfType("HurtEntities", 99)) {
            this.hurtEntities = nbttagcompound.getBoolean("HurtEntities");
            this.fallHurtAmount = nbttagcompound.getFloat("FallHurtAmount");
            this.fallHurtMax = nbttagcompound.getInt("FallHurtMax");
        } else if (this.block.a(TagsBlock.ANVIL)) {
            this.hurtEntities = true;
        }
        if (nbttagcompound.hasKeyOfType("DropItem", 99)) {
            this.dropItem = nbttagcompound.getBoolean("DropItem");
        }
        if (nbttagcompound.hasKeyOfType("TileEntityData", 10)) {
            this.tileEntityData = nbttagcompound.getCompound("TileEntityData");
        }
        if (this.block.isAir()) {
            this.block = Blocks.SAND.getBlockData();
        }
    }

    public void a(boolean flag) {
        this.hurtEntities = flag;
    }

    public void appendEntityCrashDetails(CrashReportSystemDetails crashreportsystemdetails) {
        super.appendEntityCrashDetails(crashreportsystemdetails);
        crashreportsystemdetails.a("Animated BigDoors block with state: ", (Object)this.block.toString());
    }

    public IBlockData getBlock() {
        return this.block;
    }
}

