/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors;

import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nullable;
import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.UpdateChecker;
import nl.pim16aap2.bigDoors.lib.universalScheduler.UniversalRunnable;
import nl.pim16aap2.bigDoors.lib.universalScheduler.scheduling.tasks.MyScheduledTask;
import nl.pim16aap2.bigDoors.util.Util;
import org.bukkit.plugin.Plugin;

public final class UpdateManager {
    private final BigDoors plugin;
    private volatile boolean downloadUpdates = false;
    private volatile boolean announceUpdateCheck = true;
    private volatile boolean updateDownloaded = false;
    private final UpdateChecker updater;
    private MyScheduledTask updateRunner = null;

    public UpdateManager(BigDoors plugin) {
        this.plugin = plugin;
        this.updater = UpdateChecker.init(plugin);
    }

    public void setEnabled(boolean downloadUpdates, boolean announceUpdateCheck) {
        this.downloadUpdates = downloadUpdates;
        this.announceUpdateCheck = announceUpdateCheck;
        this.initUpdater();
    }

    public boolean hasUpdateBeenDownloaded() {
        return this.updateDownloaded;
    }

    @Nullable
    public String getNewestVersion() {
        if (this.updater.getLastResult() == null) {
            return null;
        }
        return this.updater.getLastResult().getNewestVersion();
    }

    @Nullable
    private String getNewestVersionChangelog() {
        if (this.updater.getLastResult() == null) {
            return null;
        }
        return this.updater.getLastResult().getChangelog();
    }

    public boolean updateAvailable() {
        if (this.updater.getLastResult() == null) {
            return false;
        }
        if (this.updater.getLastResult().requiresUpdate()) {
            return true;
        }
        return this.updater.getLastResult().getReason().equals((Object)UpdateChecker.UpdateReason.UP_TO_DATE);
    }

    private void announceUpdate() {
        String newestVersion = this.getNewestVersion();
        StringBuilder sb = new StringBuilder("A new update is available: ").append(newestVersion).append('!');
        int lineWidth = 80;
        StringBuilder changelogBuilder = new StringBuilder();
        String changelog = this.getNewestVersionChangelog();
        if (changelog != null) {
            for (String item : changelog.split("\\r\\n")) {
                if (item.length() > lineWidth) {
                    lineWidth = item.length();
                }
                changelogBuilder.append(item).append('\n');
            }
            changelogBuilder.append('\n');
            lineWidth = Math.min(lineWidth + 4, 160);
        }
        String title = " [BigDoors " + newestVersion + "] ";
        char[] starsArr = new char[(int)Math.ceil((double)(lineWidth - title.length()) / 2.0)];
        Arrays.fill(starsArr, '*');
        String stars = new String(starsArr);
        String header = stars + title + stars;
        sb.append("\n\n").append(header).append('\n').append((CharSequence)changelogBuilder).append("Please update:\n  https://www.spigotmc.org/resources/big-doors.58669/").append('\n');
        char[] footer = new char[header.length()];
        Arrays.fill(footer, '*');
        sb.append(footer).append('\n');
        this.plugin.getMyLogger().info(sb.toString());
    }

    public void checkForUpdates() {
        if (this.announceUpdateCheck) {
            this.plugin.getMyLogger().info("Checking for updates...");
        }
        this.updater.requestUpdateCheck().whenCompleteAsync((result, throwable) -> {
            boolean updateAvailable = this.updateAvailable();
            if (!updateAvailable) {
                if (this.announceUpdateCheck) {
                    this.plugin.getMyLogger().info("No new updates available.");
                }
                return;
            }
            this.announceUpdate();
            if (this.downloadUpdates && result.getAge() >= this.plugin.getConfigLoader().downloadDelay()) {
                try {
                    this.updateDownloaded = this.updater.downloadUpdate((UpdateChecker.UpdateResult)result);
                }
                catch (IOException e) {
                    this.updateDownloaded = false;
                    this.plugin.getMyLogger().logMessageToLogFile(Util.throwableToString(e));
                }
                if (this.updateDownloaded) {
                    this.plugin.getMyLogger().info("Update downloaded! Restart to apply it! New version is " + this.updater.getLastResult().getNewestVersion() + ", Currently running " + this.plugin.getDescription().getVersion() + (result.getReason() == UpdateChecker.UpdateReason.UP_TO_DATE ? " (but a DEV-build)" : ""));
                } else {
                    this.plugin.getMyLogger().info("Failed to download latest version! You can download it manually at: " + result.getDownloadUrl());
                }
            }
        });
    }

    private void initUpdater() {
        if (this.updateRunner == null) {
            this.updateRunner = new UniversalRunnable(){

                @Override
                public void run() {
                    UpdateManager.this.checkForUpdates();
                }
            }.runTaskTimer((Plugin)this.plugin, 1L, 864000L);
        }
    }
}

