/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.reflection.MethodFinder;
import nl.pim16aap2.bigDoors.reflection.ReflectionBuilder;
import nl.pim16aap2.bigDoors.semver4j.Semver;
import nl.pim16aap2.bigDoors.util.WorldHeightLimits;
import org.bukkit.Bukkit;
import org.bukkit.World;

public class WorldHeightManager {
    private static final Semver VARIABLE_WORLD_DEPTH_UPDATE_VERSION = Semver.of(1, 18, 0);
    private static final MinWorldHeightFinder MIN_WORLD_HEIGHT_FINDER = WorldHeightManager.getMinWorldHeightFinder();
    private final Map<World, WorldHeightLimits> limitsMap = new HashMap<World, WorldHeightLimits>();

    public WorldHeightLimits getWorldHeightLimits(World world) {
        return this.limitsMap.computeIfAbsent(world, WorldHeightManager::calculateWorldHeightLimits);
    }

    private static WorldHeightLimits calculateWorldHeightLimits(World world) {
        int max = world.getMaxHeight();
        int min = MIN_WORLD_HEIGHT_FINDER.find(world);
        return new WorldHeightLimits(min, max);
    }

    private static MinWorldHeightFinder getMinWorldHeightFinder() {
        if (BigDoors.SERVER_VERSION.isLowerThan(VARIABLE_WORLD_DEPTH_UPDATE_VERSION)) {
            return legacy -> 0;
        }
        try {
            Method methodMinWorldHeight = ((MethodFinder.NamedMethodFinder)((MethodFinder.NamedMethodFinder)ReflectionBuilder.findMethod().inClass(World.class).withName("getMinHeight").checkSuperClasses()).checkInterfaces()).get();
            return world -> WorldHeightManager.getMinWorldHeight(methodMinWorldHeight, world);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            Bukkit.getLogger().severe("Failed to find getMinHeight method! All worlds are considered to have a min height of 0!");
            return fallback -> 0;
        }
    }

    private static int getMinWorldHeight(Method method, World world) {
        try {
            return (Integer)method.invoke((Object)world, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            Bukkit.getLogger().severe("Failed to determine minimum world height for world: " + world);
            e.printStackTrace();
            return 0;
        }
    }

    @FunctionalInterface
    private static interface MinWorldHeightFinder {
        public int find(World var1);
    }
}

