/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.compatibility;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.modifier.FieldManifestation;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.FixedValue;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.implementation.StubMethod;
import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.compatibility.IFakePlayer;
import nl.pim16aap2.bigDoors.reflection.ConstructorFinder;
import nl.pim16aap2.bigDoors.reflection.MethodFinder;
import nl.pim16aap2.bigDoors.reflection.ReflectionBuilder;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.metadata.Metadatable;
import org.jetbrains.annotations.Nullable;

public final class FakePlayerClassGenerator {
    private static final Class<?>[] constructorParameterTypes = new Class[]{OfflinePlayer.class, Location.class};
    private static final String fieldLocation = "location";
    private static final String fieldOfflinePlayer = "offlinePlayer";
    private final BigDoors plugin;
    private final ClassLoader classLoader;
    private boolean isGenerated = false;
    @Nullable
    private Class<?> generatedClass;
    @Nullable
    private Constructor<Player> generatedConstructor;

    FakePlayerClassGenerator(BigDoors plugin) throws Exception {
        this.plugin = plugin;
        this.classLoader = Objects.requireNonNull(plugin.getBigDoorsClassLoader());
        this.generate();
    }

    public BiFunction<OfflinePlayer, Location, Player> getInstantiator() {
        if (this.generatedConstructor == null) {
            throw new IllegalStateException("Constructor has not been generated yet");
        }
        return (offlinePlayer, location) -> {
            try {
                return this.generatedConstructor.newInstance(offlinePlayer, location);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create fake player instance!", e);
            }
        };
    }

    private void generate() throws Exception {
        if (this.isGenerated) {
            if (this.generatedClass == null || this.generatedConstructor == null) {
                throw new IllegalStateException(this.getFormattedName() + " could not be generated");
            }
            return;
        }
        this.isGenerated = true;
        long startTime = System.nanoTime();
        this.generateImpl();
        long duration = System.nanoTime() - startTime;
        this.plugin.getMyLogger().info(String.format("Generated Class %s in %dms.", this.generatedClass.getName(), duration / 1000000L));
    }

    private String getFormattedName() {
        return String.format("%s$Generated", this.getBaseName());
    }

    private DynamicType.Builder<?> addFields(DynamicType.Builder<?> currentBuilder) {
        DynamicType.Builder.FieldDefinition.Optional.Valuable builder = currentBuilder.defineField(fieldOfflinePlayer, OfflinePlayer.class, new ModifierContributor.ForField[]{Visibility.PRIVATE, FieldManifestation.FINAL});
        builder = builder.defineField(fieldLocation, Location.class, new ModifierContributor.ForField[]{Visibility.PRIVATE, FieldManifestation.FINAL});
        return builder;
    }

    private DynamicType.Builder<?> addCtor(DynamicType.Builder<?> currentBuilder) throws NoSuchMethodException {
        return currentBuilder.defineConstructor(new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).withParameters((Type[])this.getConstructorArgumentTypes()).intercept((Implementation)MethodCall.invoke(Object.class.getConstructor(new Class[0])).andThen(FieldAccessor.ofField((String)fieldOfflinePlayer).setsArgumentAt(0)).andThen(FieldAccessor.ofField((String)fieldLocation).setsArgumentAt(1)));
    }

    private DynamicType.Builder<?> addMethods(DynamicType.Builder<?> currentBuilder, Map<String, Method> methods) {
        DynamicType.Builder<?> builder = currentBuilder;
        builder = this.interceptMethodWithImplementation(builder, methods, (Implementation)FixedValue.value(new ArrayList(0)), ReflectionBuilder.findMethod(Metadatable.class).withName("getMetadata").get());
        builder = this.interceptMethodWithImplementation(builder, methods, (Implementation)FixedValue.self(), ReflectionBuilder.findMethod(OfflinePlayer.class).withName("getPlayer").get());
        builder = this.interceptMethodWithImplementation(builder, methods, (Implementation)FixedValue.value((Object)true), ReflectionBuilder.findMethod(OfflinePlayer.class).withName("isOnline").get());
        builder = this.interceptMethodWithImplementation(builder, methods, (Implementation)FixedValue.value((Object)EntityType.PLAYER), ReflectionBuilder.findMethod(Entity.class).withName("getType").get());
        builder = this.interceptMethodRedirectToOfflinePlayer(builder, methods, "getDisplayName", "getName");
        builder = this.interceptMethodRedirectToOfflinePlayer(builder, methods, "getPlayerListName", "getName");
        builder = this.addMethodGetWorld(builder, methods);
        builder = this.addMethodsGetLocation(builder, methods);
        builder = this.addMethodsOfFakePlayer(builder);
        builder = this.addOfflinePlayerMethods(builder, methods);
        builder = this.addMethodsOfObject(builder);
        return builder;
    }

    private DynamicType.Builder<?> addOfflinePlayerMethods(DynamicType.Builder<?> currentBuilder, Map<String, Method> remainingMethods) {
        DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition builder = currentBuilder;
        Map<String, Method> offlinePlayerMethods = FakePlayerClassGenerator.getMethods(OfflinePlayer.class);
        for (Map.Entry<String, Method> entry : offlinePlayerMethods.entrySet()) {
            if (remainingMethods.remove(entry.getKey()) == null) continue;
            MethodCall impl = MethodCall.invoke((Method)entry.getValue()).onField(fieldOfflinePlayer).withAllArguments();
            builder = builder.define(entry.getValue()).intercept((Implementation)impl);
        }
        return builder;
    }

    private DynamicType.Builder<?> interceptMethodWithImplementation(DynamicType.Builder<?> currentBuilder, Map<String, Method> remainingMethods, Implementation implementation, Method method) {
        if (remainingMethods.remove(FakePlayerClassGenerator.simpleMethodString(method)) == null) {
            throw new IllegalStateException("Failed to find mapped method: " + method);
        }
        return currentBuilder.define(method).intercept(implementation);
    }

    private DynamicType.Builder<?> interceptMethodRedirectToOfflinePlayer(DynamicType.Builder<?> currentBuilder, Map<String, Method> remainingMethods, String methodName, String targetMethodName) {
        Method method = ((MethodFinder.NamedMethodFinder)ReflectionBuilder.findMethod(Player.class).withName(methodName).checkInterfaces()).get();
        Method target = ReflectionBuilder.findMethod(OfflinePlayer.class).withName(targetMethodName).get();
        if (remainingMethods.remove(FakePlayerClassGenerator.simpleMethodString(method)) == null) {
            throw new IllegalStateException("Failed to find mapped method: " + method);
        }
        return currentBuilder.define(method).intercept((Implementation)MethodCall.invoke((Method)target).onField(fieldOfflinePlayer));
    }

    private DynamicType.Builder<?> addMethodsGetLocation(DynamicType.Builder<?> currentBuilder, Map<String, Method> remainingMethods) {
        Object locCtor = ((ConstructorFinder.ConstructorFinderInSource)ReflectionBuilder.findConstructor(Location.class).withParameters(World.class, Double.TYPE, Double.TYPE, Double.TYPE)).get();
        Method method0 = (Method)((MethodFinder.MultipleMethodsFinder)((MethodFinder.MultipleMethodsFinder)ReflectionBuilder.findMethod(Player.class).findMultiple().withName("getLocation").withoutParameters()).checkInterfaces()).atLeast(1).get().get(0);
        Method method1 = (Method)((MethodFinder.MultipleMethodsFinder)((MethodFinder.MultipleMethodsFinder)ReflectionBuilder.findMethod(Player.class).findMultiple().withName("getLocation").withParameters(Location.class)).checkInterfaces()).atLeast(1).get().get(0);
        if (remainingMethods.remove(FakePlayerClassGenerator.simpleMethodString(method0)) == null) {
            throw new IllegalStateException("Failed to find mapped method: " + method0);
        }
        if (remainingMethods.remove(FakePlayerClassGenerator.simpleMethodString(method1)) == null) {
            throw new IllegalStateException("Failed to find mapped method: " + method1);
        }
        MethodFinder.MethodFinderInSource findLocationMethod = ReflectionBuilder.findMethod().inClass(Location.class);
        MethodCall getWorld = MethodCall.invoke((Method)findLocationMethod.withName("getWorld").get()).onField(fieldLocation);
        MethodCall getX = MethodCall.invoke((Method)findLocationMethod.withName("getX").get()).onField(fieldLocation);
        MethodCall getY = MethodCall.invoke((Method)findLocationMethod.withName("getY").get()).onField(fieldLocation);
        MethodCall getZ = MethodCall.invoke((Method)findLocationMethod.withName("getZ").get()).onField(fieldLocation);
        DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition builder = currentBuilder.define(method0).intercept((Implementation)MethodCall.construct((Constructor)locCtor).withMethodCall(getWorld).withMethodCall(getX).withMethodCall(getY).withMethodCall(getZ));
        MethodCall setWorld = MethodCall.invoke((Method)findLocationMethod.withName("setWorld").get()).onArgument(0);
        MethodCall setX = MethodCall.invoke((Method)findLocationMethod.withName("setX").get()).onArgument(0);
        MethodCall setY = MethodCall.invoke((Method)findLocationMethod.withName("setY").get()).onArgument(0);
        MethodCall setZ = MethodCall.invoke((Method)findLocationMethod.withName("setZ").get()).onArgument(0);
        MethodCall setYaw = MethodCall.invoke((Method)findLocationMethod.withName("setYaw").get()).onArgument(0);
        MethodCall setPitch = MethodCall.invoke((Method)findLocationMethod.withName("setPitch").get()).onArgument(0);
        builder = builder.define(method1).intercept(setWorld.withMethodCall(getWorld).andThen((Implementation.Composable)setX.withMethodCall(getX)).andThen((Implementation.Composable)setY.withMethodCall(getY)).andThen((Implementation.Composable)setZ.withMethodCall(getZ)).andThen((Implementation.Composable)setYaw.with(new Object[]{Float.valueOf(0.0f)})).andThen((Implementation.Composable)setPitch.with(new Object[]{Float.valueOf(0.0f)})).andThen((Implementation)FixedValue.argument((int)0)));
        return builder;
    }

    private static String simpleMethodString(Method m) {
        String ret = m.getName();
        for (Class<?> clz : m.getParameterTypes()) {
            ret = ret + clz.getName();
        }
        return ret;
    }

    private static Map<String, Method> getMethods(Class<?> clz) {
        Method[] methodsArr = clz.getMethods();
        int filteredCount = 0;
        for (int idx = 0; idx < methodsArr.length; ++idx) {
            Method method = methodsArr[idx];
            if (method.isDefault()) {
                ++filteredCount;
                continue;
            }
            methodsArr[idx - filteredCount] = method;
        }
        HashMap<String, Method> methods = new HashMap<String, Method>(methodsArr.length - filteredCount);
        for (int idx = 0; idx < methodsArr.length - filteredCount; ++idx) {
            Method method = methodsArr[idx];
            methods.put(FakePlayerClassGenerator.simpleMethodString(method), method);
        }
        return methods;
    }

    private DynamicType.Builder<?> addMethodGetWorld(DynamicType.Builder<?> currentBuilder, Map<String, Method> methods) {
        Method method = ((MethodFinder.NamedMethodFinder)ReflectionBuilder.findMethod(Player.class).withName("getWorld").checkInterfaces()).get();
        Method target = ReflectionBuilder.findMethod(Location.class).withName("getWorld").get();
        if (methods.remove(FakePlayerClassGenerator.simpleMethodString(method)) == null) {
            throw new IllegalStateException("Failed to find mapped method: " + method);
        }
        return currentBuilder.define(method).intercept((Implementation)MethodCall.invoke((Method)target).onField(fieldLocation));
    }

    private DynamicType.Builder<?> addStubs(DynamicType.Builder<?> currentBuilder, Map<String, Method> methods) {
        DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition builder = currentBuilder;
        for (Method method : methods.values()) {
            if (method.isDefault()) continue;
            builder = builder.define(method).intercept((Implementation)StubMethod.INSTANCE);
        }
        return builder;
    }

    private DynamicType.Builder<?> addMethodsOfFakePlayer(DynamicType.Builder<?> currentBuilder) {
        MethodFinder.MethodFinderInSource findMethod = ReflectionBuilder.findMethod().inClass(IFakePlayer.class);
        Method getPlayer = findMethod.withName("getOfflinePlayer0").get();
        Method getLocation = findMethod.withName("getLocation0").get();
        DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition builder = currentBuilder.define(getPlayer).intercept((Implementation)FieldAccessor.ofField((String)fieldOfflinePlayer));
        builder = builder.define(getLocation).intercept((Implementation)FieldAccessor.ofField((String)fieldLocation));
        return builder;
    }

    private DynamicType.Builder<?> addMethodsOfObject(DynamicType.Builder<?> currentBuilder) {
        MethodFinder.MethodFinderInSource findObjectMethod = ReflectionBuilder.findMethod().inClass(Object.class);
        Method equals = ((MethodFinder.NamedMethodFinder)findObjectMethod.withName("equals").withParameters(Object.class)).get();
        Method hashCode = findObjectMethod.withName("hashCode").get();
        Method toString = findObjectMethod.withName("toString").get();
        MethodFinder.MethodFinderInSource findFakePlayerMethod = ReflectionBuilder.findMethod().inClass(IFakePlayer.class);
        Method equals0 = findFakePlayerMethod.withName("equals0").get();
        Method hashCode0 = findFakePlayerMethod.withName("hashCode0").get();
        Method toString0 = findFakePlayerMethod.withName("toString0").get();
        DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition builder = currentBuilder.define(equals).intercept((Implementation)MethodCall.invoke((Method)equals0).withAllArguments());
        builder = builder.define(hashCode).intercept((Implementation)MethodCall.invoke((Method)hashCode0).withAllArguments());
        builder = builder.define(toString).intercept((Implementation)MethodCall.invoke((Method)toString0).withAllArguments());
        return builder;
    }

    private void generateImpl() throws Exception {
        Map<String, Method> methods = FakePlayerClassGenerator.getMethods(Player.class);
        DynamicType.Builder<?> builder = new ByteBuddy().subclass(Player.class, (ConstructorStrategy)ConstructorStrategy.Default.NO_CONSTRUCTORS).implement(new Type[]{IFakePlayer.class}).name(this.getFormattedName());
        builder = this.addFields(builder);
        builder = this.addCtor(builder);
        builder = this.addMethods(builder, methods);
        builder = this.addStubs(builder, methods);
        this.finishBuilder(builder);
    }

    private void finishBuilder(DynamicType.Builder<?> builder) {
        try (DynamicType.Unloaded unloaded = builder.make();){
            this.generatedClass = unloaded.load(this.classLoader, (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded();
            this.generatedConstructor = this.generatedClass.getConstructor(this.getConstructorArgumentTypes());
            Objects.requireNonNull(this.generatedClass, "Failed to construct class with generator: " + this);
            Objects.requireNonNull(this.generatedConstructor, "Failed to find constructor with generator: " + this);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to finish class generator: " + this, e);
        }
    }

    private String getBaseName() {
        return "FakePlayer";
    }

    private Class<?>[] getConstructorArgumentTypes() {
        return Arrays.copyOf(constructorParameterTypes, constructorParameterTypes.length);
    }
}

