/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.compatibility;

import me.ryanhamshire.GriefPrevention.GriefPrevention;
import nl.pim16aap2.bigDoors.compatibility.HookContext;
import nl.pim16aap2.bigDoors.compatibility.IProtectionCompat;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.plugin.Plugin;

class GriefPreventionProtectionCompat
implements IProtectionCompat {
    private final GriefPrevention griefPrevention;
    private boolean success = false;

    public GriefPreventionProtectionCompat(HookContext hookContext) {
        Plugin griefPreventionPlugin = Bukkit.getServer().getPluginManager().getPlugin(hookContext.getProtectionCompatDefinition().getName());
        if (!(griefPreventionPlugin instanceof GriefPrevention)) {
            this.griefPrevention = null;
            return;
        }
        this.griefPrevention = (GriefPrevention)griefPreventionPlugin;
        this.success = true;
    }

    @Override
    public boolean canBreakBlock(Player player, Location loc) {
        BlockBreakEvent blockBreakEvent;
        Block block = loc.getBlock();
        return this.griefPrevention.allowBreak(player, block, loc, blockBreakEvent = new BlockBreakEvent(block, player)) == null;
    }

    @Override
    public boolean canBreakBlocksBetweenLocs(Player player, Location loc1, Location loc2) {
        int x1 = Math.min(loc1.getBlockX(), loc2.getBlockX());
        int y1 = Math.min(loc1.getBlockY(), loc2.getBlockY());
        int z1 = Math.min(loc1.getBlockZ(), loc2.getBlockZ());
        int x2 = Math.max(loc1.getBlockX(), loc2.getBlockX());
        int y2 = Math.max(loc1.getBlockY(), loc2.getBlockY());
        int z2 = Math.max(loc1.getBlockZ(), loc2.getBlockZ());
        for (int xPos = x1; xPos <= x2; ++xPos) {
            for (int yPos = y1; yPos <= y2; ++yPos) {
                for (int zPos = z1; zPos <= z2; ++zPos) {
                    if (this.canBreakBlock(player, new Location(loc1.getWorld(), (double)xPos, (double)yPos, (double)zPos))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean success() {
        return this.success;
    }

    @Override
    public String getName() {
        return this.griefPrevention.getName();
    }
}

