/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.handlers;

import java.text.MessageFormat;
import java.util.UUID;
import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.Door;
import nl.pim16aap2.bigDoors.events.DoorEventToggleStart;
import nl.pim16aap2.bigDoors.toolUsers.ToolUser;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class EventHandlers
implements Listener {
    private final BigDoors plugin;

    public EventHandlers(BigDoors plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onLeftClick(PlayerInteractEvent event) {
        ToolUser tu;
        if (event.getAction() == Action.LEFT_CLICK_BLOCK && this.plugin.getTF().isTool(event.getPlayer().getItemInHand()) && (tu = this.plugin.getToolUser(event.getPlayer())) != null) {
            tu.selector(event.getClickedBlock().getLocation());
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onDoorToggleStart(DoorEventToggleStart event) {
        if (!this.plugin.getConfigLoader().allowNotifications()) {
            return;
        }
        Door door = event.getDoor();
        if (!door.notificationEnabled()) {
            return;
        }
        Player player = Bukkit.getPlayer((UUID)door.getPrimeOwner());
        if (player == null) {
            return;
        }
        if (!player.hasPermission("bigdoors.user.receivenotifications") && !player.isOp()) {
            return;
        }
        player.sendMessage(MessageFormat.format(this.plugin.getMessages().getString("GENERAL.DoorToggleNotification"), door.toSimpleString()));
    }

    @EventHandler
    public void onLogin(PlayerLoginEvent event) {
        this.plugin.getCommander().updatePlayer(event.getPlayer());
    }

    @EventHandler
    public void onLogout(PlayerQuitEvent event) {
        this.plugin.getCommander().removePlayer(event.getPlayer());
        this.plugin.onPlayerLogout(event.getPlayer());
    }

    @EventHandler
    public void onItemDropEvent(PlayerDropItemEvent event) {
        if (this.plugin.getTF().isTool(event.getItemDrop().getItemStack())) {
            ToolUser tu = this.plugin.getToolUser(event.getPlayer());
            if (tu == null) {
                event.getItemDrop().remove();
            } else {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void inventoryClickEvent(InventoryClickEvent event) {
        if (!this.plugin.getTF().isTool(event.getCurrentItem())) {
            return;
        }
        if (event.getAction().equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY) || !event.getClickedInventory().getType().equals((Object)InventoryType.PLAYER)) {
            if (event.getWhoClicked() instanceof Player) {
                ToolUser tu = this.plugin.getToolUser((Player)event.getWhoClicked());
                if (tu == null) {
                    event.getInventory().removeItem(new ItemStack[]{event.getCurrentItem()});
                } else {
                    event.setCancelled(true);
                }
            }
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void inventoryDragEvent(InventoryDragEvent event) {
        event.getNewItems().forEach((K, V) -> {
            if (this.plugin.getTF().isTool((ItemStack)V)) {
                event.setCancelled(true);
            }
        });
    }

    @EventHandler
    public void onItemMoved(InventoryMoveItemEvent event) {
        ToolUser tu;
        if (!this.plugin.getTF().isTool(event.getItem())) {
            return;
        }
        Inventory src = event.getSource();
        if (src instanceof PlayerInventory && ((PlayerInventory)src).getHolder() instanceof Player && (tu = this.plugin.getToolUser((Player)((PlayerInventory)src).getHolder())) != null) {
            event.setCancelled(true);
            return;
        }
        src.removeItem(new ItemStack[]{event.getItem()});
    }
}

