/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.lib.jcalculator;

import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import nl.pim16aap2.bigDoors.lib.jcalculator.Variables;
import nl.pim16aap2.bigDoors.lib.jcalculator.parser;
import nl.pim16aap2.bigDoors.lib.jcalculator.scanner;

public class JCalculator {
    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Please provide a String that contains an expression (e.g. \"1+1\") or a file containing one or more expressions (separated by ';'). For example -f expr.txt");
            return;
        }
        if (args[0].equalsIgnoreCase("-f")) {
            if (args.length == 1) {
                System.out.println("Please provide a file!");
                return;
            }
            try {
                String fileName = args[1];
                System.out.println("Results:");
                int idx = 0;
                for (Double d : JCalculator.getResults(new FileReader(fileName), null, null, false)) {
                    System.out.println(idx++ + ": " + d);
                }
                return;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        try {
            for (String arg : args) {
                System.out.println(arg + " = " + JCalculator.getResult(arg));
            }
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
    }

    private static List<Double> getResults(Reader in, String[] variables, double[] values, boolean debug) throws Exception {
        parser p = new parser(new scanner(in));
        if (variables != null && values != null) {
            p.setVariables(new Variables(Arrays.asList(variables), values));
        }
        if (debug) {
            p.debug_parse();
        } else {
            p.parse();
        }
        return p.getResults();
    }

    public static double getResult(String expression) throws Exception {
        return JCalculator.getResult(expression, null, null);
    }

    public static double getResult(String expression, String[] variables, double[] values) throws Exception {
        return JCalculator.getResults(new StringReader(expression + ";"), variables, values, false).get(0);
    }

    public static double getResult_debug(String expression) throws Exception {
        return JCalculator.getResult_debug(expression, null, null);
    }

    public static double getResult_debug(String expression, String[] variables, double[] values) throws Exception {
        return JCalculator.getResults(new StringReader(expression + ";"), variables, values, true).get(0);
    }
}

