/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.moveBlocks;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.Door;
import nl.pim16aap2.bigDoors.NMS.FallingBlockFactory;
import nl.pim16aap2.bigDoors.events.DoorEventAutoToggle;
import nl.pim16aap2.bigDoors.events.DoorEventToggle;
import nl.pim16aap2.bigDoors.events.DoorEventToggleEnd;
import nl.pim16aap2.bigDoors.lib.universalScheduler.UniversalRunnable;
import nl.pim16aap2.bigDoors.lib.universalScheduler.UniversalScheduler;
import nl.pim16aap2.bigDoors.lib.xseries.XMaterial;
import nl.pim16aap2.bigDoors.util.MyBlockData;
import nl.pim16aap2.bigDoors.util.MyBlockFace;
import nl.pim16aap2.bigDoors.util.Util;
import nl.pim16aap2.bigDoors.util.Vector3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.event.Event;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.Plugin;

public abstract class BlockMover {
    private final BigDoors plugin;
    @Nullable
    private final Door door;
    protected final AtomicBoolean blocksPlaced = new AtomicBoolean(false);
    protected final List<MyBlockData> savedBlocks = new CopyOnWriteArrayList<MyBlockData>();
    private final List<MyBlockData> publicSavedBlocks = Collections.unmodifiableList(this.savedBlocks);
    protected final boolean instantOpen;

    protected BlockMover(BigDoors plugin, @Nullable Door door, boolean instantOpen) {
        this.plugin = plugin;
        this.door = door;
        this.instantOpen = instantOpen;
        if (door == null) {
            return;
        }
        plugin.getAutoCloseScheduler().cancelTimer(door.getDoorUID());
        this.preprocess();
    }

    private void breakBlockNaturallyIfNeeded(Block block) {
        Location location = block.getLocation();
        if (BigDoors.getScheduler().isRegionThread(location)) {
            if (block.getPistonMoveReaction() == PistonMoveReaction.BREAK) {
                BigDoors.getScheduler().runTaskLater(location, () -> ((Block)block).breakNaturally(), 1L);
            }
            return;
        }
        BigDoors.getScheduler().runTaskLater(location, () -> {
            if (block.getPistonMoveReaction() == PistonMoveReaction.BREAK) {
                block.breakNaturally();
            }
        }, 1L);
    }

    private void preprocess() {
        if (this.door == null) {
            return;
        }
        Location powerBlockLoc = this.door.getPowerBlockLoc();
        Location min = this.door.getMinimum();
        Location max = this.door.getMaximum();
        if (!Util.isPosInCuboid(powerBlockLoc, min.clone().add(-1.0, -1.0, -1.0), max.clone().add(1.0, 1.0, 1.0))) {
            return;
        }
        for (MyBlockFace blockFace : MyBlockFace.getValues()) {
            Vector3D vec = MyBlockFace.getDirection(blockFace);
            Location newLocation = powerBlockLoc.clone().add((double)vec.getX(), (double)vec.getY(), (double)vec.getZ());
            if (!Util.isPosInCuboid(newLocation, min, max)) continue;
            this.breakBlockNaturallyIfNeeded(newLocation.getBlock());
        }
        BigDoors.getScheduler().runTask(powerBlockLoc, () -> {
            for (Entity entity : powerBlockLoc.getWorld().getNearbyEntities(powerBlockLoc, 1.1, 1.1, 1.1)) {
                if (!(entity instanceof ItemFrame) || !Util.isPosInCuboid(entity.getLocation(), min, max)) continue;
                ItemFrame itemFrame = (ItemFrame)entity;
                powerBlockLoc.getWorld().dropItemNaturally(itemFrame.getLocation(), itemFrame.getItem());
                powerBlockLoc.getWorld().dropItemNaturally(itemFrame.getLocation(), XMaterial.ITEM_FRAME.parseItem());
                itemFrame.remove();
            }
        });
    }

    public abstract void putBlocks(boolean var1);

    public abstract long getDoorUID();

    public abstract Door getDoor();

    public abstract void cancel(boolean var1);

    public int buttonDelay(int endCount) {
        return Math.max(0, 17 - endCount);
    }

    protected final synchronized void putBlocks(boolean onDisable, final double time, int endCount, LocationFinder locationUpdater, Runnable coordinateUpdater) {
        if (this.blocksPlaced.getAndSet(true)) {
            return;
        }
        World world = Objects.requireNonNull(this.door).getWorld();
        for (MyBlockData savedBlock : this.savedBlocks) {
            Material mat = savedBlock.getMat();
            byte matByte = savedBlock.getBlockByte();
            Location newPos = locationUpdater.apply(savedBlock.getRadius(), savedBlock.getStartX(), savedBlock.getStartY(), savedBlock.getStartZ());
            Runnable runnable = () -> {
                if (!this.instantOpen) {
                    savedBlock.getFBlock().remove();
                }
                if (!savedBlock.getMat().equals((Object)Material.AIR)) {
                    if (BigDoors.isOnFlattenedVersion()) {
                        savedBlock.getBlock().putBlock(newPos);
                        Block b = world.getBlockAt(newPos);
                        BlockState bs = b.getState();
                        bs.update();
                    } else {
                        Block b = world.getBlockAt(newPos);
                        MaterialData matData = savedBlock.getMatData();
                        matData.setData(matByte);
                        b.setType(mat);
                        BlockState bs = b.getState();
                        bs.setData(matData);
                        bs.update();
                    }
                }
            };
            if (!UniversalScheduler.isFolia || BigDoors.getScheduler().isRegionThread(newPos)) {
                runnable.run();
                continue;
            }
            BigDoors.getScheduler().runTask(newPos, runnable);
        }
        coordinateUpdater.run();
        this.toggleOpen(this.door);
        if (onDisable) {
            return;
        }
        new UniversalRunnable(){

            @Override
            public void run() {
                BlockMover.this.plugin.getCommander().setDoorAvailable(BlockMover.this.door.getDoorUID());
                DoorEventToggle.ToggleType toggleType = BlockMover.this.door.isOpen() ? DoorEventToggle.ToggleType.OPEN : DoorEventToggle.ToggleType.CLOSE;
                Bukkit.getPluginManager().callEvent((Event)new DoorEventToggleEnd(BlockMover.this.door, toggleType, BlockMover.this.instantOpen));
                if (BlockMover.this.canAutoToggle(BlockMover.this.door)) {
                    BlockMover.this.plugin.getAutoCloseScheduler().scheduleAutoClose(BlockMover.this.door, time, BlockMover.this.instantOpen);
                }
            }
        }.runTaskLater((Plugin)this.plugin, this.getDelay(endCount));
    }

    private int getDelay(int endCount) {
        return this.buttonDelay(endCount) + Math.min(this.plugin.getMinimumDoorDelay(), this.plugin.getConfigLoader().coolDown() * 20);
    }

    private boolean canAutoToggle(Door door) {
        if (!door.isOpen() || door.getAutoClose() <= 0) {
            return false;
        }
        DoorEventAutoToggle preparationEvent = new DoorEventAutoToggle(door);
        Bukkit.getPluginManager().callEvent((Event)preparationEvent);
        return !preparationEvent.isCancelled();
    }

    protected void toggleOpen(Door door) {
        door.setOpenStatus(!door.isOpen());
    }

    public final List<MyBlockData> getSavedBlocks() {
        return this.publicSavedBlocks;
    }

    protected static FallingBlockFactory.Specification createBlockFactorySpec(BigDoors plugin) {
        return new FallingBlockFactory.Specification(plugin.getConfigLoader().setCustomName());
    }

    @FunctionalInterface
    public static interface LocationFinder {
        public Location apply(double var1, double var3, double var5, double var7);
    }
}

