/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.moveBlocks;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.Door;
import nl.pim16aap2.bigDoors.moveBlocks.BridgeMover;
import nl.pim16aap2.bigDoors.moveBlocks.Opener;
import nl.pim16aap2.bigDoors.moveBlocks.OpenerUtil;
import nl.pim16aap2.bigDoors.util.ChunkUtils;
import nl.pim16aap2.bigDoors.util.DoorDirection;
import nl.pim16aap2.bigDoors.util.DoorOpenResult;
import nl.pim16aap2.bigDoors.util.Pair;
import nl.pim16aap2.bigDoors.util.RotateDirection;
import nl.pim16aap2.bigDoors.util.Util;
import nl.pim16aap2.bigDoors.util.Vector2D;
import org.bukkit.Location;
import org.bukkit.World;

public class BridgeOpener
implements Opener {
    private static final List<RotateDirection> VALID_ROTATE_DIRECTIONS = Collections.unmodifiableList(Arrays.asList(RotateDirection.NORTH, RotateDirection.EAST, RotateDirection.SOUTH, RotateDirection.WEST));
    private final BigDoors plugin;

    public BridgeOpener(BigDoors plugin) {
        this.plugin = plugin;
    }

    @Override
    @Nonnull
    public List<RotateDirection> getValidRotateDirections() {
        return VALID_ROTATE_DIRECTIONS;
    }

    @Override
    public Pair<Vector2D, Vector2D> getChunkRange(Door door) {
        if (!door.isOpen()) {
            return this.getCurrentChunkRange(door);
        }
        DoorDirection doorDirection = this.getOpenDirection(door);
        if (doorDirection == null) {
            this.plugin.getMyLogger().warn("Failed to obtain good chunk range for door: " + door.getDoorUID() + "! Using current range instead!");
            return this.getCurrentChunkRange(door);
        }
        return this.getChunkRange(door, RotateDirection.DOWN, doorDirection);
    }

    private Pair<Vector2D, Vector2D> getChunkRange(Door door, RotateDirection upDown, DoorDirection currentDirection) {
        Pair<Location, Location> newCoordinates = this.getNewCoordinates(door, upDown, currentDirection);
        return ChunkUtils.getChunkRangeBetweenCoords((Location)newCoordinates.first, (Location)newCoordinates.second);
    }

    @Override
    public boolean isRotateDirectionValid(@Nonnull Door door) {
        boolean NS;
        boolean bl = NS = door.getEngSide().equals((Object)DoorDirection.EAST) || door.getEngSide().equals((Object)DoorDirection.WEST);
        if (NS) {
            return door.getOpenDir().equals((Object)RotateDirection.EAST) || door.getOpenDir().equals((Object)RotateDirection.WEST);
        }
        return door.getOpenDir().equals((Object)RotateDirection.NORTH) || door.getOpenDir().equals((Object)RotateDirection.SOUTH);
    }

    @Override
    public RotateDirection getRotateDirection(Door door) {
        if (this.isRotateDirectionValid(door)) {
            return door.getOpenDir();
        }
        return Util.getRotateDirection(DoorDirection.getOpposite(door.getEngSide()));
    }

    @Override
    @Nonnull
    public Optional<Pair<Location, Location>> getNewCoordinates(@Nonnull Door door) {
        int maxDoorSize = this.getSizeLimit(door);
        if (maxDoorSize > 0 && door.getBlockCount() > maxDoorSize) {
            this.plugin.getMyLogger().warn("Size " + door.getBlockCount() + " exceeds limit of " + maxDoorSize + " for drawbridge: " + door);
            return Optional.empty();
        }
        RotateDirection upDown = this.getUpDown(door);
        if (upDown == null) {
            this.plugin.getMyLogger().warn("Found null open direction for drawbridge: " + door);
            return Optional.empty();
        }
        DoorDirection currentDirection = this.getCurrentDirection(door);
        if (currentDirection == null) {
            this.plugin.getMyLogger().warn("Current direction is null for drawbridge " + door + "!");
            return Optional.empty();
        }
        OpeningSpecification openingSpecification = this.getOpeningSpecification(door, upDown, currentDirection);
        if (openingSpecification == null) {
            this.plugin.getMyLogger().info("Failed to find open direction for drawbridge " + door + " because it is obstructed!");
            return Optional.empty();
        }
        return Optional.of(new Pair<Location, Location>(openingSpecification.min, openingSpecification.max));
    }

    @Nonnull
    private Pair<Location, Location> getNewCoordinates(@Nonnull Door door, @Nonnull RotateDirection upDown, @Nonnull DoorDirection currentDirection) {
        int startX = 0;
        int startY = 0;
        int startZ = 0;
        int endX = 0;
        int endY = 0;
        int endZ = 0;
        World world = door.getWorld();
        if (upDown.equals((Object)RotateDirection.UP)) {
            switch (currentDirection) {
                case NORTH: {
                    startX = door.getMinimum().getBlockX();
                    endX = door.getMaximum().getBlockX();
                    startY = door.getMinimum().getBlockY() + 1;
                    endY = door.getMinimum().getBlockY() + door.getMaximum().getBlockZ() - door.getMinimum().getBlockZ();
                    startZ = door.getMinimum().getBlockZ();
                    endZ = door.getMinimum().getBlockZ();
                    break;
                }
                case SOUTH: {
                    startX = door.getMinimum().getBlockX();
                    endX = door.getMaximum().getBlockX();
                    startY = door.getMinimum().getBlockY() + 1;
                    endY = door.getMinimum().getBlockY() + door.getMaximum().getBlockZ() - door.getMinimum().getBlockZ();
                    startZ = door.getMaximum().getBlockZ();
                    endZ = door.getMaximum().getBlockZ();
                    break;
                }
                case EAST: {
                    startX = door.getMaximum().getBlockX();
                    endX = door.getMaximum().getBlockX();
                    startY = door.getMinimum().getBlockY() + 1;
                    endY = door.getMinimum().getBlockY() + door.getMaximum().getBlockX() - door.getMinimum().getBlockX();
                    startZ = door.getMinimum().getBlockZ();
                    endZ = door.getMaximum().getBlockZ();
                    break;
                }
                case WEST: {
                    startX = door.getMinimum().getBlockX();
                    endX = door.getMinimum().getBlockX();
                    startY = door.getMinimum().getBlockY() + 1;
                    endY = door.getMinimum().getBlockY() + door.getMaximum().getBlockX() - door.getMinimum().getBlockX();
                    startZ = door.getMinimum().getBlockZ();
                    endZ = door.getMaximum().getBlockZ();
                }
            }
        } else {
            switch (currentDirection) {
                case NORTH: {
                    startX = door.getMinimum().getBlockX();
                    endX = door.getMaximum().getBlockX();
                    startY = door.getMinimum().getBlockY();
                    endY = door.getMinimum().getBlockY();
                    startZ = door.getMinimum().getBlockZ() - door.getMaximum().getBlockY() + door.getMinimum().getBlockY();
                    endZ = door.getMinimum().getBlockZ() - 1;
                    break;
                }
                case SOUTH: {
                    startX = door.getMinimum().getBlockX();
                    endX = door.getMaximum().getBlockX();
                    startY = door.getMinimum().getBlockY();
                    endY = door.getMinimum().getBlockY();
                    startZ = door.getMinimum().getBlockZ() + 1;
                    endZ = door.getMinimum().getBlockZ() + door.getMaximum().getBlockY() - door.getMinimum().getBlockY();
                    break;
                }
                case EAST: {
                    startX = door.getMinimum().getBlockX() + 1;
                    endX = door.getMaximum().getBlockX() + door.getMaximum().getBlockY() - door.getMinimum().getBlockY();
                    startY = door.getMinimum().getBlockY();
                    endY = door.getMinimum().getBlockY();
                    startZ = door.getMinimum().getBlockZ();
                    endZ = door.getMaximum().getBlockZ();
                    break;
                }
                case WEST: {
                    startX = door.getMinimum().getBlockX() - door.getMaximum().getBlockY() + door.getMinimum().getBlockY();
                    endX = door.getMinimum().getBlockX() - 1;
                    startY = door.getMinimum().getBlockY();
                    endY = door.getMinimum().getBlockY();
                    startZ = door.getMinimum().getBlockZ();
                    endZ = door.getMaximum().getBlockZ();
                }
            }
        }
        return new Pair<Location, Location>(new Location(world, (double)startX, (double)startY, (double)startZ), new Location(world, (double)endX, (double)endY, (double)endZ));
    }

    public RotateDirection getUpDown(Door door) {
        int height = Math.abs(door.getMinimum().getBlockY() - door.getMaximum().getBlockY());
        if (height > 0) {
            return RotateDirection.DOWN;
        }
        return RotateDirection.UP;
    }

    @Nullable
    private DoorDirection getOpenDirection(Door door) {
        boolean NS;
        Optional<DoorDirection> newDir;
        if (door.getOpenDir() == null) {
            return null;
        }
        RotateDirection upDown = this.getUpDown(door);
        DoorDirection cDir = this.getCurrentDirection(door);
        if (upDown == null || cDir == null) {
            return null;
        }
        if (upDown.equals((Object)RotateDirection.UP)) {
            return door.getEngSide();
        }
        if (this.isRotateDirectionValid(door) && (newDir = Util.getDoorDirection(door.getOpenDir()).map(dir -> door.isOpen() ? DoorDirection.getOpposite(dir) : dir)).isPresent()) {
            return newDir.get();
        }
        boolean bl = NS = cDir == DoorDirection.NORTH || cDir == DoorDirection.SOUTH;
        if (door.getOpenDir().equals((Object)RotateDirection.CLOCKWISE) && !door.isOpen() || door.getOpenDir().equals((Object)RotateDirection.COUNTERCLOCKWISE) && door.isOpen()) {
            return NS ? DoorDirection.SOUTH : DoorDirection.EAST;
        }
        if (door.getOpenDir().equals((Object)RotateDirection.CLOCKWISE) && door.isOpen() || door.getOpenDir().equals((Object)RotateDirection.COUNTERCLOCKWISE) && !door.isOpen()) {
            return NS ? DoorDirection.NORTH : DoorDirection.WEST;
        }
        return null;
    }

    @Nullable
    private OpeningSpecification findFirstValidSpecification(@Nonnull Door door, @Nonnull RotateDirection upDown, DoorDirection ... directions) {
        for (DoorDirection fallbackDirection : directions) {
            Pair<Location, Location> newCoordinates = this.getNewCoordinates(door, upDown, fallbackDirection);
            if (!this.isPosFree(door.getDoorUID(), door.getWorld(), newCoordinates)) continue;
            return new OpeningSpecification(fallbackDirection, newCoordinates);
        }
        return null;
    }

    @Nullable
    private OpeningSpecification getOpeningSpecification(@Nonnull Door door, @Nonnull RotateDirection upDown, @Nonnull DoorDirection currentDirection) {
        boolean NS;
        DoorDirection openDirection = this.getOpenDirection(door);
        if (this.isValidOpenDirection(Util.getRotateDirection(openDirection))) {
            Pair<Location, Location> newCoordinates = this.getNewCoordinates(door, upDown, openDirection);
            return this.isPosFree(door.getDoorUID(), door.getWorld(), newCoordinates) ? new OpeningSpecification(openDirection, newCoordinates) : null;
        }
        boolean bl = NS = currentDirection == DoorDirection.NORTH || currentDirection == DoorDirection.SOUTH;
        if (NS) {
            return this.findFirstValidSpecification(door, upDown, DoorDirection.NORTH, DoorDirection.SOUTH);
        }
        return this.findFirstValidSpecification(door, upDown, DoorDirection.EAST, DoorDirection.WEST);
    }

    private DoorDirection getCurrentDirection(Door door) {
        return door.getEngSide();
    }

    @Override
    @Nonnull
    public CompletableFuture<DoorOpenResult> openDoorFuture(@Nonnull Door door, double time, boolean instantOpen, boolean silent, @Nonnull ChunkUtils.ChunkLoadMode mode, boolean bypassProtectionHooks) {
        return OpenerUtil.rescheduleTaskForLocationIfNeeded(door, () -> this.openDoorFuture0(door, time, instantOpen, silent, mode, bypassProtectionHooks));
    }

    @Nonnull
    private CompletableFuture<DoorOpenResult> openDoorFuture0(@Nonnull Door door, double time, boolean instantOpen, boolean silent, @Nonnull ChunkUtils.ChunkLoadMode mode, boolean bypassProtectionHooks) {
        int maxDoorSize;
        DoorDirection currentDirection;
        this.plugin.assertSchedulerRunning();
        if (!this.plugin.getCommander().canGo()) {
            this.plugin.getMyLogger().info("Failed to toggle: " + door.toSimpleString() + ", as door toggles are currently disabled!");
            return CompletableFuture.completedFuture(this.abort(DoorOpenResult.ERROR, door.getDoorUID()));
        }
        if (this.plugin.getCommander().isDoorBusyRegisterIfNot(door.getDoorUID())) {
            if (!silent) {
                this.plugin.getMyLogger().myLogger(Level.INFO, "Bridge " + door.toSimpleString() + " is not available right now!");
            }
            return CompletableFuture.completedFuture(this.abort(DoorOpenResult.BUSY, door.getDoorUID()));
        }
        ChunkUtils.ChunkLoadResult chunkLoadResult = this.chunksLoaded(door, mode);
        if (chunkLoadResult == ChunkUtils.ChunkLoadResult.FAIL) {
            this.plugin.getMyLogger().logMessage("Chunks for bridge " + door.toSimpleString() + " are not loaded!", true, false);
            return CompletableFuture.completedFuture(this.abort(DoorOpenResult.CHUNKSNOTLOADED, door.getDoorUID()));
        }
        if (chunkLoadResult == ChunkUtils.ChunkLoadResult.REQUIRED_LOAD) {
            instantOpen = true;
        }
        if ((currentDirection = this.getCurrentDirection(door)) == null) {
            this.plugin.getMyLogger().logMessage("Current direction is null for bridge " + door.toSimpleString() + "!", true, false);
            return CompletableFuture.completedFuture(this.abort(DoorOpenResult.ERROR, door.getDoorUID()));
        }
        RotateDirection upDown = this.getUpDown(door);
        if (upDown == null) {
            this.plugin.getMyLogger().logMessage("UpDown direction is null for bridge " + door.toSimpleString() + "!", true, false);
            return CompletableFuture.completedFuture(this.abort(DoorOpenResult.ERROR, door.getDoorUID()));
        }
        OpeningSpecification openingSpecification = this.getOpeningSpecification(door, upDown, currentDirection);
        if (openingSpecification == null) {
            this.plugin.getMyLogger().warn("Could not determine opening direction for door: " + door + "!");
            return CompletableFuture.completedFuture(this.abort(DoorOpenResult.NODIRECTION, door.getDoorUID()));
        }
        if (!this.isRotateDirectionValid(door)) {
            RotateDirection newRotDir = Util.getRotateDirection(openingSpecification.openDirection);
            if (door.isOpen()) {
                newRotDir = RotateDirection.getOpposite(newRotDir);
            }
            this.plugin.getMyLogger().logMessage("Updating openDirection of drawbridge " + door.toSimpleString() + " to " + (Object)((Object)newRotDir) + ". If this is undesired, change it via the GUI.", true, false);
            this.plugin.getCommander().updateDoorOpenDirection(door.getDoorUID(), newRotDir);
        }
        if ((maxDoorSize = this.getSizeLimit(door)) > 0 && door.getBlockCount() > maxDoorSize) {
            this.plugin.getMyLogger().logMessage("Door " + door.toSimpleString() + " Exceeds the size limit: " + maxDoorSize, true, false);
            return CompletableFuture.completedFuture(this.abort(DoorOpenResult.ERROR, door.getDoorUID()));
        }
        if (this.fireDoorEventTogglePrepare(door, instantOpen)) {
            return CompletableFuture.completedFuture(this.abort(DoorOpenResult.CANCELLED, door.getDoorUID()));
        }
        if (bypassProtectionHooks) {
            return CompletableFuture.completedFuture(this.openDoor0(door, time, upDown, instantOpen, openingSpecification));
        }
        boolean instantOpen0 = instantOpen;
        return ((CompletableFuture)this.hasAccessToLocations(door, openingSpecification.min, openingSpecification.max).thenCompose(hasAccess -> {
            if (!hasAccess.booleanValue()) {
                return CompletableFuture.completedFuture(this.abort(DoorOpenResult.NOPERMISSION, door.getDoorUID()));
            }
            return Util.runSync(() -> this.openDoor0(door, time, upDown, instantOpen0, openingSpecification), 1L, TimeUnit.SECONDS, DoorOpenResult.ERROR);
        })).exceptionally(throwable -> Util.exceptionally(throwable, DoorOpenResult.ERROR));
    }

    private DoorOpenResult openDoor0(Door door, double time, RotateDirection upDown, boolean instantOpen, OpeningSpecification openingSpecification) {
        this.plugin.getCommander().addBlockMover(new BridgeMover(this.plugin, door.getWorld(), time, door, upDown, openingSpecification.openDirection, instantOpen, this.plugin.getConfigLoader().dbMultiplier()));
        this.fireDoorEventToggleStart(door, instantOpen);
        return DoorOpenResult.SUCCESS;
    }

    private static final class OpeningSpecification {
        public final DoorDirection openDirection;
        public final Location min;
        public final Location max;

        public OpeningSpecification(DoorDirection openDirection, Location min, Location max) {
            this.openDirection = openDirection;
            this.min = min;
            this.max = max;
        }

        public OpeningSpecification(DoorDirection openDirection, Pair<Location, Location> locations) {
            this(openDirection, (Location)locations.first, (Location)locations.second);
        }
    }
}

