/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.moveBlocks;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.Door;
import nl.pim16aap2.bigDoors.moveBlocks.CylindricalMover;
import nl.pim16aap2.bigDoors.moveBlocks.Opener;
import nl.pim16aap2.bigDoors.moveBlocks.OpenerUtil;
import nl.pim16aap2.bigDoors.util.ChunkUtils;
import nl.pim16aap2.bigDoors.util.DoorDirection;
import nl.pim16aap2.bigDoors.util.DoorOpenResult;
import nl.pim16aap2.bigDoors.util.Pair;
import nl.pim16aap2.bigDoors.util.RotateDirection;
import nl.pim16aap2.bigDoors.util.Util;
import nl.pim16aap2.bigDoors.util.Vector2D;
import org.bukkit.Location;
import org.bukkit.World;

public class DoorOpener
implements Opener {
    private static final List<RotateDirection> VALID_ROTATE_DIRECTIONS = Collections.unmodifiableList(Arrays.asList(RotateDirection.CLOCKWISE, RotateDirection.COUNTERCLOCKWISE));
    private final BigDoors plugin;

    public DoorOpener(BigDoors plugin) {
        this.plugin = plugin;
    }

    @Override
    public Pair<Vector2D, Vector2D> getChunkRange(Door door) {
        return this.getChunkRange(door, this.getNewDirection(door));
    }

    @Override
    @Nonnull
    public List<RotateDirection> getValidRotateDirections() {
        return VALID_ROTATE_DIRECTIONS;
    }

    private Pair<Vector2D, Vector2D> getChunkRange(Door door, DoorDirection newDirection) {
        if (newDirection == null) {
            this.plugin.getMyLogger().warn("Failed to obtain good chunk range for door: " + door.toSimpleString() + "! Using current range instead!");
            return this.getCurrentChunkRange(door);
        }
        Pair<Location, Location> newLocations = this.getNewCoordinates(door, newDirection);
        return this.getChunkRange(door, (Location)newLocations.first, (Location)newLocations.second);
    }

    private Pair<Vector2D, Vector2D> getChunkRange(Door door, Location newMin, Location newMax) {
        return ChunkUtils.getChunkRangeBetweenSortedCoords(newMin, door.getMinimum(), newMax, door.getMaximum());
    }

    @Override
    public RotateDirection getRotateDirection(Door door) {
        if (this.isRotateDirectionValid(door)) {
            return door.getOpenDir();
        }
        RotateDirection defaultDirection = RotateDirection.CLOCKWISE;
        DoorDirection currentDirection = this.getCurrentDirection(door);
        if (currentDirection == null) {
            return defaultDirection;
        }
        OpeningSpecification openingSpecification = this.getOpeningSpecification(door, this.getOpenDirection(door), currentDirection);
        return openingSpecification == null ? defaultDirection : openingSpecification.rotateDirection;
    }

    @Nullable
    private DoorDirection getNewDirection(@Nonnull Door door) {
        RotateDirection openDir;
        DoorDirection currentDir = this.getCurrentDirection(door);
        if (currentDir == null) {
            return null;
        }
        RotateDirection rotateDirection = openDir = door.isOpen() ? RotateDirection.getOpposite(door.getOpenDir()) : door.getOpenDir();
        if (!this.isRotateDirectionValid(door)) {
            return null;
        }
        return this.getNewDirection(currentDir, openDir);
    }

    @Nonnull
    private DoorDirection getNewDirection(@Nonnull DoorDirection currentDirection, @Nullable RotateDirection rotateDirection) {
        return RotateDirection.CLOCKWISE.equals((Object)rotateDirection) ? DoorDirection.cycleCardinalDirection(currentDirection) : DoorDirection.cycleCardinalDirectionReverse(currentDirection);
    }

    private Pair<Location, Location> getNewCoordinates(Door door, DoorDirection newDirection) {
        Location engLoc = door.getEngine();
        int startX = engLoc.getBlockX();
        int startY = door.getMinimum().getBlockY();
        int startZ = engLoc.getBlockZ();
        int endX = engLoc.getBlockX();
        int endY = door.getMaximum().getBlockY();
        int endZ = engLoc.getBlockZ();
        int xLen = door.getMaximum().getBlockX() - door.getMinimum().getBlockX();
        int zLen = door.getMaximum().getBlockZ() - door.getMinimum().getBlockZ();
        World world = door.getWorld();
        switch (newDirection) {
            case NORTH: {
                startZ = engLoc.getBlockZ() - xLen;
                endZ = engLoc.getBlockZ() - 1;
                break;
            }
            case EAST: {
                startX = engLoc.getBlockX() + 1;
                endX = engLoc.getBlockX() + zLen;
                endZ = engLoc.getBlockZ();
                break;
            }
            case SOUTH: {
                startZ = engLoc.getBlockZ() + 1;
                endZ = engLoc.getBlockZ() + xLen;
                break;
            }
            case WEST: {
                startX = engLoc.getBlockX() - zLen;
                endX = engLoc.getBlockX() - 1;
            }
        }
        return new Pair<Location, Location>(new Location(world, (double)startX, (double)startY, (double)startZ), new Location(world, (double)endX, (double)endY, (double)endZ));
    }

    @Nullable
    private OpeningSpecification getOpeningSpecification(@Nonnull Door door, @Nullable RotateDirection rotateDirection, @Nonnull DoorDirection currentDirection) {
        if (this.isValidOpenDirection(rotateDirection)) {
            DoorDirection newDirection = this.getNewDirection(currentDirection, rotateDirection);
            Pair<Location, Location> newCoordinates = this.getNewCoordinates(door, newDirection);
            return this.isPosFree(door.getDoorUID(), door.getWorld(), newCoordinates) ? new OpeningSpecification(rotateDirection, newCoordinates) : null;
        }
        this.plugin.getMyLogger().info("Encountered invalid open direction " + (Object)((Object)rotateDirection) + " for door " + door + "!\nWe will try to find a valid open direction now!");
        for (RotateDirection fallbackDirection : this.getValidRotateDirections()) {
            DoorDirection newDirection = this.getNewDirection(currentDirection, fallbackDirection);
            Pair<Location, Location> newCoordinates = this.getNewCoordinates(door, newDirection);
            if (!this.isPosFree(door.getDoorUID(), door.getWorld(), newCoordinates)) continue;
            return new OpeningSpecification(fallbackDirection, newCoordinates);
        }
        return null;
    }

    @Override
    @Nonnull
    public Optional<Pair<Location, Location>> getNewCoordinates(@Nonnull Door door) {
        RotateDirection openDirection = this.getOpenDirection(door);
        if (!this.isValidOpenDirection(openDirection)) {
            this.plugin.getMyLogger().warn("Invalid open direction " + (Object)((Object)openDirection) + " for door: " + door);
            return Optional.empty();
        }
        int maxDoorSize = this.getSizeLimit(door);
        if (maxDoorSize > 0 && door.getBlockCount() > maxDoorSize) {
            this.plugin.getMyLogger().warn("Size " + door.getBlockCount() + " exceeds limit of " + maxDoorSize + " for door: " + door);
            return Optional.empty();
        }
        DoorDirection currentDirection = this.getCurrentDirection(door);
        if (currentDirection == null) {
            this.plugin.getMyLogger().warn("Current direction is null for door " + door);
            return Optional.empty();
        }
        OpeningSpecification openingSpecification = this.getOpeningSpecification(door, openDirection, currentDirection);
        if (openingSpecification == null) {
            this.plugin.getMyLogger().info("Failed to find open direction for door " + door + " because it is obstructed!");
            return Optional.empty();
        }
        return Optional.of(new Pair<Location, Location>(openingSpecification.min, openingSpecification.max));
    }

    @Nullable
    private RotateDirection getOpenDirection(Door door) {
        RotateDirection openDir = door.getOpenDir();
        if (openDir == null) {
            return null;
        }
        return openDir.equals((Object)RotateDirection.CLOCKWISE) && door.isOpen() ? RotateDirection.COUNTERCLOCKWISE : (openDir.equals((Object)RotateDirection.COUNTERCLOCKWISE) && door.isOpen() ? RotateDirection.CLOCKWISE : openDir);
    }

    private DoorDirection getCurrentDirection(Door door) {
        return door.getEngine().getBlockZ() != door.getMinimum().getBlockZ() ? DoorDirection.NORTH : (door.getEngine().getBlockX() != door.getMaximum().getBlockX() ? DoorDirection.EAST : (door.getEngine().getBlockZ() != door.getMaximum().getBlockZ() ? DoorDirection.SOUTH : (door.getEngine().getBlockX() != door.getMinimum().getBlockX() ? DoorDirection.WEST : null)));
    }

    @Override
    @Nonnull
    public CompletableFuture<DoorOpenResult> openDoorFuture(@Nonnull Door door, double time, boolean instantOpen, boolean silent, @Nonnull ChunkUtils.ChunkLoadMode mode, boolean bypassProtectionHooks) {
        return OpenerUtil.rescheduleTaskForLocationIfNeeded(door, () -> this.openDoorFuture0(door, time, instantOpen, silent, mode, bypassProtectionHooks));
    }

    @Nonnull
    private CompletableFuture<DoorOpenResult> openDoorFuture0(@Nonnull Door door, double time, boolean instantOpen, boolean silent, @Nonnull ChunkUtils.ChunkLoadMode mode, boolean bypassProtectionHooks) {
        DoorDirection currentDirection;
        this.plugin.assertSchedulerRunning();
        if (!this.plugin.getCommander().canGo()) {
            this.plugin.getMyLogger().info("Failed to toggle: " + door.toSimpleString() + ", as door toggles are currently disabled!");
            return CompletableFuture.completedFuture(this.abort(DoorOpenResult.ERROR, door.getDoorUID()));
        }
        if (this.plugin.getCommander().isDoorBusyRegisterIfNot(door.getDoorUID())) {
            if (!silent) {
                this.plugin.getMyLogger().myLogger(Level.INFO, "Door " + door.toSimpleString() + " is not available right now!");
            }
            return CompletableFuture.completedFuture(this.abort(DoorOpenResult.BUSY, door.getDoorUID()));
        }
        ChunkUtils.ChunkLoadResult chunkLoadResult = this.chunksLoaded(door, mode);
        if (chunkLoadResult == ChunkUtils.ChunkLoadResult.FAIL) {
            this.plugin.getMyLogger().logMessage("Chunks for door " + door.toSimpleString() + " are not loaded!", true, false);
            return CompletableFuture.completedFuture(this.abort(DoorOpenResult.CHUNKSNOTLOADED, door.getDoorUID()));
        }
        if (chunkLoadResult == ChunkUtils.ChunkLoadResult.REQUIRED_LOAD) {
            instantOpen = true;
        }
        if ((currentDirection = this.getCurrentDirection(door)) == null) {
            this.plugin.getMyLogger().logMessage("Current direction is null for door " + door.toSimpleString() + "!", true, false);
            return CompletableFuture.completedFuture(this.abort(DoorOpenResult.ERROR, door.getDoorUID()));
        }
        OpeningSpecification openingSpecification = this.getOpeningSpecification(door, this.getOpenDirection(door), currentDirection);
        if (openingSpecification == null) {
            this.plugin.getMyLogger().warn("Could not determine opening direction for door: " + door + "!");
            return CompletableFuture.completedFuture(this.abort(DoorOpenResult.NODIRECTION, door.getDoorUID()));
        }
        if (!this.isRotateDirectionValid(door)) {
            RotateDirection newRotDirection = openingSpecification.rotateDirection;
            if (door.isOpen()) {
                newRotDirection = newRotDirection.equals((Object)RotateDirection.CLOCKWISE) ? RotateDirection.COUNTERCLOCKWISE : RotateDirection.CLOCKWISE;
            }
            this.plugin.getMyLogger().logMessage("Updating openDirection of door " + door.toSimpleString() + " to " + newRotDirection.name() + ". If this is undesired, change it via the GUI.", true, false);
            this.plugin.getCommander().updateDoorOpenDirection(door.getDoorUID(), newRotDirection);
        }
        int xOpposite = door.getMaximum().getBlockX() != door.getEngine().getBlockX() ? door.getMaximum().getBlockX() : door.getMinimum().getBlockX();
        int zOpposite = door.getMaximum().getBlockZ() != door.getEngine().getBlockZ() ? door.getMaximum().getBlockZ() : door.getMinimum().getBlockZ();
        int yOpposite = door.getMaximum().getBlockY() != door.getEngine().getBlockY() ? door.getMaximum().getBlockY() : door.getMinimum().getBlockY();
        Location oppositePoint = new Location(door.getWorld(), (double)xOpposite, (double)yOpposite, (double)zOpposite);
        int maxDoorSize = this.getSizeLimit(door);
        if (maxDoorSize > 0 && door.getBlockCount() > maxDoorSize) {
            this.plugin.getMyLogger().logMessage("Door " + door.toSimpleString() + " Exceeds the size limit: " + maxDoorSize, true, false);
            return CompletableFuture.completedFuture(this.abort(DoorOpenResult.ERROR, door.getDoorUID()));
        }
        if (this.fireDoorEventTogglePrepare(door, instantOpen)) {
            return CompletableFuture.completedFuture(this.abort(DoorOpenResult.CANCELLED, door.getDoorUID()));
        }
        if (bypassProtectionHooks) {
            return CompletableFuture.completedFuture(this.openDoor0(door, oppositePoint, openingSpecification, time, instantOpen, currentDirection));
        }
        boolean instantOpen0 = instantOpen;
        return ((CompletableFuture)this.hasAccessToLocations(door, openingSpecification.min, openingSpecification.max).thenCompose(hasAccess -> {
            if (!hasAccess.booleanValue()) {
                return CompletableFuture.completedFuture(this.abort(DoorOpenResult.NOPERMISSION, door.getDoorUID()));
            }
            return Util.runSync(() -> this.openDoor0(door, oppositePoint, openingSpecification, time, instantOpen0, currentDirection), 1L, TimeUnit.SECONDS, DoorOpenResult.ERROR);
        })).exceptionally(throwable -> Util.exceptionally(throwable, DoorOpenResult.ERROR));
    }

    private DoorOpenResult openDoor0(Door door, Location oppositePoint, OpeningSpecification openingSpecification, double time, boolean instantOpen, DoorDirection currentDirection) {
        this.plugin.getCommander().addBlockMover(new CylindricalMover(this.plugin, oppositePoint.getWorld(), 1, openingSpecification.rotateDirection, time, oppositePoint, currentDirection, door, instantOpen, this.plugin.getConfigLoader().bdMultiplier()));
        this.fireDoorEventToggleStart(door, instantOpen);
        return DoorOpenResult.SUCCESS;
    }

    private static final class OpeningSpecification {
        public final RotateDirection rotateDirection;
        public final Location min;
        public final Location max;

        public OpeningSpecification(RotateDirection rotateDirection, Location min, Location max) {
            this.rotateDirection = rotateDirection;
            this.min = min;
            this.max = max;
        }

        public OpeningSpecification(RotateDirection rotateDirection, Pair<Location, Location> locations) {
            this(rotateDirection, (Location)locations.first, (Location)locations.second);
        }
    }
}

