/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.moveBlocks;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.Door;
import nl.pim16aap2.bigDoors.lib.universalScheduler.UniversalScheduler;
import nl.pim16aap2.bigDoors.util.DoorOpenResult;

class OpenerUtil {
    private OpenerUtil() {
    }

    static CompletableFuture<DoorOpenResult> rescheduleTaskForLocationIfNeeded(Door door, Supplier<CompletableFuture<DoorOpenResult>> task) {
        if (OpenerUtil.shouldRescheduleTaskForLocation(door)) {
            return OpenerUtil.rescheduleTaskForLocation(door, task);
        }
        return task.get();
    }

    static boolean shouldRescheduleTaskForLocation(Door door) {
        return UniversalScheduler.isFolia && !BigDoors.getScheduler().isRegionThread(door.getEngine());
    }

    static CompletableFuture<DoorOpenResult> rescheduleTaskForLocation(Door door, Supplier<CompletableFuture<DoorOpenResult>> task) {
        CompletableFuture result = new CompletableFuture();
        BigDoors.getScheduler().runTask(door.getEngine(), () -> ((CompletableFuture)task.get()).whenComplete((doorOpenResult, throwable) -> {
            if (throwable != null) {
                result.completeExceptionally((Throwable)throwable);
                return;
            }
            result.complete(doorOpenResult);
        }));
        return result.exceptionally(ex -> {
            BigDoors.get().getMyLogger().log("Failed to reschedule task for door: " + door, (Throwable)ex);
            return DoorOpenResult.ERROR;
        });
    }
}

