/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.reflection;

import java.lang.reflect.Constructor;
import java.util.Objects;
import nl.pim16aap2.bigDoors.reflection.ReflectionBackend;
import nl.pim16aap2.bigDoors.reflection.ReflectionFinder;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ConstructorFinder {
    @Contract(value="_ -> new")
    public ConstructorFinderInSource inClass(@NotNull Class<?> source) {
        return new ConstructorFinderInSource(Objects.requireNonNull(source, "Source class cannot be null!"));
    }

    public static final class ConstructorFinderInSource
    extends ReflectionFinder.ReflectionFinderWithParameters<Constructor<?>, ConstructorFinderInSource> {
        @NotNull
        private final Class<?> source;

        private ConstructorFinderInSource(@NotNull Class<?> source) {
            this.source = source;
        }

        @Override
        public Constructor<?> get() {
            return ReflectionBackend.findCTor(this.nonnull, this.source, this.modifiers, this.parameters);
        }
    }
}

