/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.reflection;

import java.util.Objects;
import nl.pim16aap2.bigDoors.reflection.ParameterGroup;
import nl.pim16aap2.bigDoors.reflection.ReflectionBackend;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ReflectionFinder<T, U extends ReflectionFinder<T, U>> {
    protected boolean nonnull = true;
    protected int modifiers = 0;

    protected ReflectionFinder() {
    }

    protected ReflectionFinder(@NotNull ReflectionFinder<?, ?> other) {
        this.nonnull = Objects.requireNonNull(other, (String)"Copy constructor cannot copy from null object!").nonnull;
        this.modifiers = other.modifiers;
    }

    public abstract T get();

    @Contract(value=" -> this")
    public U setNullable() {
        this.nonnull = false;
        return (U)this;
    }

    @Contract(value=" -> this")
    public U setNonnull() {
        this.nonnull = true;
        return (U)this;
    }

    @Contract(value="_ -> this")
    public U withModifiers(int ... mods) {
        this.modifiers = ReflectionBackend.getModifiers(mods);
        return (U)this;
    }

    @Contract(value="_ -> this")
    public U addModifiers(int ... mods) {
        for (int mod : mods) {
            this.modifiers |= mod;
        }
        return (U)this;
    }

    public static abstract class ReflectionFinderWithParameters<T, U extends ReflectionFinderWithParameters<T, U>>
    extends ReflectionFinder<T, U> {
        @Nullable
        protected ParameterGroup parameters;

        protected ReflectionFinderWithParameters() {
        }

        protected ReflectionFinderWithParameters(@NotNull ReflectionFinderWithParameters<?, ?> other) {
            super(other);
            this.parameters = other.parameters == null ? null : new ParameterGroup(other.parameters);
        }

        @Contract(value=" -> this")
        public U withoutParameters() {
            this.parameters = new ParameterGroup.Builder().construct();
            return (U)this;
        }

        @Contract(value=" -> this")
        public U ignoreParameters() {
            this.parameters = null;
            return (U)this;
        }

        @Contract(value="_ -> this")
        public U withParameters(Class<?> ... parameters) {
            this.parameters = new ParameterGroup.Builder().withRequiredParameters(parameters).construct();
            return (U)this;
        }

        @Contract(value="_ -> this")
        public U withParameters(@NotNull ParameterGroup parameters) {
            this.parameters = parameters;
            return (U)this;
        }

        @Contract(value="_ -> this")
        public U withParameters(@NotNull ParameterGroup.Builder parameters) {
            this.parameters = parameters.construct();
            return (U)this;
        }
    }
}

