/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.reflection.asm;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Executable;
import nl.pim16aap2.bigDoors.lib.asm.AnnotationVisitor;
import nl.pim16aap2.bigDoors.lib.asm.ClassReader;
import nl.pim16aap2.bigDoors.lib.asm.ClassVisitor;
import nl.pim16aap2.bigDoors.lib.asm.ClassWriter;
import nl.pim16aap2.bigDoors.lib.asm.FieldVisitor;
import nl.pim16aap2.bigDoors.lib.asm.MethodVisitor;
import nl.pim16aap2.bigDoors.lib.asm.util.Textifier;
import nl.pim16aap2.bigDoors.lib.asm.util.TraceAnnotationVisitor;
import nl.pim16aap2.bigDoors.lib.asm.util.TraceFieldVisitor;
import nl.pim16aap2.bigDoors.lib.asm.util.TraceMethodVisitor;
import nl.pim16aap2.bigDoors.reflection.asm.ASMUtil;
import org.jetbrains.annotations.NotNull;

public final class ASMDebugging {
    private ASMDebugging() {
    }

    public static void printClassBytecode(Class<?> clz) {
        try {
            PrintWriter pw = new PrintWriter(System.out);
            pw.println("Going to print bytecode for class: '" + clz + "'\n");
            int debugTypes = 7;
            ClassReader cr = ASMUtil.getClassReader(clz);
            ClassWriter cw = new ClassWriter(cr, 1);
            DebugClassVisitor cv = new DebugClassVisitor(cw, 7, pw);
            cr.accept(cv, 0);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to print bytecode for class '" + clz + "'", e);
        }
    }

    public static void printMethodBytecode(Executable executable) throws IOException {
        ASMDebugging.printMethodBytecode(executable, new PrintWriter(System.out));
    }

    public static void printMethodBytecode(Executable executable, PrintWriter printWriter) throws IOException {
        ASMUtil.processMethod(executable, mv -> ASMDebugging.getDebugMethodVisitor(mv, printWriter), null);
    }

    private static MethodVisitor getDebugMethodVisitor(MethodVisitor visitor, final PrintWriter printWriter) {
        return new TraceMethodVisitor(visitor, new Textifier(589824){

            @Override
            public void visitMethodEnd() {
                this.print(printWriter);
                printWriter.flush();
            }
        });
    }

    private static FieldVisitor getDebugFieldVisitor(FieldVisitor visitor, final PrintWriter printWriter) {
        return new TraceFieldVisitor(visitor, new Textifier(589824){

            @Override
            public void visitFieldEnd() {
                this.print(printWriter);
                printWriter.flush();
            }
        });
    }

    private static AnnotationVisitor getDebugAnnotationVisitor(AnnotationVisitor visitor, final PrintWriter printWriter) {
        return new TraceAnnotationVisitor(visitor, new Textifier(589824){

            @Override
            public void visitAnnotationEnd() {
                this.print(printWriter);
                printWriter.flush();
            }
        });
    }

    public static final class DebugType {
        public static final int METHOD = 1;
        public static final int FIELD = 2;
        public static final int ANNOTATION = 4;
    }

    private static final class DebugClassVisitor
    extends ClassVisitor {
        private final int debugTypes;
        private final PrintWriter printWriter;

        DebugClassVisitor(@NotNull ClassWriter cw, int debugTypes, PrintWriter printWriter) {
            super(589824, cw);
            this.debugTypes = debugTypes;
            this.printWriter = printWriter;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AnnotationVisitor av = super.visitAnnotation(desc, visible);
            if ((this.debugTypes & 4) > 0) {
                return ASMDebugging.getDebugAnnotationVisitor(av, this.printWriter);
            }
            return av;
        }

        @Override
        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            FieldVisitor fv = super.visitField(access, name, desc, signature, value);
            if ((this.debugTypes & 2) > 0) {
                return ASMDebugging.getDebugFieldVisitor(fv, this.printWriter);
            }
            return fv;
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            if ((this.debugTypes & 1) > 0) {
                return ASMDebugging.getDebugMethodVisitor(mv, this.printWriter);
            }
            return mv;
        }
    }
}

