/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.semver4j;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import nl.pim16aap2.bigDoors.semver4j.Range;
import nl.pim16aap2.bigDoors.semver4j.Semver;
import org.jetbrains.annotations.NotNull;

public class RangesList {
    @NotNull
    private static final String OR_JOINER = " or ";
    @NotNull
    private static final String AND_JOINER = " and ";
    @NotNull
    private final @NotNull List<@NotNull List<@NotNull Range>> rangesList = new ArrayList<List<Range>>();

    @NotNull
    public RangesList add(@NotNull @NotNull List<@NotNull Range> ranges) {
        if (!ranges.isEmpty()) {
            this.rangesList.add(ranges);
        }
        return this;
    }

    @NotNull
    public @NotNull List<@NotNull List<@NotNull Range>> get() {
        return this.rangesList;
    }

    public boolean isSatisfiedByAny() {
        return this.rangesList.stream().flatMap(Collection::stream).allMatch(Range::isSatisfiedByAny);
    }

    public boolean isSatisfiedBy(@NotNull Semver version) {
        return this.rangesList.stream().anyMatch(ranges -> RangesList.isSingleSetOfRangesIsSatisfied(ranges, version));
    }

    @NotNull
    public String toString() {
        return this.rangesList.stream().map(RangesList::formatRanges).collect(Collectors.joining(OR_JOINER)).replaceAll("^\\(([^()]+)\\)$", "$1");
    }

    @NotNull
    private static String formatRanges(@NotNull @NotNull List<@NotNull Range> ranges) {
        String representation = ranges.stream().map(Range::toString).collect(Collectors.joining(AND_JOINER));
        if (ranges.size() < 2) {
            return representation;
        }
        return String.format(Locale.ROOT, "(%s)", representation);
    }

    private static boolean isSingleSetOfRangesIsSatisfied(@NotNull @NotNull List<@NotNull Range> ranges, @NotNull Semver version) {
        for (Range range : ranges) {
            if (range.isSatisfiedBy(version)) continue;
            return false;
        }
        if (!version.getPreRelease().isEmpty()) {
            for (Range range : ranges) {
                Semver rangeSemver = range.getRangeVersion();
                List<String> preRelease = rangeSemver.getPreRelease();
                if (preRelease.size() <= 0 || version.getMajor() != rangeSemver.getMajor() || version.getMinor() != rangeSemver.getMinor() || version.getPatch() != rangeSemver.getPatch()) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

