/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.semver4j;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.pim16aap2.bigDoors.semver4j.Range;
import nl.pim16aap2.bigDoors.semver4j.RangesList;
import nl.pim16aap2.bigDoors.semver4j.internal.Tokenizers;
import nl.pim16aap2.bigDoors.semver4j.internal.range.RangeProcessorPipeline;
import nl.pim16aap2.bigDoors.semver4j.internal.range.processor.CaretProcessor;
import nl.pim16aap2.bigDoors.semver4j.internal.range.processor.GreaterThanOrEqualZeroProcessor;
import nl.pim16aap2.bigDoors.semver4j.internal.range.processor.HyphenProcessor;
import nl.pim16aap2.bigDoors.semver4j.internal.range.processor.IvyProcessor;
import nl.pim16aap2.bigDoors.semver4j.internal.range.processor.TildeProcessor;
import nl.pim16aap2.bigDoors.semver4j.internal.range.processor.XRangeProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RangesString {
    @NotNull
    private static final Pattern splitterPattern = Pattern.compile("(\\s*)([<>]?=?)\\s*");
    @NotNull
    private static final Pattern comparatorPattern = Pattern.compile(Tokenizers.COMPARATOR);

    RangesString() {
    }

    @NotNull
    RangesList get(@NotNull String range) {
        String[] rangeSections;
        RangesList rangesList = new RangesList();
        range = range.trim();
        for (String rangeSection : rangeSections = range.split("\\|\\|")) {
            rangeSection = RangesString.stripWhitespacesBetweenRangeOperator(rangeSection);
            rangeSection = RangesString.applyProcessors(rangeSection);
            List<Range> ranges = RangesString.addRanges(rangeSection);
            rangesList.add(ranges);
        }
        return rangesList;
    }

    @NotNull
    private static String stripWhitespacesBetweenRangeOperator(@NotNull String rangeSection) {
        Matcher matcher = splitterPattern.matcher(rangeSection);
        return matcher.replaceAll("$1$2").trim();
    }

    @Nullable
    private static String applyProcessors(@Nullable String range) {
        return RangeProcessorPipeline.startWith(new GreaterThanOrEqualZeroProcessor()).addProcessor(new IvyProcessor()).addProcessor(new HyphenProcessor()).addProcessor(new CaretProcessor()).addProcessor(new TildeProcessor()).addProcessor(new XRangeProcessor()).process(range);
    }

    @NotNull
    private static @NotNull List<@NotNull Range> addRanges(@NotNull String range) {
        String[] parsedRanges;
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (String parsedRange : parsedRanges = range.split("\\s+")) {
            Matcher matcher = comparatorPattern.matcher(parsedRange);
            if (!matcher.matches()) continue;
            String rangeOperator = matcher.group(1);
            String version = matcher.group(2);
            ranges.add(new Range(version, Range.RangeOperator.value(rangeOperator)));
        }
        return ranges;
    }
}

