/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.semver4j.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import nl.pim16aap2.bigDoors.semver4j.Semver;
import org.jetbrains.annotations.NotNull;

public class Modifier {
    private static final String FULL_FORMAT = "%d.%d.%d";
    private static final String MAJOR_FORMAT = "%d.0.0";
    private static final String MAJOR_MINOR_FORMAT = "%d.%d.0";

    private Modifier() {
    }

    @NotNull
    public static Semver nextMajor(@NotNull Semver version) {
        int nextMajor = version.getMajor();
        if (version.getMinor() != 0 || version.getPatch() != 0 || version.getPreRelease().isEmpty()) {
            ++nextMajor;
        }
        String newVersion = Modifier.createFullVersion(version, String.format(Locale.ROOT, MAJOR_FORMAT, nextMajor), Collections.emptyList());
        return new Semver(newVersion);
    }

    @NotNull
    public static Semver withIncMajor(@NotNull Semver version, int number) {
        String newVersion = Modifier.createFullVersion(version, String.format(Locale.ROOT, FULL_FORMAT, version.getMajor() + number, version.getMinor(), version.getPatch()), version.getPreRelease());
        return new Semver(newVersion);
    }

    @NotNull
    public static Semver nextMinor(@NotNull Semver version) {
        int nextMinor = version.getMinor();
        if (version.getPatch() != 0 || version.getPreRelease().isEmpty()) {
            ++nextMinor;
        }
        String newVersion = Modifier.createFullVersion(version, String.format(Locale.ROOT, MAJOR_MINOR_FORMAT, version.getMajor(), nextMinor), Collections.emptyList());
        return new Semver(newVersion);
    }

    @NotNull
    public static Semver withIncMinor(@NotNull Semver version, int number) {
        String newVersion = Modifier.createFullVersion(version, String.format(Locale.ROOT, FULL_FORMAT, version.getMajor(), version.getMinor() + number, version.getPatch()), version.getPreRelease());
        return new Semver(newVersion);
    }

    @NotNull
    public static Semver nextPatch(@NotNull Semver version) {
        int newPatch = version.getPatch();
        if (version.getPreRelease().isEmpty()) {
            ++newPatch;
        }
        String newVersion = Modifier.createFullVersion(version, String.format(Locale.ROOT, FULL_FORMAT, version.getMajor(), version.getMinor(), newPatch), Collections.emptyList());
        return new Semver(newVersion);
    }

    @NotNull
    public static Semver withIncPatch(@NotNull Semver version, int number) {
        String newVersion = Modifier.createFullVersion(version, String.format(Locale.ROOT, FULL_FORMAT, version.getMajor(), version.getMinor(), version.getPatch() + number), version.getPreRelease());
        return new Semver(newVersion);
    }

    @NotNull
    public static Semver withPreRelease(@NotNull Semver version, @NotNull String preRelease) {
        List<String> newPreRelease = Arrays.asList(preRelease.split("\\."));
        String newVersion = Modifier.createFullVersion(version, String.format(Locale.ROOT, FULL_FORMAT, version.getMajor(), version.getMinor(), version.getPatch()), newPreRelease);
        return new Semver(newVersion);
    }

    @NotNull
    public static Semver withBuild(@NotNull Semver version, @NotNull String build) {
        List<String> newBuild = Arrays.asList(build.split("\\."));
        String newVersion = Modifier.createFullVersion(String.format(Locale.ROOT, FULL_FORMAT, version.getMajor(), version.getMinor(), version.getPatch()), version.getPreRelease(), newBuild);
        return new Semver(newVersion);
    }

    @NotNull
    public static Semver withClearedPreRelease(@NotNull Semver version) {
        String newVersion = Modifier.createFullVersion(version, String.format(Locale.ROOT, FULL_FORMAT, version.getMajor(), version.getMinor(), version.getPatch()), Collections.emptyList());
        return new Semver(newVersion);
    }

    @NotNull
    public static Semver withClearedBuild(@NotNull Semver version) {
        String newVersion = Modifier.createFullVersion(String.format(Locale.ROOT, FULL_FORMAT, version.getMajor(), version.getMinor(), version.getPatch()), version.getPreRelease(), Collections.emptyList());
        return new Semver(newVersion);
    }

    @NotNull
    public static Semver withClearedPreReleaseAndBuild(@NotNull Semver version) {
        String newVersion = String.format(Locale.ROOT, FULL_FORMAT, version.getMajor(), version.getMinor(), version.getPatch());
        return new Semver(newVersion);
    }

    @NotNull
    private static String createFullVersion(@NotNull Semver version, @NotNull String main, @NotNull @NotNull List<@NotNull String> preRelease) {
        return Modifier.createFullVersion(main, preRelease, version.getBuild());
    }

    @NotNull
    private static String createFullVersion(@NotNull String main, @NotNull @NotNull List<@NotNull String> preRelease, @NotNull @NotNull List<@NotNull String> build) {
        StringBuilder stringBuilder = new StringBuilder(main);
        if (!preRelease.isEmpty()) {
            stringBuilder.append("-");
            for (String s : preRelease) {
                stringBuilder.append(s).append(".");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        if (!build.isEmpty()) {
            stringBuilder.append("+");
            for (String s : build) {
                stringBuilder.append(s).append(".");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }
}

