/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.toolUsers;

import java.util.Arrays;
import java.util.logging.Level;
import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.Door;
import nl.pim16aap2.bigDoors.toolUsers.ToolVerifier;
import nl.pim16aap2.bigDoors.util.Abortable;
import nl.pim16aap2.bigDoors.util.DoorDirection;
import nl.pim16aap2.bigDoors.util.DoorType;
import nl.pim16aap2.bigDoors.util.Messages;
import nl.pim16aap2.bigDoors.util.RotateDirection;
import nl.pim16aap2.bigDoors.util.Util;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public abstract class ToolUser
extends Abortable {
    protected DoorType type;
    protected String name;
    protected final BigDoors plugin;
    protected Player player;
    protected long doorUID;
    protected final Messages messages;
    protected DoorDirection engineSide;
    protected boolean done = false;
    protected boolean isOpen = false;
    protected Location one;
    protected Location two;
    protected Location engine;
    protected boolean aborting = false;
    protected RotateDirection openDir = null;
    private boolean hasStick = false;

    public ToolUser(BigDoors plugin, Player player, String name, DoorType type) {
        this.plugin = plugin;
        this.messages = plugin.getMessages();
        this.player = player;
        this.name = name;
        this.one = null;
        this.two = null;
        this.engine = null;
        this.engineSide = null;
        this.type = type;
        plugin.addToolUser(this);
    }

    public abstract void selector(Location var1);

    protected abstract void triggerGiveTool();

    protected abstract void triggerFinishUp();

    protected abstract boolean isReadyToCreateDoor();

    private void finishUp(String message, World world, Location min, Location max, @Nullable String canBreakBlock) {
        Location engine = new Location(world, (double)this.engine.getBlockX(), (double)this.engine.getBlockY(), (double)this.engine.getBlockZ());
        Location powerB = new Location(world, (double)this.engine.getBlockX(), (double)(this.engine.getBlockY() - 1), (double)this.engine.getBlockZ());
        if (canBreakBlock != null) {
            Util.messagePlayer(this.player, this.messages.getString("CREATOR.GENERAL.NoPermissionHere") + " " + canBreakBlock);
            this.abort(false);
            return;
        }
        Door door = new Door(this.player.getUniqueId(), this.player.getName(), this.player.getUniqueId(), world, min, max, engine, this.name, this.isOpen, -1L, false, 0, this.type, this.engineSide, powerB, this.openDir, -1, false, false);
        int doorSize = door.getBlockCount();
        int sizeLimit = Util.minPositive(Util.getMaxDoorSizeForPlayer(this.player), this.plugin.getConfigLoader().maxDoorSize());
        if (sizeLimit >= 0 && sizeLimit <= doorSize) {
            Util.messagePlayer(this.player, this.messages.getString("CREATOR.GENERAL.TooManyBlocks") + " " + sizeLimit);
        } else if (this.plugin.getVaultManager().buyDoor(this.player, this.type, doorSize)) {
            this.plugin.getCommander().addDoor(door);
            if (message != null) {
                Util.messagePlayer(this.player, message);
            }
        }
        this.takeToolFromPlayer();
        this.abort();
    }

    protected final void finishUp(String message) {
        if (this.isReadyToCreateDoor() && !this.aborting) {
            World world = this.one.getWorld();
            Location min = new Location(world, (double)this.one.getBlockX(), (double)this.one.getBlockY(), (double)this.one.getBlockZ());
            Location max = new Location(world, (double)this.two.getBlockX(), (double)this.two.getBlockY(), (double)this.two.getBlockZ());
            this.plugin.canBreakBlocksBetweenLocs(this.player.getUniqueId(), this.player.getName(), world, min, max).thenApply(canBreakBlock -> BigDoors.getScheduler().runTask((Plugin)this.plugin, () -> this.finishUp(message, world, min, max, (String)canBreakBlock)));
        } else {
            this.takeToolFromPlayer();
            this.abort();
        }
    }

    protected final void giveToolToPlayer(String[] lore, String[] message) {
        if (this.hasStick) {
            return;
        }
        this.hasStick = true;
        ItemStack tool = new ItemStack(Material.STICK, 1);
        tool.addUnsafeEnchantment(ToolVerifier.TOOL_ENCHANTMENT, 1);
        tool.getItemMeta().addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        ItemMeta itemMeta = tool.getItemMeta();
        itemMeta.setDisplayName(this.messages.getString("CREATOR.GENERAL.StickName"));
        itemMeta.setLore(Arrays.asList(lore));
        tool.setItemMeta(itemMeta);
        int heldSlot = this.player.getInventory().getHeldItemSlot();
        if (this.player.getInventory().getItem(heldSlot) == null) {
            this.player.getInventory().setItem(heldSlot, tool);
        } else {
            this.player.getInventory().addItem(new ItemStack[]{tool});
        }
        Util.messagePlayer(this.player, message);
    }

    public final Player getPlayer() {
        return this.player;
    }

    public final void setName(String newName) {
        this.name = newName;
        this.triggerGiveTool();
    }

    public final String getName() {
        return this.name;
    }

    public final void takeToolFromPlayer() {
        this.player.getInventory().forEach(K -> {
            if (this.plugin.getTF().isTool((ItemStack)K)) {
                K.setAmount(0);
            }
        });
    }

    protected final void minMaxFix() {
        int minX = this.one.getBlockX();
        int minY = this.one.getBlockY();
        int minZ = this.one.getBlockZ();
        int maxX = this.two.getBlockX();
        int maxY = this.two.getBlockY();
        int maxZ = this.two.getBlockZ();
        this.one.setX(minX > maxX ? (double)maxX : (double)minX);
        this.one.setY(minY > maxY ? (double)maxY : (double)minY);
        this.one.setZ(minZ > maxZ ? (double)maxZ : (double)minZ);
        this.two.setX(minX < maxX ? (double)maxX : (double)minX);
        this.two.setY(minY < maxY ? (double)maxY : (double)minY);
        this.two.setZ(minZ < maxZ ? (double)maxZ : (double)minZ);
    }

    public final boolean isDone() {
        return this.done;
    }

    public final void setIsDone(boolean bool) {
        this.done = bool;
        if (bool) {
            this.triggerFinishUp();
        }
    }

    @Override
    public final void abort(boolean onDisable) {
        this.aborting = true;
        this.takeToolFromPlayer();
        if (onDisable) {
            return;
        }
        this.cancelTask();
        this.plugin.removeToolUser(this);
        if (!this.done) {
            this.plugin.getMyLogger().returnToSender((CommandSender)this.player, Level.INFO, ChatColor.RED, this.messages.getString("CREATOR.GENERAL.TimeUp"));
        }
    }

    @Override
    public final void abort() {
        this.abort(false);
    }

    public final void abortSilently() {
        this.setIsDone(true);
        this.abort();
    }
}

