/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.pim16aap2.bigDoors.util.Vector3D;
import org.bukkit.block.BlockFace;

public enum MyBlockFace {
    NORTH(0, new Vector3D(0, 0, -1), BlockFace.NORTH),
    EAST(1, new Vector3D(1, 0, 0), BlockFace.EAST),
    SOUTH(2, new Vector3D(0, 0, 1), BlockFace.SOUTH),
    WEST(3, new Vector3D(-1, 0, 0), BlockFace.WEST),
    UP(4, new Vector3D(0, 1, 0), BlockFace.UP),
    DOWN(5, new Vector3D(0, -1, 0), BlockFace.DOWN);

    private final BlockFace bukkitFace;
    private final Vector3D dir;
    private final int val;
    private static Map<BlockFace, MyBlockFace> map;
    private static Map<Vector3D, MyBlockFace> dirs;
    private static Map<Integer, MyBlockFace> vals;
    private static final List<MyBlockFace> VALUES;

    private MyBlockFace(int val, Vector3D dir, BlockFace bukkitFace) {
        this.val = val;
        this.bukkitFace = bukkitFace;
        this.dir = dir;
    }

    public static int getValue(MyBlockFace dir) {
        return dir.val;
    }

    public static MyBlockFace valueOf(int val) {
        return vals.get(val);
    }

    public static BlockFace getBukkitFace(MyBlockFace myFace) {
        return myFace.bukkitFace;
    }

    public static MyBlockFace getMyBlockFace(BlockFace bukkitFace) {
        return map.get(bukkitFace);
    }

    public static Vector3D getDirection(MyBlockFace myFace) {
        return myFace.dir;
    }

    public static MyBlockFace rotateClockwise(MyBlockFace myFace) {
        switch (myFace.ordinal()) {
            case 0: {
                return EAST;
            }
            case 1: {
                return SOUTH;
            }
            case 2: {
                return WEST;
            }
            case 3: {
                return NORTH;
            }
        }
        return myFace;
    }

    public static MyBlockFace rotateCounterClockwise(MyBlockFace myFace) {
        switch (myFace.ordinal()) {
            case 0: {
                return WEST;
            }
            case 1: {
                return NORTH;
            }
            case 2: {
                return EAST;
            }
            case 3: {
                return SOUTH;
            }
        }
        return myFace;
    }

    public static MyBlockFace rotateVerticallyNorth(MyBlockFace curFace) {
        switch (curFace.ordinal()) {
            case 1: 
            case 3: {
                return curFace;
            }
            case 5: {
                return SOUTH;
            }
            case 0: {
                return DOWN;
            }
            case 2: {
                return UP;
            }
            case 4: {
                return NORTH;
            }
        }
        return null;
    }

    public static MyBlockFace rotateVerticallySouth(MyBlockFace curFace) {
        switch (curFace.ordinal()) {
            case 1: 
            case 3: {
                return curFace;
            }
            case 5: {
                return NORTH;
            }
            case 0: {
                return UP;
            }
            case 2: {
                return DOWN;
            }
            case 4: {
                return SOUTH;
            }
        }
        return null;
    }

    public static MyBlockFace rotateVerticallyEast(MyBlockFace curFace) {
        switch (curFace.ordinal()) {
            case 0: 
            case 2: {
                return curFace;
            }
            case 5: {
                return WEST;
            }
            case 1: {
                return DOWN;
            }
            case 3: {
                return UP;
            }
            case 4: {
                return EAST;
            }
        }
        return null;
    }

    public static MyBlockFace rotateVerticallyWest(MyBlockFace curFace) {
        switch (curFace.ordinal()) {
            case 0: 
            case 2: {
                return curFace;
            }
            case 5: {
                return EAST;
            }
            case 1: {
                return UP;
            }
            case 3: {
                return DOWN;
            }
            case 4: {
                return WEST;
            }
        }
        return null;
    }

    public static MyBlockFace faceFromDir(Vector3D dir) {
        return dirs.get(dir);
    }

    public static List<MyBlockFace> getValues() {
        return VALUES;
    }

    static {
        map = new HashMap<BlockFace, MyBlockFace>();
        dirs = new HashMap<Vector3D, MyBlockFace>();
        vals = new HashMap<Integer, MyBlockFace>();
        VALUES = Collections.unmodifiableList(Arrays.asList(MyBlockFace.values()));
        for (MyBlockFace face : MyBlockFace.values()) {
            map.put(face.bukkitFace, face);
            dirs.put(face.dir, face);
            vals.put(face.val, face);
        }
    }
}

