/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.waitForCommand;

import java.util.UUID;
import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.Door;
import nl.pim16aap2.bigDoors.util.DoorAttribute;
import nl.pim16aap2.bigDoors.util.Util;
import nl.pim16aap2.bigDoors.waitForCommand.WaitForCommand;
import org.bukkit.entity.Player;

public class WaitForAddOwner
extends WaitForCommand {
    private long doorUID;

    public WaitForAddOwner(BigDoors plugin, Player player, long doorUID) {
        super(plugin);
        this.player = player;
        this.command = "addowner";
        this.doorUID = doorUID;
        Util.messagePlayer(player, plugin.getMessages().getString("COMMAND.AddOwner.Init"));
        plugin.addCommandWaiter(this);
    }

    @Override
    public boolean executeCommand(String[] args) {
        if (!this.plugin.getCommander().hasPermissionForAction(this.player, this.doorUID, DoorAttribute.ADDOWNER)) {
            return true;
        }
        if (args.length >= 2) {
            UUID playerUUID = this.plugin.getCommander().playerUUIDFromName(args[1]);
            Door door = this.plugin.getCommander().getDoor(this.player.getUniqueId(), this.doorUID);
            int permission = 1;
            try {
                if (args.length == 3) {
                    permission = Integer.parseInt(args[2]);
                }
            }
            catch (Exception e) {
                Util.messagePlayer(this.player, this.plugin.getMessages().getString("GENERAL.InvalidInput.Integer"));
            }
            if (playerUUID != null) {
                if (this.plugin.getCommander().addOwner(playerUUID, door, permission)) {
                    Util.messagePlayer(this.player, this.plugin.getMessages().getString("COMMAND.AddOwner.Success"));
                    this.isFinished = true;
                    this.abort();
                    return true;
                }
                Util.messagePlayer(this.player, this.plugin.getMessages().getString("COMMAND.AddOwner.Fail"));
                this.abort();
                return true;
            }
            Util.messagePlayer(this.player, this.plugin.getMessages().getString("GENERAL.PlayerNotFound") + ": \"" + args[1] + "\"");
            this.abort();
            return true;
        }
        this.abort();
        return false;
    }
}

