/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.waitForCommand;

import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.util.DoorAttribute;
import nl.pim16aap2.bigDoors.util.Util;
import nl.pim16aap2.bigDoors.waitForCommand.WaitForCommand;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class WaitForSetBlocksToMove
extends WaitForCommand {
    private long doorUID;

    public WaitForSetBlocksToMove(BigDoors plugin, Player player, long doorUID) {
        super(plugin);
        this.player = player;
        this.command = "setblockstomove";
        this.doorUID = doorUID;
        Util.messagePlayer(player, plugin.getMessages().getString("COMMAND.SetBlocksToMove.Init"));
        plugin.addCommandWaiter(this);
    }

    @Override
    public boolean executeCommand(String[] args) {
        if (!this.plugin.getCommander().hasPermissionForAction(this.player, this.doorUID, DoorAttribute.BLOCKSTOMOVE)) {
            return true;
        }
        if (args.length == 1) {
            try {
                int blocksToMove = Integer.parseInt(args[0]);
                if (blocksToMove > BigDoors.get().getConfigLoader().getMaxBlocksToMove()) {
                    this.player.sendMessage(ChatColor.RED + BigDoors.get().getMessages().getString("GENERAL.InvalidBlocksToMoveRange"));
                    return true;
                }
                this.plugin.getCommandHandler().setDoorBlocksToMove(this.player, this.doorUID, blocksToMove);
                this.plugin.removeCommandWaiter(this);
                if (blocksToMove > 0) {
                    Util.messagePlayer(this.player, this.plugin.getMessages().getString("COMMAND.SetBlocksToMove.Success") + blocksToMove);
                } else {
                    Util.messagePlayer(this.player, this.plugin.getMessages().getString("COMMAND.SetBlocksToMove.Disabled"));
                }
                this.isFinished = true;
                this.abort();
                return true;
            }
            catch (Exception e) {
                Util.messagePlayer(this.player, this.plugin.getMessages().getString("GENERAL.InvalidInput.Integer"));
            }
        }
        this.abort();
        return false;
    }
}

