/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.waitForCommand;

import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.util.DoorAttribute;
import nl.pim16aap2.bigDoors.util.Util;
import nl.pim16aap2.bigDoors.waitForCommand.WaitForCommand;
import org.bukkit.entity.Player;

public class WaitForSetTime
extends WaitForCommand {
    private final long doorUID;

    public WaitForSetTime(BigDoors plugin, Player player, long doorUID) {
        super(plugin);
        this.player = player;
        this.command = "setautoclosetime";
        this.doorUID = doorUID;
        Util.messagePlayer(player, plugin.getMessages().getString("COMMAND.SetTime.Init"));
        plugin.addCommandWaiter(this);
    }

    @Override
    public boolean executeCommand(String[] args) {
        if (!this.plugin.getCommander().hasPermissionForAction(this.player, this.doorUID, DoorAttribute.CHANGETIMER)) {
            return true;
        }
        if (args.length == 1) {
            try {
                int time = Integer.parseInt(args[0]);
                int timeLimit = this.plugin.getConfigLoader().maxAutoCloseTimer();
                if (timeLimit >= 0 && time > timeLimit) {
                    Util.messagePlayer(this.player, this.plugin.getMessages().getString("GENERAL.AutoCloseTimerTooBig"));
                    return true;
                }
                this.plugin.getCommandHandler().setDoorOpenTime(this.player, this.doorUID, time);
                this.plugin.removeCommandWaiter(this);
                if (time != -1) {
                    Util.messagePlayer(this.player, this.plugin.getMessages().getString("COMMAND.SetTime.Success") + time + "s.");
                } else {
                    Util.messagePlayer(this.player, this.plugin.getMessages().getString("COMMAND.SetTime.Disabled"));
                }
                this.isFinished = true;
                this.abort();
                return true;
            }
            catch (Exception e) {
                Util.messagePlayer(this.player, this.plugin.getMessages().getString("GENERAL.InvalidInput.Integer"));
            }
        }
        this.abort();
        return false;
    }
}

