/*
 * Decompiled with CFR 0.152.
 */
package com.floweytf.tfcsupportindicator;

import net.dries007.tfc.common.recipes.CollapseRecipe;
import net.dries007.tfc.util.data.Support;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.util.Lazy;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public enum CollapseComponentProvider implements IBlockComponentProvider
{
    INSTANCE;

    private static final ResourceLocation COLLAPSE_INDICATOR;
    private static final Lazy<TagKey<Block>> CAN_START_COLLAPSE;
    private static final Component SELF_SUPPORTED;
    private static final Component SELF_UNSUPPORTED;
    private static final Component WONT_TRIGGER_COLLAPSE;
    private static final Component MIGHT_TRIGGER_COLLAPSE;

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (!accessor.getBlockState().is((TagKey)CAN_START_COLLAPSE.get())) {
            return;
        }
        Level level = accessor.getLevel();
        BlockPos pos = accessor.getPosition();
        boolean isSupported = Support.isSupported((BlockGetter)level, (BlockPos)accessor.getPosition());
        boolean mightTriggerCollapse = Support.findUnsupportedPositions((BlockGetter)level, (BlockPos)pos.offset(-4, -2, -4), (BlockPos)pos.offset(4, 2, 4)).stream().anyMatch(u -> CollapseRecipe.canStartCollapse((LevelAccessor)level, (BlockPos)u));
        tooltip.add(isSupported ? SELF_SUPPORTED : SELF_UNSUPPORTED);
        tooltip.add(mightTriggerCollapse ? MIGHT_TRIGGER_COLLAPSE : WONT_TRIGGER_COLLAPSE);
    }

    public ResourceLocation getUid() {
        return COLLAPSE_INDICATOR;
    }

    static {
        COLLAPSE_INDICATOR = ResourceLocation.parse((String)"tfc_support_indicator:support_indicator");
        CAN_START_COLLAPSE = Lazy.of(() -> TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tfc", (String)"can_start_collapse")));
        SELF_SUPPORTED = Component.translatable((String)"tfc_support_indicator.self_supported").withStyle(ChatFormatting.DARK_GREEN);
        SELF_UNSUPPORTED = Component.translatable((String)"tfc_support_indicator.self_unsupported").withStyle(ChatFormatting.GOLD);
        WONT_TRIGGER_COLLAPSE = Component.translatable((String)"tfc_support_indicator.wont_trigger_collapse").withStyle(ChatFormatting.DARK_GREEN);
        MIGHT_TRIGGER_COLLAPSE = Component.translatable((String)"tfc_support_indicator.might_trigger_collapse").withStyle(ChatFormatting.RED);
    }
}

