/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.mixin;

import java.util.Collection;
import java.util.OptionalInt;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.other.WatcherManager;
import net.mat0u5.lifeseries.seasons.season.Season;
import net.mat0u5.lifeseries.seasons.season.doublelife.DoubleLife;
import net.mat0u5.lifeseries.utils.interfaces.IServerPlayer;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3222.class}, priority=1)
public class ServerPlayerMixin
implements IServerPlayer {
    @Unique
    private boolean ls$processing = false;

    @Inject(method={"method_17355(Lnet/minecraft/class_3908;)Ljava/util/OptionalInt;"}, at={@At(value="HEAD")})
    private void onInventoryOpen(@Nullable class_3908 factory, CallbackInfoReturnable<OptionalInt> cir) {
        if (!Main.isLogicalSide() || Main.modDisabled()) {
            return;
        }
        class_3222 player = this.ls$get();
        if (Main.blacklist == null) {
            return;
        }
        TaskScheduler.scheduleTask(1, () -> {
            player.field_7512.method_7602().forEach(itemStack -> Main.blacklist.processItemStack(player, (class_1799)itemStack));
            PlayerUtils.updatePlayerInventory(player);
        });
    }

    @Inject(method={"method_7324(Lnet/minecraft/class_1297;)V"}, at={@At(value="HEAD")})
    private void onAttackEntity(class_1297 target, CallbackInfo ci) {
        if (Main.modDisabled()) {
            return;
        }
        class_3222 player = this.ls$get();
        Main.currentSeason.onUpdatedInventory(player);
    }

    @Inject(method={"method_6020(Lnet/minecraft/class_1293;Lnet/minecraft/class_1297;)V"}, at={@At(value="TAIL")})
    private void onStatusEffectApplied(class_1293 effect, class_1297 source, CallbackInfo ci) {
        this.ls$onUpdatedEffects(effect, true);
    }

    @Inject(method={"method_6129(Ljava/util/Collection;)V"}, at={@At(value="TAIL")})
    private void onStatusEffectRemoved(Collection<class_1293> effects, CallbackInfo ci) {
        for (class_1293 effect : effects) {
            this.ls$onUpdatedEffects(effect, false);
        }
    }

    @Inject(method={"method_6009(Lnet/minecraft/class_1293;ZLnet/minecraft/class_1297;)V"}, at={@At(value="TAIL")})
    private void onStatusEffectUpgraded(class_1293 effect, boolean reapplyEffect, class_1297 source, CallbackInfo ci) {
        this.ls$onUpdatedEffects(effect, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unique
    private void ls$onUpdatedEffects(class_1293 effect, boolean add) {
        if (this.ls$processing || Main.modDisabled()) {
            return;
        }
        class_3222 player = this.ls$get();
        this.ls$processing = true;
        try {
            Season season = Main.currentSeason;
            if (season instanceof DoubleLife) {
                DoubleLife doubleLife = (DoubleLife)season;
                doubleLife.syncStatusEffectsFrom(player, effect, add);
            }
        }
        finally {
            this.ls$processing = false;
        }
    }

    @Unique
    private class_3222 ls$get() {
        return (class_3222)this;
    }

    @Override
    @Unique
    @Nullable
    public Integer ls$getLives() {
        return Main.livesManager.getPlayerLives(this.ls$get());
    }

    @Override
    @Unique
    public boolean ls$hasAssignedLives() {
        return Main.livesManager.hasAssignedLives(this.ls$get());
    }

    @Override
    @Unique
    public boolean ls$isAlive() {
        return Main.livesManager.isAlive(this.ls$get());
    }

    @Override
    @Unique
    public boolean ls$isDead() {
        return Main.livesManager.isDead(this.ls$get());
    }

    @Override
    @Unique
    public void ls$addLives(int amount) {
        Main.livesManager.addToPlayerLives(this.ls$get(), amount);
    }

    @Override
    @Unique
    public void ls$addLife() {
        Main.livesManager.addPlayerLife(this.ls$get());
    }

    @Override
    @Unique
    public void ls$removeLife() {
        Main.livesManager.removePlayerLife(this.ls$get());
    }

    @Override
    @Unique
    public void ls$setLives(int lives) {
        Main.livesManager.setPlayerLives(this.ls$get(), lives);
    }

    @Override
    @Unique
    public boolean ls$isOnLastLife(boolean fallback) {
        return Main.livesManager.isOnLastLife(this.ls$get(), fallback);
    }

    @Override
    @Unique
    public boolean ls$isOnSpecificLives(int check, boolean fallback) {
        return Main.livesManager.isOnSpecificLives(this.ls$get(), check, fallback);
    }

    @Override
    @Unique
    public boolean ls$isOnAtLeastLives(int check, boolean fallback) {
        return Main.livesManager.isOnAtLeastLives(this.ls$get(), check, fallback);
    }

    @Override
    @Unique
    public boolean ls$isWatcher() {
        return WatcherManager.isWatcher((class_1657)this.ls$get());
    }

    @Override
    @Unique
    public void ls$hurt(class_1282 source, float amount) {
        this.ls$get().method_64397(this.ls$getServerLevel(), source, amount);
    }

    @Override
    @Unique
    public void ls$hurt(class_3218 level, class_1282 source, float amount) {
        this.ls$get().method_64397(level, source, amount);
    }

    @Override
    @Unique
    public class_3218 ls$getServerLevel() {
        return this.ls$get().method_51469();
    }
}

