/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.subin;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Optional;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.command.manager.Command;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.subin.SubInManager;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_11560;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class SubInCommands
extends Command {
    @Override
    public boolean isAllowed() {
        return Main.currentSeason.getSeason() != Seasons.UNASSIGNED;
    }

    @Override
    public class_2561 getBannedText() {
        return class_2561.method_30163((String)"This command is only available when you have selected a Season.");
    }

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)SubInCommands.literal("subin").requires(PermissionManager::isAdmin)).then(SubInCommands.literal("add").then(SubInCommands.argument("player", class_2186.method_9305()).then(SubInCommands.argument("subin", StringArgumentType.string()).executes(context -> this.addSubIn((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"subin"))))))).then(SubInCommands.literal("remove").then(SubInCommands.argument("player", class_2186.method_9305()).executes(context -> this.removeSubIn((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player")))))).then(SubInCommands.literal("list").executes(context -> this.listSubIns((class_2168)context.getSource()))));
    }

    public int addSubIn(class_2168 source, class_3222 player, String target) {
        GameProfile profile;
        Optional opt;
        if (this.checkBanned(source)) {
            return -1;
        }
        GameProfile targetProfile = null;
        if (source.method_9211().method_73550().comp_4407() != null && (opt = source.method_9211().method_73550().comp_4407().method_14515(target)).isPresent()) {
            class_11560 playerConfigEntry = (class_11560)opt.get();
            targetProfile = new GameProfile(playerConfigEntry.comp_4422(), playerConfigEntry.comp_4423());
        }
        if (targetProfile == null) {
            source.method_9213(class_2561.method_30163((String)"Failed to fetch target profile"));
            source.method_9213(class_2561.method_30163((String)"Make sure the target player has logged on the server at least once"));
            return -1;
        }
        class_3222 targetPlayer = PlayerUtils.getPlayer(target);
        if (targetPlayer != null) {
            source.method_9213(class_2561.method_30163((String)"Online players cannot be subbed in for"));
            return -1;
        }
        if (SubInManager.isSubbingIn(player.method_5667())) {
            profile = SubInManager.getSubstitutedPlayer(player.method_5667());
            source.method_9213((class_2561)TextUtils.formatPlain("{} is already subbing in for {}", player, OtherUtils.profileName(profile)));
            return -1;
        }
        if (SubInManager.isBeingSubstituted(OtherUtils.profileId(targetProfile))) {
            profile = SubInManager.getSubstitutingPlayer(OtherUtils.profileId(targetProfile));
            source.method_9213((class_2561)TextUtils.formatPlain("{} is already being subbed in for by {}", target, OtherUtils.profileName(profile)));
            return -1;
        }
        OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("{} is now subbing in for {}", player, target));
        SubInManager.addSubIn(player, targetProfile);
        return 1;
    }

    public int removeSubIn(class_2168 source, class_3222 player) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (!SubInManager.isSubbingIn(player.method_5667())) {
            source.method_9213((class_2561)TextUtils.formatPlain("{} is not subbing in for anyone", player));
            return -1;
        }
        GameProfile profile = SubInManager.getSubstitutedPlayer(player.method_5667());
        OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("{} is no longer subbing in for {}", player, OtherUtils.profileName(profile)));
        SubInManager.removeSubIn(player);
        return 1;
    }

    public int listSubIns(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (SubInManager.subIns.isEmpty()) {
            source.method_9213(class_2561.method_30163((String)"There are no sub ins yet"));
            return -1;
        }
        OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"\u00a77Current sub ins:"));
        for (SubInManager.SubIn subIn : SubInManager.subIns) {
            OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.formatLoosely(" \u00a77{} is subbinng in for {}", OtherUtils.profileName(subIn.substituter()), OtherUtils.profileName(subIn.target())));
        }
        return 1;
    }
}

