/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.utils.enums.PacketNames;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.versions.VersionControl;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class LifeSeriesCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistryAccess, class_2170.class_5364 registrationEnvironment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"lifeseries").executes(context -> LifeSeriesCommand.defaultCommand((class_2168)context.getSource()))).then(class_2170.method_9247((String)"worlds").executes(context -> LifeSeriesCommand.getWorlds((class_2168)context.getSource())))).then(class_2170.method_9247((String)"credits").executes(context -> LifeSeriesCommand.getCredits((class_2168)context.getSource())))).then(class_2170.method_9247((String)"discord").executes(context -> LifeSeriesCommand.getDiscord((class_2168)context.getSource())))).then(class_2170.method_9247((String)"getSeries").executes(context -> LifeSeriesCommand.getSeason((class_2168)context.getSource())))).then(class_2170.method_9247((String)"version").executes(context -> LifeSeriesCommand.getVersion((class_2168)context.getSource())))).then(class_2170.method_9247((String)"config").executes(context -> LifeSeriesCommand.config((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).executes(context -> LifeSeriesCommand.reload((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"chooseSeries").requires(source -> NetworkHandlerServer.wasHandshakeSuccessful(source.method_44023()) || source.method_9228() == null)).executes(context -> LifeSeriesCommand.chooseSeason((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"setSeries").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"season", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> class_2172.method_9265(Main.ALLOWED_SEASON_NAMES, (SuggestionsBuilder)builder)).executes(context -> LifeSeriesCommand.setSeason((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"season"), false))).then(class_2170.method_9247((String)"confirm").executes(context -> LifeSeriesCommand.setSeason((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"season"), true))))));
        if (VersionControl.isDevVersion()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ls").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).then(class_2170.method_9247((String)"test").executes(context -> LifeSeriesCommand.test((class_2168)context.getSource())))).then(class_2170.method_9247((String)"test1").executes(context -> LifeSeriesCommand.test1((class_2168)context.getSource())))).then(class_2170.method_9247((String)"test2").executes(context -> LifeSeriesCommand.test2((class_2168)context.getSource())))).then(class_2170.method_9247((String)"test3").executes(context -> LifeSeriesCommand.test3((class_2168)context.getSource()))));
        }
    }

    public static int chooseSeason(class_2168 source) {
        if (source.method_44023() == null) {
            return -1;
        }
        if (!NetworkHandlerServer.wasHandshakeSuccessful(source.method_44023())) {
            source.method_9213(class_2561.method_30163((String)"You must have the Life Series mod installed \u00a7nclient-side\u00a7r to open the season selection GUI."));
            source.method_9213(class_2561.method_30163((String)"Use the '/lifeseries setSeries <season>' command instead."));
            return -1;
        }
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"\u00a77Opening the season selection GUI..."));
        NetworkHandlerServer.sendStringPacket(source.method_44023(), PacketNames.SELECT_SEASON, Main.currentSeason.getSeason().getId());
        return 1;
    }

    public static int setSeason(class_2168 source, String setTo, boolean confirmed) {
        if (!Main.ALLOWED_SEASON_NAMES.contains(setTo)) {
            source.method_9213(class_2561.method_30163((String)"That is not a valid season!"));
            source.method_9213((class_2561)TextUtils.formatPlain("You must choose one of the following: {}", Main.ALLOWED_SEASON_NAMES));
            return -1;
        }
        if (confirmed) {
            LifeSeriesCommand.setSeasonFinal(source, setTo);
        } else if (Main.currentSeason.getSeason() == Seasons.UNASSIGNED) {
            LifeSeriesCommand.setSeasonFinal(source, setTo);
        } else {
            OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"\u00a77WARNING: you have already selected a season, changing it might cause some saved data to be lost (lives, ...)"));
            OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"\u00a77If you are sure, use '\u00a7f/lifeseries setSeries <season> confirm\u00a77'"));
        }
        return 1;
    }

    public static void setSeasonFinal(class_2168 source, String setTo) {
        if (Main.changeSeasonTo(setTo)) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("\u00a77Changing the season to {}\u00a77...", setTo));
            PlayerUtils.broadcastMessage((class_2561)TextUtils.format("Successfully changed the season to {}", setTo).method_27692(class_124.field_1060));
        }
    }

    public static int config(class_2168 source) {
        if (source.method_44023() == null) {
            return -1;
        }
        if (!NetworkHandlerServer.wasHandshakeSuccessful(source.method_44023())) {
            source.method_9213(class_2561.method_30163((String)"You must have the Life Series mod installed \u00a7nclient-side\u00a7r to open the config GUI."));
            source.method_9213(class_2561.method_30163((String)"Either install the mod on the client on modify the config folder."));
            return -1;
        }
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"\u00a77Opening the config GUI..."));
        NetworkHandlerServer.sendStringPacket(source.method_44023(), PacketNames.OPEN_CONFIG, "");
        return 1;
    }

    public static int getWorlds(class_2168 source) {
        class_5250 worldSavesText = class_2561.method_43470((String)"\u00a77If you want to play on the exact same world seeds as Grian did, click ").method_10852((class_2561)class_2561.method_43470((String)"here").method_27694(style -> style.method_10977(class_124.field_1078).method_10958(TextUtils.openURLClickEvent("https://www.dropbox.com/scl/fo/jk9fhqx0jjbgeo2qa6v5i/AOZZxMx6S7MlS9HrIRJkkX4?rlkey=2khwcnf2zhgi6s4ik01e3z9d0&st=ghw1d8k6&dl=0")).method_30938(Boolean.valueOf(true)))).method_10852(class_2561.method_30163((String)"\u00a77 to open a dropbox where you can download the pre-made worlds."));
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)worldSavesText);
        return 1;
    }

    public static int defaultCommand(class_2168 source) {
        LifeSeriesCommand.getDiscord(source);
        return 1;
    }

    public static int getDiscord(class_2168 source) {
        class_5250 text = class_2561.method_43470((String)"\u00a77Click ").method_10852((class_2561)class_2561.method_43470((String)"here").method_27694(style -> style.method_10977(class_124.field_1078).method_10958(TextUtils.openURLClickEvent("https://discord.gg/QWJxfb4zQZ")).method_30938(Boolean.valueOf(true)))).method_10852(class_2561.method_30163((String)"\u00a77 to join the mod development discord if you have any questions, issues, requests, or if you just want to hang out :)"));
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)text);
        return 1;
    }

    public static int getSeason(class_2168 source) {
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("Current season: {}", Main.currentSeason.getSeason().getId()));
        if (source.method_44023() != null) {
            NetworkHandlerServer.sendStringPacket(source.method_44023(), PacketNames.SEASON_INFO, Main.currentSeason.getSeason().getId());
        }
        return 1;
    }

    public static int getVersion(class_2168 source) {
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("Mod version: {}", "dev-1.3.7.9"));
        return 1;
    }

    public static int reload(class_2168 source) {
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"\u00a77Reloading the Life Series..."));
        OtherUtils.reloadServer();
        return 1;
    }

    public static int getCredits(class_2168 source) {
        OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"\u00a77The Life Series was originally created by \u00a7fGrian\u00a77, and this mod, created by \u00a7fMat0u5\u00a77, aims to recreate every single season one-to-one."));
        OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"\u00a77This mod uses sounds created by \u00a7fOli (TheOrionSound)\u00a77, and uses recreated snail model (first created by \u00a7fDanny\u00a77), and a recreated trivia bot model (first created by \u00a7fHoffen\u00a77)."));
        OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"\u00a77This mod bundles other mods to improve the experience, such as \u00a7fPolymer\u00a77 and \u00a7fBlockbench Import Library."));
        return 1;
    }

    public static int test(class_2168 source) {
        class_3222 player = source.method_44023();
        if (player == null) {
            return -1;
        }
        OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)String.valueOf(VersionControl.getModVersionInt("v.1.3.6.25"))));
        OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)String.valueOf(VersionControl.getModVersionInt("1.3.6.25"))));
        OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)String.valueOf(VersionControl.getModVersionInt("dev-1.3.6.25"))));
        OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)String.valueOf(VersionControl.getModVersionInt("1.3.6.25-personname"))));
        OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)String.valueOf(VersionControl.getModVersionInt("dev-1.3.6.25-personname-two"))));
        OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)String.valueOf(VersionControl.getModVersionInt("dev-test-1.3.6.25-personname-two"))));
        OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)String.valueOf(VersionControl.getModVersionInt("dev-test-...1.3.-personname-two"))));
        OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)String.valueOf(VersionControl.getModVersionInt("dev-test-...1..3.-personname-two"))));
        OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)String.valueOf(VersionControl.getModVersionInt("dev-test-...1......3.-personname-two"))));
        return 1;
    }

    public static int test1(class_2168 source) {
        class_3222 player = source.method_44023();
        if (player == null) {
            return -1;
        }
        OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"Test Command 1"));
        return 1;
    }

    public static int test2(class_2168 source) {
        class_3222 player = source.method_44023();
        if (player == null) {
            return -1;
        }
        OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"Test Command 2"));
        return 1;
    }

    public static int test3(class_2168 source) {
        class_3222 player = source.method_44023();
        if (player == null) {
            return -1;
        }
        OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"Test Command 3"));
        return 1;
    }
}

