/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers;

import java.util.UUID;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.Superpowers;
import net.mat0u5.lifeseries.seasons.session.SessionTranscript;
import net.mat0u5.lifeseries.utils.enums.PacketNames;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public abstract class Superpower {
    public boolean active = false;
    public long cooldown = 0L;
    private final UUID playerUUID;

    public Superpower(class_3222 player) {
        this.playerUUID = player.method_5667();
        SessionTranscript.newSuperpower(player, this.getSuperpower());
    }

    @Nullable
    public class_3222 getPlayer() {
        return PlayerUtils.getPlayer(this.playerUUID);
    }

    public abstract Superpowers getSuperpower();

    public int getCooldownMillis() {
        return 1000;
    }

    public void tick() {
    }

    public void onKeyPressed() {
        if (System.currentTimeMillis() < this.cooldown) {
            this.sendCooldownPacket();
            return;
        }
        this.activate();
    }

    public void activate() {
        this.active = true;
        this.cooldown(this.getCooldownMillis());
    }

    public void deactivate() {
        this.active = false;
    }

    public void turnOff() {
        this.deactivate();
        NetworkHandlerServer.sendLongPacket(this.getPlayer(), PacketNames.SUPERPOWER_COOLDOWN, 0L);
    }

    public void cooldown(int millis) {
        this.cooldown = System.currentTimeMillis() + (long)millis;
    }

    public void sendCooldownPacket() {
        NetworkHandlerServer.sendLongPacket(this.getPlayer(), PacketNames.SUPERPOWER_COOLDOWN, this.cooldown);
    }
}

