/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.gui;

import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mat0u5.lifeseries.render.RenderUtils;
import net.mat0u5.lifeseries.utils.TextColors;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5348;

@Environment(value=EnvType.CLIENT)
public abstract class DefaultScreen
extends class_437 {
    private static final class_2960 BACKGROUND_TEXTURE_LEFT = class_2960.method_60655((String)"lifeseries", (String)"textures/gui/gui_left.png");
    private static final class_2960 BACKGROUND_TEXTURE_RIGHT = class_2960.method_60655((String)"lifeseries", (String)"textures/gui/gui_right.png");
    private static final class_2960 TEXTURE_CLOSE = class_2960.method_60655((String)"lifeseries", (String)"textures/gui/close.png");
    private static final class_2960 TEXTURE_SELECTED = class_2960.method_60655((String)"lifeseries", (String)"textures/gui/selected.png");
    protected int BG_WIDTH;
    protected int BG_HEIGHT;
    protected float scaleX = 1.0f;
    protected float scaleY = 1.0f;
    protected static final int DEFAULT_TEXT_COLOR = TextColors.DEFAULT;
    protected int startX;
    protected int centerX;
    protected int endX;
    protected int backgroundWidth;
    protected int startY;
    protected int centerY;
    protected int endY;
    protected int backgroundHeight;

    protected DefaultScreen(class_2561 name, float scaleX, float scaleY) {
        super(name);
        this.BG_WIDTH = (int)(320.0 * (double)scaleX);
        this.BG_HEIGHT = (int)(180.0 * (double)scaleY);
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.calculateCoordinates();
    }

    public DefaultScreen(class_2561 name) {
        super(name);
        this.BG_WIDTH = 320;
        this.BG_HEIGHT = 180;
        this.calculateCoordinates();
    }

    public void calculateCoordinates() {
        this.startX = (this.field_22789 - this.BG_WIDTH) / 2;
        this.endX = this.startX + this.BG_WIDTH;
        this.centerX = (this.startX + this.endX) / 2;
        this.backgroundWidth = this.endX - this.startX;
        this.startY = (this.field_22790 - this.BG_HEIGHT) / 2;
        this.endY = this.startY + this.BG_HEIGHT;
        this.centerY = (this.startY + this.endY) / 2;
        this.backgroundHeight = this.endY - this.startY;
    }

    public boolean isScaled() {
        return this.scaleX != 1.0f || this.scaleY != 1.0f;
    }

    public boolean allowCloseButton() {
        return true;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && this.allowCloseButton() && this.isInCloseRegion((int)mouseX, (int)mouseY)) {
            if (this.field_22787 != null) {
                this.field_22787.method_1507(null);
            }
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean isInCloseRegion(int x, int y) {
        double width = this.field_22793.method_27525((class_5348)class_2561.method_30163((String)"\u2716"));
        double middleX = (double)(this.endX - 4) - width / 2.0;
        Objects.requireNonNull(this.field_22793);
        double height = 9.0;
        double middleY = (double)(this.startY + 4) + height / 2.0;
        return Math.abs((double)x - middleX) <= width / 2.0 && Math.abs((double)y - middleY) <= height / 2.0;
    }

    protected void method_25426() {
        this.calculateCoordinates();
        super.method_25426();
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }

    public void renderBackground(class_332 context, int mouseX, int mouseY) {
        if (!this.isScaled()) {
            RenderUtils.drawTexture(context, BACKGROUND_TEXTURE_LEFT, this.startX, this.startY, 0, 0, this.BG_WIDTH / 2, this.BG_HEIGHT, 256, 256);
            RenderUtils.drawTexture(context, BACKGROUND_TEXTURE_RIGHT, this.startX + this.BG_WIDTH / 2, this.startY, 0, 0, this.BG_WIDTH / 2, this.BG_HEIGHT, 256, 256);
        } else {
            RenderUtils.drawTextureScaled(context, BACKGROUND_TEXTURE_LEFT, this.startX, this.startY, 0, 0, this.BG_WIDTH / 2, this.BG_HEIGHT, 256, 256, this.scaleX, this.scaleY);
            RenderUtils.drawTextureScaled(context, BACKGROUND_TEXTURE_RIGHT, this.startX + this.BG_WIDTH / 2, this.startY, 0, 0, this.BG_WIDTH / 2, this.BG_HEIGHT, 256, 256, this.scaleX, this.scaleY);
        }
        if (this.allowCloseButton()) {
            this.renderClose(context, mouseX, mouseY);
        }
    }

    public void renderClose(class_332 context, int mouseX, int mouseY) {
        if (this.isInCloseRegion(mouseX, mouseY)) {
            RenderUtils.drawTextRight(context, this.field_22793, class_2561.method_30163((String)"\u00a7l\u2716"), this.endX - 4, this.startY + 4);
        } else {
            RenderUtils.drawTextRight(context, this.field_22793, class_2561.method_30163((String)"\u2716"), this.endX - 4, this.startY + 4);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        this.renderBackground(context, mouseX, mouseY);
        this.render(context, mouseX, mouseY);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public abstract void render(class_332 var1, int var2, int var3);
}

