/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.season.Season;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.doublelife.DoubleLife;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.world.AnimationUtils;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class GivelifeCommand {
    private static Map<UUID, Map<UUID, Long>> soulmateGivelifeRequests = new HashMap<UUID, Map<UUID, Long>>();

    public static boolean isAllowed() {
        if (Main.currentSeason.getSeason() == Seasons.LIMITED_LIFE) {
            return false;
        }
        return (Boolean)Main.seasonConfig.GIVELIFE_COMMAND_ENABLED.get(Main.seasonConfig);
    }

    public static boolean checkBanned(class_2168 source) {
        if (GivelifeCommand.isAllowed()) {
            return false;
        }
        source.method_9213(class_2561.method_30163((String)"This command is not available."));
        return true;
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistryAccess, class_2170.class_5364 registrationEnvironment) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"givelife").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> GivelifeCommand.giftLife((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player")))));
    }

    public static int giftLife(class_2168 source, class_3222 target) {
        DoubleLife doubleLife;
        class_3222 soulmate;
        boolean isRevive;
        if (GivelifeCommand.checkBanned(source)) {
            return -1;
        }
        class_3222 self = source.method_44023();
        if (self == null) {
            return -1;
        }
        if (target == null) {
            return -1;
        }
        if (!Main.livesManager.isAlive(self)) {
            source.method_9213(class_2561.method_30163((String)"You do not have any lives to give"));
            return -1;
        }
        boolean bl = isRevive = !Main.livesManager.isAlive(target);
        if (!Season.GIVELIFE_CAN_REVIVE && isRevive) {
            source.method_9213(class_2561.method_30163((String)"That player is not alive"));
            return -1;
        }
        if (target == self) {
            source.method_9213(class_2561.method_30163((String)"You cannot give a life to yourself"));
            return -1;
        }
        Integer currentLives = Main.livesManager.getPlayerLives(self);
        if (currentLives == null || currentLives <= 1) {
            source.method_9213(class_2561.method_30163((String)"You cannot give away your last life"));
            return -1;
        }
        Integer targetLives = Main.livesManager.getPlayerLives(target);
        if (targetLives == null || targetLives >= Main.currentSeason.GIVELIFE_MAX_LIVES) {
            source.method_9213(class_2561.method_30163((String)"That player cannot receive any more lives"));
            return -1;
        }
        Season season = Main.currentSeason;
        if (season instanceof DoubleLife && (soulmate = (doubleLife = (DoubleLife)season).getSoulmate(self)) != null) {
            if (soulmate.equals((Object)target)) {
                source.method_9213(class_2561.method_30163((String)"You cannot give a life to your soulmate"));
                return -1;
            }
            boolean success = GivelifeCommand.doubleLifeGiveLife(source, self, soulmate, target);
            if (!success) {
                return -1;
            }
        }
        class_2561 currentPlayerName = self.method_55423();
        Main.livesManager.removePlayerLife(self);
        Main.livesManager.addToLifeNoUpdate(target);
        AnimationUtils.playTotemAnimation(self);
        TaskScheduler.scheduleTask(40, () -> Main.livesManager.receiveLifeFromOtherPlayer(currentPlayerName, target, isRevive));
        Season season2 = Main.currentSeason;
        if (season2 instanceof DoubleLife) {
            DoubleLife doubleLife2 = (DoubleLife)season2;
            doubleLife2.syncSoulboundLives(self);
        }
        return 1;
    }

    public static boolean doubleLifeGiveLife(class_2168 source, class_3222 self, class_3222 soulmate, class_3222 target) {
        Map<UUID, Long> soulmateRequest = soulmateGivelifeRequests.get(soulmate.method_5667());
        if (soulmateRequest != null) {
            for (Map.Entry<UUID, Long> entry : soulmateRequest.entrySet()) {
                UUID soulmateRequestTarget = entry.getKey();
                long requestTime = entry.getValue();
                if (!soulmateRequestTarget.equals(target.method_5667()) || System.currentTimeMillis() - requestTime > 60000L) continue;
                soulmateRequest.remove(soulmateRequestTarget);
                return true;
            }
        }
        if (soulmateGivelifeRequests.containsKey(self.method_5667())) {
            soulmateGivelifeRequests.get(self.method_5667()).put(target.method_5667(), System.currentTimeMillis());
        } else {
            HashMap<UUID, Long> request = new HashMap<UUID, Long>();
            request.put(target.method_5667(), System.currentTimeMillis());
            soulmateGivelifeRequests.put(self.method_5667(), request);
        }
        OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"\u00a77Your soulmate must accept your request to give a life to this player."));
        soulmate.method_43496((class_2561)TextUtils.format("Your soulmate wants to give a life to {}.\nClick ", target).method_10852((class_2561)class_2561.method_43470((String)"here").method_27694(style -> style.method_10977(class_124.field_1078).method_10958(TextUtils.runCommandClickEvent(TextUtils.formatString("/givelife {}", target.method_5820()))).method_30938(Boolean.valueOf(true)))).method_10852(class_2561.method_30163((String)" to accept the request.")));
        return false;
    }
}

