/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.entity.triviabot;

import de.tomalbrc.bil.api.AnimatedEntity;
import de.tomalbrc.bil.api.AnimatedEntityHolder;
import de.tomalbrc.bil.api.Animator;
import de.tomalbrc.bil.core.holder.entity.EntityHolder;
import de.tomalbrc.bil.core.holder.entity.living.LivingEntityHolder;
import de.tomalbrc.bil.core.model.Model;
import de.tomalbrc.bil.file.loader.BbModelLoader;
import eu.pb4.polymer.virtualentity.api.attachment.EntityAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.dependencies.DependencyManager;
import net.mat0u5.lifeseries.entity.AnimationHandler;
import net.mat0u5.lifeseries.entity.snail.Snail;
import net.mat0u5.lifeseries.entity.triviabot.goal.TriviaBotGlideGoal;
import net.mat0u5.lifeseries.entity.triviabot.goal.TriviaBotLookAtPlayerGoal;
import net.mat0u5.lifeseries.entity.triviabot.goal.TriviaBotTeleportGoal;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.registries.MobRegistry;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.WildcardManager;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcards;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.SizeShifting;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.trivia.TriviaQuestion;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.trivia.TriviaWildcard;
import net.mat0u5.lifeseries.utils.enums.PacketNames;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.AttributeUtils;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.world.AnimationUtils;
import net.mat0u5.lifeseries.utils.world.ItemSpawner;
import net.mat0u5.lifeseries.utils.world.ItemStackUtils;
import net.mat0u5.lifeseries.utils.world.WorldUtils;
import net.mat0u5.lifeseries.voicechat.VoicechatMain;
import net.minecraft.class_11;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1335;
import net.minecraft.class_1352;
import net.minecraft.class_1409;
import net.minecraft.class_1421;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1923;
import net.minecraft.class_1927;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3730;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4466;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_9334;
import net.minecraft.class_9381;
import org.jetbrains.annotations.Nullable;

public class TriviaBot
extends class_1421
implements AnimatedEntity {
    public static final class_2960 ID = class_2960.method_60655((String)"lifeseries", (String)"triviabot");
    public static final Model MODEL = BbModelLoader.load((class_2960)ID);
    public static final int STATIONARY_TP_COOLDOWN = 400;
    public static final float MOVEMENT_SPEED = 0.45f;
    public static final int MAX_DISTANCE = 100;
    public static boolean CAN_START_RIDING = true;
    public static ItemSpawner itemSpawner;
    public static int EASY_TIME;
    public static int NORMAL_TIME;
    public static int HARD_TIME;
    public boolean gliding = false;
    public boolean interactedWith = false;
    public long interactedAt = 0L;
    public int timeToComplete = 0;
    public int difficulty = 0;
    public boolean submittedAnswer = false;
    public Boolean answeredRight = null;
    public boolean ranOutOfTime = false;
    public int snailTransformation = 0;
    public TriviaQuestion question;
    public int nullPlayerChecks = 0;
    private final EntityHolder<TriviaBot> holder = new LivingEntityHolder((class_1309)this, MODEL);
    public UUID boundPlayerUUID;
    private int analyzing = -1;
    private int introSoundCooldown = 0;
    private boolean playedCountdownSound = false;
    private boolean playedCountdownEndingSound = false;
    private static final List<class_6880<class_1291>> blessEffects;
    public static final List<UUID> cursedGigantificationPlayers;
    public static final List<UUID> cursedSliding;
    public static final List<UUID> cursedHeartPlayers;
    public static final List<UUID> cursedMoonJumpPlayers;
    public static final List<UUID> cursedRoboticVoicePlayers;

    public TriviaBot(class_1299<? extends class_1421> entityType, class_1937 world) {
        super(entityType, world);
        EntityAttachment.ofTicking(this.holder, (class_1297)this);
        this.method_5684(true);
        this.method_5971();
        this.updateNavigation();
    }

    public AnimatedEntityHolder getHolder() {
        return this.holder;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        try {
            if (this.boundPlayerUUID == null) {
                return;
            }
            nbt.method_25927("boundPlayer", this.boundPlayerUUID);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        try {
            UUID newUUID = nbt.method_25926("boundPlayer");
            if (newUUID != null) {
                this.boundPlayerUUID = newUUID;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 10000.0).method_26868(class_5134.field_23719, (double)0.45f).method_26868(class_5134.field_23720, (double)0.45f).method_26868(class_5134.field_47761, 1.0).method_26868(class_5134.field_23717, 100.0).method_26868(class_5134.field_51578, 1.0).method_26868(class_5134.field_49079, 100.0).method_26868(class_5134.field_23721, 0.0);
    }

    @Nullable
    public class_3222 getBoundPlayer() {
        if (Main.server == null) {
            return null;
        }
        class_3222 player = PlayerUtils.getPlayer(this.boundPlayerUUID);
        if (player == null || player.method_7325() && player.method_29504()) {
            ++this.nullPlayerChecks;
            return null;
        }
        this.nullPlayerChecks = 0;
        if (player.method_7325()) {
            return null;
        }
        if (player.method_29504()) {
            return null;
        }
        return player;
    }

    @Nullable
    public class_3222 getActualBoundPlayer() {
        if (Main.server == null) {
            return null;
        }
        return PlayerUtils.getPlayer(this.boundPlayerUUID);
    }

    public void setBoundPlayer(class_3222 player) {
        if (player == null) {
            return;
        }
        this.boundPlayerUUID = player.method_5667();
        this.method_5652(new class_2487());
        this.sendDisplayEntityPackets(player);
    }

    public void sendDisplayEntityPackets(class_3222 player) {
        List elements = this.holder.getElements();
        for (VirtualElement element : elements) {
            if (!(element instanceof ItemDisplayElement)) continue;
            ItemDisplayElement itemDisplayElement = (ItemDisplayElement)element;
            NetworkHandlerServer.sendStringPacket(player, PacketNames.TRIVIA_BOT_PART, itemDisplayElement.getUuid().toString());
        }
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new TriviaBotTeleportGoal(this));
        this.field_6201.method_6277(1, (class_1352)new TriviaBotGlideGoal(this));
        this.field_6201.method_6277(2, (class_1352)new TriviaBotLookAtPlayerGoal(this));
    }

    public void method_5773() {
        super.method_5773();
        if (!(this.field_6012 % 100 != 0 || TriviaWildcard.bots.containsValue((Object)this) && WildcardManager.isActiveWildcard(Wildcards.TRIVIA))) {
            this.despawn();
        }
        if (this.field_6012 % 400 == 0 && this.getActualBoundPlayer() != null) {
            this.sendDisplayEntityPackets(this.getActualBoundPlayer());
        }
        if (this.submittedAnswer && this.answeredRight != null) {
            if (this.answeredRight.booleanValue()) {
                if (this.analyzing < -80) {
                    if (this.method_5765()) {
                        this.method_29239();
                    }
                    this.field_5960 = true;
                    float velocity = Math.min(0.5f, 0.25f * Math.abs((float)(this.analyzing + 80) / 20.0f));
                    this.method_18800(0.0, velocity, 0.0);
                    if (this.analyzing < -200) {
                        this.despawn();
                    }
                }
            } else if (this.analyzing < -100) {
                if (this.method_5765()) {
                    this.method_29239();
                }
                this.field_5960 = true;
                float velocity = Math.min(0.5f, 0.25f * Math.abs((float)(this.analyzing + 100) / 20.0f));
                this.method_18800(0.0, velocity, 0.0);
                if (this.analyzing < -200) {
                    this.despawn();
                }
            }
        } else {
            class_3222 boundPlayer;
            this.handleHighVelocity();
            if (!this.interactedWith && (boundPlayer = this.getBoundPlayer()) != null && this.field_6012 % 5 == 0) {
                this.updateNavigationTarget();
            }
            if (this.interactedWith && this.getRemainingTime() <= 0) {
                if (!this.ranOutOfTime && (boundPlayer = this.getBoundPlayer()) != null) {
                    NetworkHandlerServer.sendStringPacket(boundPlayer, PacketNames.RESET_TRIVIA, "true");
                }
                this.ranOutOfTime = true;
            }
            if (this.snailTransformation > 33) {
                this.transformIntoSnail();
            }
        }
        if (this.nullPlayerChecks > 1000) {
            this.despawn();
        }
        if (this.field_6012 % 2 == 0) {
            this.updateAnimations();
        }
        this.chunkLoading();
        this.method_6012();
        this.playSounds();
    }

    public void handleHighVelocity() {
        class_243 velocity = this.method_18798();
        if (velocity.field_1351 > 0.15) {
            this.method_18800(velocity.field_1352, 0.15, velocity.field_1350);
        } else if (velocity.field_1351 < -0.15) {
            this.method_18800(velocity.field_1352, -0.15, velocity.field_1350);
        }
    }

    public void chunkLoading() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            this.addTicket(world);
        }
    }

    public void addTicket(class_3218 world) {
        world.method_14178().method_17297(class_3230.field_19280, new class_1923(this.method_24515()), 2, (Object)this.method_24515());
    }

    public void despawn() {
        if (this.boundPlayerUUID != null) {
            TriviaWildcard.bots.remove(this.boundPlayerUUID);
        }
        this.method_5768();
        this.method_31472();
    }

    public void transformIntoSnail() {
        Snail triviaSnail;
        if (this.getBoundPlayer() != null && (triviaSnail = (Snail)MobRegistry.SNAIL.method_47821((class_3218)this.method_37908(), this.method_24515(), class_3730.field_16462)) != null) {
            triviaSnail.setBoundPlayer(this.getBoundPlayer());
            triviaSnail.setFromTrivia();
            triviaSnail.method_5783((class_3414)class_3417.field_15152.comp_349(), 0.5f, 2.0f);
            class_3218 world = (class_3218)triviaSnail.method_37908();
            world.method_14199((class_2394)class_2398.field_11236, this.method_19538().method_10216(), this.method_19538().method_10214(), this.method_19538().method_10215(), 10, 0.5, 0.5, 0.5, 0.5);
            TriviaWildcard.snails.put(this.getBoundPlayer().method_5667(), triviaSnail);
        }
        this.despawn();
    }

    public void updateAnimations() {
        AnimationHandler.updateHurtVariant((class_1309)this, this.holder);
        Animator animator = this.holder.getAnimator();
        if (this.ranOutOfTime) {
            if (this.snailTransformation == 0) {
                this.pauseAllAnimations("snail_transform");
                animator.playAnimation("snail_transform", 8);
            }
            ++this.snailTransformation;
        } else if (this.analyzing > 0) {
            --this.analyzing;
            this.pauseAllAnimations("analyzing");
        } else if (this.submittedAnswer && this.answeredRight != null) {
            if (this.analyzing == 0) {
                if (this.answeredRight.booleanValue()) {
                    this.pauseAllAnimations("answer_correct");
                    animator.playAnimation("answer_correct", 7);
                } else {
                    this.pauseAllAnimations("answer_incorrect");
                    animator.playAnimation("answer_incorrect", 6);
                }
            }
            --this.analyzing;
        } else if (this.interactedWith) {
            this.pauseAllAnimations("countdown");
            animator.playAnimation("countdown", 4);
        } else if (this.gliding) {
            this.pauseAllAnimations("glide");
            animator.playAnimation("glide", 3);
        } else if (this.field_42108.method_48571() && (double)this.field_42108.method_48566() > 0.02) {
            this.pauseAllAnimations("walk");
            animator.playAnimation("walk", 1);
        } else {
            this.pauseAllAnimations("idle");
            animator.playAnimation("idle", 0, true);
        }
    }

    public void playAnalyzingAnimation() {
        Animator animator = this.holder.getAnimator();
        this.pauseAllAnimations("analyzing");
        animator.playAnimation("analyzing", 5);
        this.analyzing = 42;
    }

    public void pauseAllAnimations(String except) {
        Animator animator = this.holder.getAnimator();
        if (!except.equalsIgnoreCase("glide")) {
            animator.pauseAnimation("glide");
        }
        if (!except.equalsIgnoreCase("walk")) {
            animator.pauseAnimation("walk");
        }
        if (!except.equalsIgnoreCase("idle")) {
            animator.pauseAnimation("idle");
        }
        if (!except.equalsIgnoreCase("countdown")) {
            animator.pauseAnimation("countdown");
        }
        if (!except.equalsIgnoreCase("analyzing")) {
            animator.pauseAnimation("analyzing");
        }
        if (!except.equalsIgnoreCase("answer_incorrect")) {
            animator.pauseAnimation("answer_incorrect");
        }
        if (!except.equalsIgnoreCase("answer_correct")) {
            animator.pauseAnimation("answer_correct");
        }
        if (!except.equalsIgnoreCase("snail_transform")) {
            animator.pauseAnimation("snail_transform");
        }
    }

    public void fakeTeleportToPlayer() {
        class_3222 player = this.getBoundPlayer();
        if (player == null) {
            return;
        }
        class_3218 playerWorld = PlayerUtils.getServerWorld(player);
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            class_2338 tpTo = TriviaBot.getBlockPosNearTarget(player, player.method_24515(), 5.0);
            world.method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_46945, this.method_5634(), this.method_6107(), this.method_6017());
            playerWorld.method_43128(null, (double)tpTo.method_10263(), (double)tpTo.method_10264(), (double)tpTo.method_10260(), class_3417.field_46945, this.method_5634(), this.method_6107(), this.method_6017());
            AnimationUtils.spawnTeleportParticles(world, this.method_19538());
            AnimationUtils.spawnTeleportParticles(playerWorld, tpTo.method_46558());
            this.despawn();
            TriviaWildcard.spawnBotFor(player, tpTo);
        }
    }

    public int getRemainingTime() {
        int timeSinceStart = (int)Math.ceil((double)(System.currentTimeMillis() - this.interactedAt) / 1000.0);
        return this.timeToComplete - timeSinceStart;
    }

    public long getRemainingTimeMs() {
        long timeSinceStart = System.currentTimeMillis() - this.interactedAt;
        return (long)this.timeToComplete * 1000L - timeSinceStart;
    }

    public static class_2338 getBlockPosNearTarget(class_3222 target, class_2338 targetPos, double distanceFromTarget) {
        if (target == null) {
            return targetPos;
        }
        return WorldUtils.getCloseBlockPos(PlayerUtils.getServerWorld(target), targetPos, distanceFromTarget, 2, false);
    }

    public void updateNavigation() {
        this.field_6207 = new class_1335((class_1308)this);
        this.field_6189 = new class_1409((class_1308)this, this.method_37908());
        this.updateNavigationTarget();
    }

    public void updateNavigationTarget() {
        if (this.getBoundPlayer() == null) {
            return;
        }
        if (this.method_5739((class_1297)this.getBoundPlayer()) > 100.0f) {
            return;
        }
        this.field_6189.method_6344((double)0.45f);
        class_11 path = this.field_6189.method_6349((class_1297)this.getBoundPlayer(), 3);
        if (path != null) {
            this.field_6189.method_6334(path, (double)0.45f);
        }
    }

    @Nullable
    public class_2338 getGroundBlock() {
        class_243 startPos = this.method_19538();
        class_243 endPos = startPos.method_1031(0.0, (double)this.method_37908().method_31607(), 0.0);
        class_3965 result = this.method_37908().method_17742(new class_3959(startPos, endPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
        if (result.method_17783() == class_239.class_240.field_1333) {
            return null;
        }
        return result.method_17777();
    }

    public double getDistanceToGroundBlock() {
        class_2338 belowBlock = this.getGroundBlock();
        if (belowBlock == null) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.method_23318() - (double)belowBlock.method_10264() - 1.0;
    }

    public void playSounds() {
        if (this.introSoundCooldown > 0) {
            --this.introSoundCooldown;
        }
        if (this.introSoundCooldown == 0 && !this.interactedWith) {
            class_3414 sound = class_3414.method_47908((class_2960)class_2960.method_60656((String)"wildlife_trivia_intro"));
            PlayerUtils.playSoundWithSourceToPlayers(PlayerUtils.getAllPlayers(), (class_1297)this, sound, class_3419.field_15254, 1.0f, 1.0f);
            this.introSoundCooldown = 830;
        }
        if (!this.playedCountdownEndingSound && this.interactedWith && !this.submittedAnswer && !this.ranOutOfTime && this.getRemainingTimeMs() <= 33800L) {
            PlayerUtils.playSoundWithSourceToPlayers(PlayerUtils.getAllPlayers(), (class_1297)this, class_3414.method_47908((class_2960)class_2960.method_60656((String)"wildlife_trivia_suspense_end")), class_3419.field_15254, 0.65f, 1.0f);
            this.playedCountdownEndingSound = true;
            this.playedCountdownSound = true;
        } else if (!this.playedCountdownSound && this.interactedWith && !this.submittedAnswer && !this.ranOutOfTime) {
            PlayerUtils.playSoundWithSourceToPlayers(PlayerUtils.getAllPlayers(), (class_1297)this, class_3414.method_47908((class_2960)class_2960.method_60656((String)"wildlife_trivia_suspense")), class_3419.field_15254, 0.65f, 1.0f);
            this.playedCountdownSound = true;
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_3222 boundPlayer = this.getBoundPlayer();
        if (boundPlayer == null) {
            return class_1269.field_5811;
        }
        if (boundPlayer.method_5667() != player.method_5667()) {
            return class_1269.field_5811;
        }
        if (this.submittedAnswer) {
            return class_1269.field_5811;
        }
        if (this.interactedWith && this.getRemainingTime() <= 0) {
            return class_1269.field_5811;
        }
        if (!this.interactedWith || this.question == null) {
            this.interactedAt = System.currentTimeMillis();
            this.difficulty = 1 + this.method_59922().method_43048(3);
            this.timeToComplete = this.difficulty * 60 + 120;
            if (this.difficulty == 1) {
                this.timeToComplete = EASY_TIME;
            }
            if (this.difficulty == 2) {
                this.timeToComplete = NORMAL_TIME;
            }
            if (this.difficulty == 3) {
                this.timeToComplete = HARD_TIME;
            }
            this.question = TriviaWildcard.getTriviaQuestion(this.difficulty);
        }
        NetworkHandlerServer.sendTriviaPacket(boundPlayer, this.question.getQuestion(), this.difficulty, this.interactedAt, this.timeToComplete, this.question.getAnswers());
        this.interactedWith = true;
        return class_1269.field_5811;
    }

    public void handleAnswer(int answer) {
        if (this.submittedAnswer) {
            return;
        }
        this.submittedAnswer = true;
        PlayerUtils.playSoundWithSourceToPlayers(PlayerUtils.getAllPlayers(), (class_1297)this, class_3414.method_47908((class_2960)class_2960.method_60656((String)"wildlife_trivia_analyzing")), class_3419.field_15254, 1.0f, 1.0f);
        if (answer == this.question.getCorrectAnswerIndex()) {
            this.answeredCorrect();
            TaskScheduler.scheduleTask(72, () -> PlayerUtils.playSoundWithSourceToPlayers(PlayerUtils.getAllPlayers(), (class_1297)this, class_3414.method_47908((class_2960)class_2960.method_60656((String)"wildlife_trivia_correct")), class_3419.field_15254, 1.0f, 1.0f));
        } else {
            this.answeredIncorrect();
            TaskScheduler.scheduleTask(72, () -> PlayerUtils.playSoundWithSourceToPlayers(PlayerUtils.getAllPlayers(), (class_1297)this, class_3414.method_47908((class_2960)class_2960.method_60656((String)"wildlife_trivia_incorrect")), class_3419.field_15254, 1.0f, 1.0f));
        }
    }

    public void answeredCorrect() {
        this.answeredRight = true;
        this.playAnalyzingAnimation();
        TaskScheduler.scheduleTask(145, this::spawnItemForPlayer);
        TaskScheduler.scheduleTask(170, this::spawnItemForPlayer);
        TaskScheduler.scheduleTask(198, this::spawnItemForPlayer);
        TaskScheduler.scheduleTask(213, this::blessPlayer);
    }

    public void answeredIncorrect() {
        this.answeredRight = false;
        this.playAnalyzingAnimation();
        TaskScheduler.scheduleTask(210, this::cursePlayer);
    }

    public void cursePlayer() {
        class_3222 player = this.getBoundPlayer();
        if (player == null) {
            return;
        }
        player.method_17356(class_3417.field_15203, class_3419.field_15250, 0.2f, 1.0f);
        class_3218 world = (class_3218)this.method_37908();
        class_243 pos = this.method_19538();
        world.method_14199((class_2394)class_9381.method_58256((class_2396)class_2398.field_11226, (int)-5893871), pos.method_10216(), pos.method_10214() + 1.0, pos.method_10215(), 40, 0.1, 0.25, 0.1, 0.035);
        int numOfCurses = 9;
        if (DependencyManager.voicechatLoaded() && VoicechatMain.isConnectedToSVC(player.method_5667())) {
            numOfCurses = 10;
        }
        int curse = world.field_9229.method_43048(numOfCurses);
        switch (curse) {
            default: {
                this.curseHunger(player);
                break;
            }
            case 1: {
                this.curseRavager(player);
                break;
            }
            case 2: {
                this.curseInfestation(player);
                break;
            }
            case 3: {
                this.curseGigantification(player);
                break;
            }
            case 4: {
                this.curseSlipperyGround(player);
                break;
            }
            case 5: {
                this.curseBindingArmor(player);
                break;
            }
            case 6: {
                this.curseHearts(player);
                break;
            }
            case 7: {
                this.curseMoonjump(player);
                break;
            }
            case 8: {
                this.curseBeeswarm(player);
                break;
            }
            case 9: {
                this.curseRoboticVoice(player);
            }
        }
    }

    public void blessPlayer() {
        class_3222 player = this.getBoundPlayer();
        if (player == null) {
            return;
        }
        player.method_43496((class_2561)class_2561.method_43473());
        for (int i = 0; i < 3; ++i) {
            class_6880<class_1291> effect = blessEffects.get(player.method_59922().method_43048(blessEffects.size()));
            int amplifier = effect == class_1294.field_5918 || effect == class_1294.field_5923 || effect == class_1294.field_5925 || effect == class_1294.field_5924 || effect == class_1294.field_5910 || effect == class_1294.field_5914 || effect == class_1294.field_5907 ? 0 : player.method_59922().method_43048(4);
            if (WildcardManager.isActiveWildcard(Wildcards.CALLBACK)) {
                player.method_6092(new class_1293(effect, 12000, amplifier));
            } else {
                player.method_6092(new class_1293(effect, 24000, amplifier));
            }
            String romanNumeral = TextUtils.toRomanNumeral(amplifier + 1);
            class_5250 effectName = class_2561.method_43471((String)((class_1291)effect.comp_349()).method_5567());
            player.method_43496((class_2561)TextUtils.formatLoosely(" \u00a7a\u00a7l+ \u00a77{}\u00a76 {}", effectName, romanNumeral));
        }
        player.method_43496((class_2561)class_2561.method_43473());
    }

    public void spawnItemForPlayer() {
        List<class_1799> lootTableItems;
        if (itemSpawner == null) {
            return;
        }
        if (this.getBoundPlayer() == null) {
            return;
        }
        class_243 playerPos = this.getBoundPlayer().method_19538();
        class_243 pos = this.method_19538().method_1031(0.0, 1.0, 0.0);
        class_243 relativeTargetPos = new class_243(playerPos.method_10216() - pos.method_10216(), 0.0, playerPos.method_10215() - pos.method_10215());
        class_243 vector = class_243.field_1353;
        if (relativeTargetPos.method_1027() > 1.0E-4) {
            vector = relativeTargetPos.method_1029().method_1021(0.3).method_1031(0.0, 0.1, 0.0);
        }
        if (!(lootTableItems = ItemSpawner.getRandomItemsFromLootTable(Main.server, (class_3218)this.method_37908(), this.getBoundPlayer(), class_2960.method_60655((String)"lifeseriesdynamic", (String)"trivia_reward_loottable"))).isEmpty()) {
            for (class_1799 item : lootTableItems) {
                ItemStackUtils.spawnItemForPlayerWithVelocity((class_3218)this.method_37908(), pos, item, (class_1657)this.getBoundPlayer(), vector);
            }
        } else {
            class_1799 randomItem = itemSpawner.getRandomItem();
            ItemStackUtils.spawnItemForPlayerWithVelocity((class_3218)this.method_37908(), pos, randomItem, (class_1657)this.getBoundPlayer(), vector);
        }
    }

    public static void initializeItemSpawner() {
        itemSpawner = new ItemSpawner();
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8463, 2), 20);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8634, 2), 20);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8547), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8848, 16), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8477, 4), 20);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8503), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8071, 8), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_49098, 16), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_37538, 2), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_28101, 8), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8626, 8), 20);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8786, 8), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8281, 8), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8108), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_22028), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_22029), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_22030), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8107, 64), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8773, 2), 10);
        class_1799 mace = new class_1799((class_1935)class_1802.field_49814);
        ItemStackUtils.setCustomComponentBoolean(mace, "IgnoreBlacklist", true);
        ItemStackUtils.setCustomComponentBoolean(mace, "NoModifications", true);
        mace.method_7974(mace.method_7936() - 1);
        itemSpawner.addItem(mace, 5);
        class_1799 endCrystal = new class_1799((class_1935)class_1802.field_8301);
        ItemStackUtils.setCustomComponentBoolean(endCrystal, "IgnoreBlacklist", true);
        itemSpawner.addItem(endCrystal, 10);
        class_1799 patat = new class_1799((class_1935)class_1802.field_8635);
        patat.method_57379(class_9334.field_49631, (Object)class_2561.method_30163((String)"\u00a76\u00a7l\u00a7nThe Sacred Patat"));
        ItemStackUtils.addLoreToItemStack(patat, List.of(class_2561.method_30163((String)"\u00a75\u00a7oEating this might help you. Or maybe not...")));
        itemSpawner.addItem(patat, 1);
    }

    public void curseHunger(class_3222 player) {
        class_1293 statusEffectInstance = new class_1293(class_1294.field_5903, 18000, 2);
        player.method_6092(statusEffectInstance);
    }

    public void curseRavager(class_3222 player) {
        class_2338 spawnPos = TriviaBot.getBlockPosNearTarget(player, this.method_24515(), 5.0);
        class_1299.field_6134.method_47821(PlayerUtils.getServerWorld(player), spawnPos, class_3730.field_16462);
    }

    public void curseInfestation(class_3222 player) {
        class_1293 statusEffectInstance = new class_1293(class_1294.field_50121, 18000, 0);
        player.method_6092(statusEffectInstance);
    }

    public void curseGigantification(class_3222 player) {
        cursedGigantificationPlayers.add(player.method_5667());
        SizeShifting.setPlayerSizeUnchecked(player, 4.0);
    }

    public void curseSlipperyGround(class_3222 player) {
        cursedSliding.add(player.method_5667());
    }

    public void curseBindingArmor(class_3222 player) {
        for (class_1799 item : PlayerUtils.getArmorItems(player)) {
            ItemStackUtils.spawnItemForPlayer(PlayerUtils.getServerWorld(player), player.method_19538(), item.method_7972(), (class_1657)player);
        }
        class_1799 head = class_1802.field_8267.method_7854();
        class_1799 chest = class_1802.field_8577.method_7854();
        class_1799 legs = class_1802.field_8570.method_7854();
        class_1799 boots = class_1802.field_8370.method_7854();
        head.method_7978(ItemStackUtils.getEnchantmentEntry((class_5321<class_1887>)class_1893.field_9113), 1);
        chest.method_7978(ItemStackUtils.getEnchantmentEntry((class_5321<class_1887>)class_1893.field_9113), 1);
        legs.method_7978(ItemStackUtils.getEnchantmentEntry((class_5321<class_1887>)class_1893.field_9113), 1);
        boots.method_7978(ItemStackUtils.getEnchantmentEntry((class_5321<class_1887>)class_1893.field_9113), 1);
        ItemStackUtils.setCustomComponentBoolean(head, "IgnoreBlacklist", true);
        ItemStackUtils.setCustomComponentBoolean(chest, "IgnoreBlacklist", true);
        ItemStackUtils.setCustomComponentBoolean(legs, "IgnoreBlacklist", true);
        ItemStackUtils.setCustomComponentBoolean(boots, "IgnoreBlacklist", true);
        player.method_5673(class_1304.field_6169, head);
        player.method_5673(class_1304.field_6174, chest);
        player.method_5673(class_1304.field_6172, legs);
        player.method_5673(class_1304.field_6166, boots);
        player.method_31548().method_5431();
    }

    public void curseHearts(class_3222 player) {
        cursedHeartPlayers.add(player.method_5667());
        double newHealth = Math.max(player.method_6063() - 7.0f, 1.0f);
        AttributeUtils.setMaxPlayerHealth(player, newHealth);
    }

    public void curseMoonjump(class_3222 player) {
        cursedMoonJumpPlayers.add(player.method_5667());
        AttributeUtils.setJumpStrength(player, 0.76);
    }

    public void curseBeeswarm(class_3222 player) {
        class_2338 spawnPos = TriviaBot.getBlockPosNearTarget(player, this.method_24515(), 1.0);
        class_4466 bee1 = (class_4466)class_1299.field_20346.method_47821((class_3218)this.method_37908(), spawnPos, class_3730.field_16462);
        class_4466 bee2 = (class_4466)class_1299.field_20346.method_47821((class_3218)this.method_37908(), spawnPos, class_3730.field_16462);
        class_4466 bee3 = (class_4466)class_1299.field_20346.method_47821((class_3218)this.method_37908(), spawnPos, class_3730.field_16462);
        class_4466 bee4 = (class_4466)class_1299.field_20346.method_47821((class_3218)this.method_37908(), spawnPos, class_3730.field_16462);
        class_4466 bee5 = (class_4466)class_1299.field_20346.method_47821((class_3218)this.method_37908(), spawnPos, class_3730.field_16462);
        if (bee1 != null) {
            bee1.method_29513(player.method_5667());
        }
        if (bee2 != null) {
            bee2.method_29513(player.method_5667());
        }
        if (bee3 != null) {
            bee3.method_29513(player.method_5667());
        }
        if (bee4 != null) {
            bee4.method_29513(player.method_5667());
        }
        if (bee5 != null) {
            bee5.method_29513(player.method_5667());
        }
        if (bee1 != null) {
            bee1.method_29514(1000000);
        }
        if (bee2 != null) {
            bee2.method_29514(1000000);
        }
        if (bee3 != null) {
            bee3.method_29514(1000000);
        }
        if (bee4 != null) {
            bee4.method_29514(1000000);
        }
        if (bee5 != null) {
            bee5.method_29514(1000000);
        }
    }

    public void curseRoboticVoice(class_3222 player) {
        cursedRoboticVoicePlayers.add(player.method_5667());
    }

    public class_3419 method_5634() {
        return class_3419.field_15248;
    }

    public class_243 method_26317(double gravity, boolean falling, class_243 motion) {
        return motion;
    }

    protected boolean method_29920() {
        return false;
    }

    public boolean method_5799() {
        return false;
    }

    public void method_5796(boolean swimming) {
        this.method_5729(4, false);
    }

    public boolean method_5692(class_6862<class_3611> tag, double speed) {
        return false;
    }

    protected boolean method_5860(class_1297 entity) {
        return CAN_START_RIDING;
    }

    public void method_5844(class_2680 state, class_243 multiplier) {
    }

    public boolean method_5659(class_1927 explosion) {
        return true;
    }

    public boolean method_5822(boolean allowVehicles) {
        return false;
    }

    static {
        EASY_TIME = 180;
        NORMAL_TIME = 240;
        HARD_TIME = 300;
        blessEffects = List.of(class_1294.field_5904, class_1294.field_5917, class_1294.field_5910, class_1294.field_5913, class_1294.field_5924, class_1294.field_5907, class_1294.field_5918, class_1294.field_5923, class_1294.field_5925, class_1294.field_5914, class_1294.field_5898);
        cursedGigantificationPlayers = new ArrayList<UUID>();
        cursedSliding = new ArrayList<UUID>();
        cursedHeartPlayers = new ArrayList<UUID>();
        cursedMoonJumpPlayers = new ArrayList<UUID>();
        cursedRoboticVoicePlayers = new ArrayList<UUID>();
    }
}

