/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.utils.other;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.events.Events;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;

public class OtherUtils {
    private static final Random rnd = new Random();
    private static final Pattern TIME_PATTERN = Pattern.compile("(?:(\\d+)h)?(?:(\\d+)m)?(?:(\\d+)s)?");
    private static long[] reloads = new long[]{System.currentTimeMillis(), System.currentTimeMillis(), System.currentTimeMillis()};

    public static void log(class_2561 message) {
        for (class_3222 player : PlayerUtils.getAllPlayers()) {
            player.method_7353(message, false);
        }
        Main.LOGGER.info(message.getString());
    }

    public static void log(String string) {
        class_2561 message = class_2561.method_30163((String)string);
        for (class_3222 player : PlayerUtils.getAllPlayers()) {
            player.method_7353(message, false);
        }
        Main.LOGGER.info(string);
    }

    public static void logConsole(String string) {
        Main.LOGGER.info(string);
    }

    public static void logIfClient(String string) {
        if (Main.isClient()) {
            Main.LOGGER.info(string);
        }
    }

    public static void debugString(String str) {
        Main.LOGGER.info(TextUtils.formatString("String length: {}", str.length()));
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            Main.LOGGER.info("Character at %d: '%c' (Unicode: U+%04X)%n", new Object[]{i, Character.valueOf(c), (int)c});
        }
    }

    public static String formatTime(int totalTicks) {
        int hours = totalTicks / 72000;
        int minutes = totalTicks % 72000 / 1200;
        int seconds = totalTicks % 1200 / 20;
        return TextUtils.formatString("{}:{}:{}", hours, OtherUtils.formatTimeNumber(minutes), OtherUtils.formatTimeNumber(seconds));
    }

    public static String formatTimeMillis(long millis) {
        long totalSeconds = (long)Math.ceil((double)millis / 1000.0);
        long hours = totalSeconds / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        if (hours == 0L) {
            return TextUtils.formatString("{}:{}", OtherUtils.formatTimeNumber(minutes), OtherUtils.formatTimeNumber(seconds));
        }
        return TextUtils.formatString("{}:{}:{}", hours, OtherUtils.formatTimeNumber(minutes), OtherUtils.formatTimeNumber(seconds));
    }

    public static String formatTimeNumber(int time) {
        Object value = String.valueOf(time);
        while (((String)value).length() < 2) {
            value = "0" + (String)value;
        }
        return value;
    }

    public static String formatTimeNumber(long time) {
        Object value = String.valueOf(time);
        while (((String)value).length() < 2) {
            value = "0" + (String)value;
        }
        return value;
    }

    public static String formatSecondsToReadable(int seconds) {
        boolean isNegative = seconds < 0;
        seconds = Math.abs(seconds);
        int hours = seconds / 3600;
        int remainingSeconds = seconds % 3600;
        int minutes = remainingSeconds / 60;
        int secs = remainingSeconds % 60;
        if (hours > 0 && minutes == 0 && secs == 0) {
            return (isNegative ? "-" : "+") + hours + (hours == 1 ? " hour" : " hours");
        }
        if (hours == 0 && minutes > 0 && secs == 0) {
            return (isNegative ? "-" : "+") + minutes + (minutes == 1 ? " minute" : " minutes");
        }
        if (hours == 0 && minutes == 0 && secs > 0) {
            return (isNegative ? "-" : "+") + secs + (secs == 1 ? " second" : " seconds");
        }
        return String.format("%s%d:%02d:%02d", isNegative ? "-" : "+", hours, minutes, secs);
    }

    public static int minutesToTicks(int mins) {
        return mins * 60 * 20;
    }

    public static int minutesToTicks(double mins) {
        double ticks = mins * 60.0 * 20.0;
        return (int)ticks;
    }

    public static int secondsToTicks(int secs) {
        return secs * 20;
    }

    public static Integer parseTimeFromArgument(String time) {
        Matcher matcher = TIME_PATTERN.matcher(time = time.replaceAll(" ", "").replaceAll("\"", ""));
        if (!matcher.matches()) {
            return null;
        }
        int hours = OtherUtils.parseInt(matcher.group(1));
        int minutes = OtherUtils.parseInt(matcher.group(2));
        int seconds = OtherUtils.parseInt(matcher.group(3));
        return (hours * 3600 + minutes * 60 + seconds) * 20;
    }

    public static Integer parseTimeSecondsFromArgument(String time) {
        Matcher matcher = TIME_PATTERN.matcher(time = time.replaceAll(" ", "").replaceAll("\"", ""));
        if (!matcher.matches()) {
            return null;
        }
        int hours = OtherUtils.parseInt(matcher.group(1));
        int minutes = OtherUtils.parseInt(matcher.group(2));
        int seconds = OtherUtils.parseInt(matcher.group(3));
        return hours * 3600 + minutes * 60 + seconds;
    }

    private static int parseInt(String value) {
        return value == null ? 0 : Integer.parseInt(value);
    }

    public static void executeCommand(String command) {
        try {
            if (Main.server == null) {
                return;
            }
            class_2170 manager = Main.server.method_3734();
            class_2168 commandSource = Main.server.method_3739().method_9217();
            manager.method_44252(commandSource, command);
        }
        catch (Exception e) {
            Main.LOGGER.error("Error executing command: " + command, (Throwable)e);
        }
    }

    public static void throwError(String error) {
        PlayerUtils.broadcastMessageToAdmins(class_2561.method_30163((String)("\u00a7c" + error)));
        Main.LOGGER.error(error);
    }

    public static class_3414 getRandomSound(String name, int from, int to) {
        if (to > from) {
            int index = rnd.nextInt(from, to + 1);
            name = (String)name + index;
        }
        return class_3414.method_47908((class_2960)class_2960.method_60655((String)"minecraft", (String)name));
    }

    public static String getTimeAndDate() {
        LocalDateTime time = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return time.format(formatter);
    }

    public static void reloadServerNoUpdate() {
        Events.skipNextTickReload = true;
        OtherUtils.reloadServer();
    }

    public static void reloadServer() {
        try {
            Arrays.sort(reloads);
            int inInterval = 0;
            for (int i = 0; i < 3; ++i) {
                if (System.currentTimeMillis() - reloads[i] >= 5000L) continue;
                ++inInterval;
            }
            if (inInterval >= 3) {
                Main.LOGGER.error("Detected and prevented possible reload loop!");
                return;
            }
            OtherUtils.reloads[0] = System.currentTimeMillis();
            OtherUtils.executeCommand("reload");
        }
        catch (Exception e) {
            Main.LOGGER.error("Error reloading server", (Throwable)e);
        }
    }

    public static void sendCommandFeedback(class_2168 source, class_2561 text) {
        if (source == null || text == null) {
            return;
        }
        source.method_9226(() -> text, true);
    }

    public static void sendCommandFeedbackQuiet(class_2168 source, class_2561 text) {
        if (source == null || text == null) {
            return;
        }
        source.method_9226(() -> text, false);
    }
}

