/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.entity.triviabot.server;

import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.entity.PlayerBoundEntity;
import net.mat0u5.lifeseries.entity.triviabot.TriviaBot;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.WildcardManager;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcards;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.Superpowers;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.SuperpowersWildcard;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.trivia.TriviaWildcard;
import net.mat0u5.lifeseries.utils.enums.PacketNames;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;

public class TriviaBotServerData
implements PlayerBoundEntity {
    private TriviaBot bot;
    public int snailTransformation = 0;
    public int despawnPlayerChecks = 0;
    private UUID _boundPlayerUUID;

    public TriviaBotServerData(TriviaBot bot) {
        this.bot = bot;
    }

    @Override
    public void onSetPlayer(class_3222 player) {
    }

    @Override
    public UUID getBoundPlayerUUID() {
        return this._boundPlayerUUID;
    }

    @Override
    public void setBoundPlayerUUID(UUID uuid) {
        this._boundPlayerUUID = uuid;
    }

    @Override
    public boolean shouldPathfind() {
        if (this.bot.getBotWorld().method_8608()) {
            return false;
        }
        class_3222 player = this.getBoundPlayer();
        if (player == null) {
            return false;
        }
        if (!player.method_5805()) {
            return false;
        }
        if (this.getPlayerPos() == null) {
            return false;
        }
        return !player.method_7325() || SuperpowersWildcard.hasActivatedPower(player, Superpowers.ASTRAL_PROJECTION);
    }

    public void tick() {
        if (this.bot.getBotWorld().method_8608()) {
            return;
        }
        if (this.despawnChecks()) {
            return;
        }
        this.bot.pathfinding.tick();
        if (this.bot.ranOutOfTime()) {
            ++this.snailTransformation;
        }
        if (this.bot.field_6012 % 2 == 0 && this.bot.submittedAnswer()) {
            this.bot.setAnalyzingTime(this.bot.getAnalyzingTime() - 1);
        }
        if (this.bot.submittedAnswer()) {
            if (this.bot.answeredRight()) {
                if (this.bot.getAnalyzingTime() < -80) {
                    if (this.bot.method_5765()) {
                        this.bot.method_29239();
                    }
                    this.bot.field_5960 = true;
                    float velocity = Math.min(0.5f, 0.25f * Math.abs((float)(this.bot.getAnalyzingTime() + 80) / 20.0f));
                    this.bot.method_18800(0.0, velocity, 0.0);
                    if (this.bot.getAnalyzingTime() < -200) {
                        this.despawn();
                    }
                }
            } else if (this.bot.getAnalyzingTime() < -100) {
                if (this.bot.method_5765()) {
                    this.bot.method_29239();
                }
                this.bot.field_5960 = true;
                float velocity = Math.min(0.5f, 0.25f * Math.abs((float)(this.bot.getAnalyzingTime() + 100) / 20.0f));
                this.bot.method_18800(0.0, velocity, 0.0);
                if (this.bot.getAnalyzingTime() < -200) {
                    this.despawn();
                }
            }
        } else {
            this.handleHighVelocity();
            if (this.bot.interactedWith() && this.bot.triviaHandler.getRemainingTime() <= 0) {
                class_3222 boundPlayer;
                if (!this.bot.ranOutOfTime() && (boundPlayer = this.getBoundPlayer()) != null) {
                    NetworkHandlerServer.sendStringPacket(boundPlayer, PacketNames.RESET_TRIVIA, "true");
                }
                this.bot.setRanOutOfTime(true);
            }
            if (this.snailTransformation > 66) {
                this.bot.triviaHandler.transformIntoSnail();
            }
        }
        this.chunkLoading();
        this.bot.method_6012();
        this.bot.sounds.playSounds();
    }

    public boolean despawnChecks() {
        class_3222 player = this.getBoundPlayer();
        if (player == null || player.method_7325() && Main.livesManager.isDead(player)) {
            ++this.despawnPlayerChecks;
        }
        if (this.despawnPlayerChecks > 200) {
            this.despawn();
            return true;
        }
        if (!(this.bot.field_6012 % 10 != 0 || TriviaWildcard.bots.containsValue((Object)this.bot) && WildcardManager.isActiveWildcard(Wildcards.TRIVIA))) {
            this.despawn();
            return true;
        }
        return false;
    }

    public void handleHighVelocity() {
        class_243 velocity = this.bot.method_18798();
        if (velocity.field_1351 > 0.15) {
            this.bot.method_18800(velocity.field_1352, 0.15, velocity.field_1350);
        } else if (velocity.field_1351 < -0.15) {
            this.bot.method_18800(velocity.field_1352, -0.15, velocity.field_1350);
        }
    }

    public void chunkLoading() {
        class_1937 class_19372 = this.bot.getBotWorld();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            world.method_14178().method_17297(class_3230.field_19280, new class_1923(this.bot.method_24515()), 2, (Object)this.bot.method_24515());
        }
    }

    public void despawn() {
        if (this.getBoundPlayerUUID() != null) {
            TriviaWildcard.bots.remove(this.getBoundPlayerUUID());
        }
        if (!this.bot.getBotWorld().method_8608()) {
            this.bot.method_5768();
        }
        this.bot.method_31472();
    }
}

