/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.network;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.MainClient;
import net.mat0u5.lifeseries.config.ClientConfig;
import net.mat0u5.lifeseries.config.ClientConfigGuiManager;
import net.mat0u5.lifeseries.config.ClientConfigNetwork;
import net.mat0u5.lifeseries.features.Morph;
import net.mat0u5.lifeseries.features.SnailSkinsClient;
import net.mat0u5.lifeseries.features.Trivia;
import net.mat0u5.lifeseries.gui.other.ChooseWildcardScreen;
import net.mat0u5.lifeseries.gui.other.PastLifeChooseTwistScreen;
import net.mat0u5.lifeseries.gui.other.SnailTextureInfoScreen;
import net.mat0u5.lifeseries.gui.seasons.ChooseSeasonScreen;
import net.mat0u5.lifeseries.gui.seasons.SeasonInfoScreen;
import net.mat0u5.lifeseries.mixin.client.InGameHudAccessor;
import net.mat0u5.lifeseries.network.packets.ConfigPayload;
import net.mat0u5.lifeseries.network.packets.HandshakePayload;
import net.mat0u5.lifeseries.network.packets.LongPayload;
import net.mat0u5.lifeseries.network.packets.NumberPayload;
import net.mat0u5.lifeseries.network.packets.PlayerDisguisePayload;
import net.mat0u5.lifeseries.network.packets.SidetitlePacket;
import net.mat0u5.lifeseries.network.packets.SnailTexturePacket;
import net.mat0u5.lifeseries.network.packets.StringListPayload;
import net.mat0u5.lifeseries.network.packets.StringPayload;
import net.mat0u5.lifeseries.network.packets.TriviaQuestionPayload;
import net.mat0u5.lifeseries.render.TextHud;
import net.mat0u5.lifeseries.render.VignetteRenderer;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.wildlife.morph.MorphManager;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcards;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.TimeDilation;
import net.mat0u5.lifeseries.seasons.session.SessionStatus;
import net.mat0u5.lifeseries.utils.ClientResourcePacks;
import net.mat0u5.lifeseries.utils.ClientTaskScheduler;
import net.mat0u5.lifeseries.utils.ClientUtils;
import net.mat0u5.lifeseries.utils.enums.HandshakeStatus;
import net.mat0u5.lifeseries.utils.enums.PacketNames;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.versions.VersionControl;
import net.mat0u5.lifeseries.utils.world.AnimationUtils;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public class NetworkHandlerClient {
    public static void registerClientReceiver() {
        ClientPlayNetworking.registerGlobalReceiver(NumberPayload.ID, (payload, context) -> {
            class_310 client = context.client();
            client.execute(() -> NetworkHandlerClient.handleNumberPacket(payload));
        });
        ClientPlayNetworking.registerGlobalReceiver(StringPayload.ID, (payload, context) -> {
            class_310 client = context.client();
            client.execute(() -> NetworkHandlerClient.handleStringPacket(payload));
        });
        ClientPlayNetworking.registerGlobalReceiver(HandshakePayload.ID, (payload, context) -> {
            class_310 client = context.client();
            client.execute(() -> NetworkHandlerClient.handleHandshake(payload));
        });
        ClientPlayNetworking.registerGlobalReceiver(TriviaQuestionPayload.ID, (payload, context) -> {
            class_310 client = context.client();
            client.execute(() -> Trivia.receiveTrivia(payload));
        });
        ClientPlayNetworking.registerGlobalReceiver(LongPayload.ID, (payload, context) -> {
            class_310 client = context.client();
            client.execute(() -> NetworkHandlerClient.handleLongPacket(payload));
        });
        ClientPlayNetworking.registerGlobalReceiver(PlayerDisguisePayload.ID, (payload, context) -> {
            class_310 client = context.client();
            client.execute(() -> NetworkHandlerClient.handlePlayerDisguise(payload));
        });
        ClientPlayNetworking.registerGlobalReceiver(ConfigPayload.ID, (payload, context) -> {
            class_310 client = context.client();
            client.execute(() -> NetworkHandlerClient.handleConfigPacket(payload));
        });
        ClientPlayNetworking.registerGlobalReceiver(StringListPayload.ID, (payload, context) -> {
            class_310 client = context.client();
            client.execute(() -> NetworkHandlerClient.handleStringListPacket(payload));
        });
        ClientPlayNetworking.registerGlobalReceiver(SidetitlePacket.ID, (payload, context) -> {
            class_310 client = context.client();
            client.execute(() -> NetworkHandlerClient.handleSidetitle(payload));
        });
        ClientPlayNetworking.registerGlobalReceiver(SnailTexturePacket.ID, (payload, context) -> context.client().execute(() -> SnailSkinsClient.handleSnailTexture(payload.skinName(), payload.textureData())));
    }

    public static void handleSidetitle(SidetitlePacket payload) {
        MainClient.sideTitle = payload.text();
        class_310 client = class_310.method_1551();
        class_329 class_3292 = client.field_1705;
        if (class_3292 instanceof InGameHudAccessor) {
            InGameHudAccessor hudAccessor = (InGameHudAccessor)class_3292;
            TextHud.sideTitleRemainTicks = hudAccessor.ls$titleFadeInTicks() + hudAccessor.ls$titleStayTicks() + hudAccessor.ls$titleFadeOutTicks();
        }
    }

    public static void handleStringListPacket(StringListPayload payload) {
        String nameStr = payload.name();
        PacketNames name = PacketNames.fromName(nameStr);
        List<String> value = payload.value();
        if (name == PacketNames.MORPH) {
            try {
                String morphUUIDStr = value.get(0);
                UUID morphUUID = UUID.fromString(morphUUIDStr);
                String morphTypeStr = value.get(1);
                class_1299 morphType = null;
                if (!morphTypeStr.equalsIgnoreCase("null") && !morphUUIDStr.isEmpty()) {
                    morphType = (class_1299)class_7923.field_41177.method_10223(class_2960.method_60654((String)morphTypeStr));
                }
                if (VersionControl.isDevVersion()) {
                    Main.LOGGER.info("[PACKET_CLIENT] Received morph packet: {} ({})", morphType, (Object)morphUUID);
                }
                MorphManager.setFromPacket(morphUUID, morphType);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void handleConfigPacket(ConfigPayload payload) {
        ClientConfigNetwork.handleConfigPacket(payload, false);
    }

    public static void handleStringPacket(StringPayload payload) {
        Seasons season;
        String nameStr = payload.name();
        PacketNames name = PacketNames.fromName(nameStr);
        String value = payload.value();
        if (name == PacketNames.CURRENT_SEASON) {
            if (VersionControl.isDevVersion()) {
                Main.LOGGER.info("[PACKET_CLIENT] Updated current season to {}", (Object)value);
            }
            MainClient.clientCurrentSeason = Seasons.getSeasonFromStringName(value);
            ClientResourcePacks.checkClientPacks();
            MainClient.reloadConfig();
        }
        if (name == PacketNames.SESSION_STATUS) {
            MainClient.clientSessionStatus = SessionStatus.getSessionName(value);
        }
        if (name == PacketNames.ACTIVE_WILDCARDS) {
            ArrayList<Wildcards> newList = new ArrayList<Wildcards>();
            for (String wildcardStr : value.split("__")) {
                newList.add(Wildcards.getFromString(wildcardStr));
            }
            if (VersionControl.isDevVersion()) {
                Main.LOGGER.info("[PACKET_CLIENT] Updated current wildcards to {}", newList);
            }
            MainClient.clientActiveWildcards = newList;
        }
        if (name == PacketNames.JUMP && class_310.method_1551().field_1724 != null) {
            class_310.method_1551().field_1724.method_6043();
        }
        if (name == PacketNames.RESET_TRIVIA) {
            Trivia.resetTrivia();
        }
        if (name == PacketNames.SELECT_WILDCARDS) {
            class_310.method_1551().method_1507((class_437)new ChooseWildcardScreen());
        }
        if (name == PacketNames.OPEN_CONFIG) {
            ClientConfigNetwork.load();
            ClientTaskScheduler.schedulePriorityTask(10, ClientConfigGuiManager::openConfig);
        }
        if (name == PacketNames.SELECT_SEASON) {
            class_310.method_1551().method_1507((class_437)new ChooseSeasonScreen(!value.isEmpty()));
        }
        if (name == PacketNames.SEASON_INFO && (season = Seasons.getSeasonFromStringName(value)) != Seasons.UNASSIGNED) {
            class_310.method_1551().method_1507((class_437)new SeasonInfoScreen(season));
        }
        if (name == PacketNames.SNAIL_TEXTURES_INFO) {
            class_310.method_1551().method_1507((class_437)new SnailTextureInfoScreen());
        }
        if (name == PacketNames.PREVENT_GLIDING) {
            MainClient.preventGliding = value.equalsIgnoreCase("true");
        }
        if (name == PacketNames.TOGGLE_TIMER) {
            String key = ClientConfig.SESSION_TIMER.key;
            MainClient.clientConfig.setProperty(key, String.valueOf(!MainClient.SESSION_TIMER));
            MainClient.reloadConfig();
        }
        if (name == PacketNames.TABLIST_SHOW_EXACT) {
            MainClient.TAB_LIST_SHOW_EXACT_LIVES = value.equalsIgnoreCase("true");
        }
        if (name == PacketNames.SHOW_TOTEM) {
            class_1799 totemItem = class_1802.field_8288.method_7854();
            if (value.equalsIgnoreCase("task") || value.equalsIgnoreCase("task_red")) {
                totemItem = AnimationUtils.getSecretLifeTotemItem(value.equalsIgnoreCase("task_red"));
            }
            class_310.method_1551().field_1773.method_3189(totemItem);
        }
        if (name == PacketNames.PAST_LIFE_CHOOSE_TWIST) {
            class_310.method_1551().method_1507((class_437)new PastLifeChooseTwistScreen());
        }
        if (name == PacketNames.FIX_SIZECHANGING_BUGS) {
            MainClient.FIX_SIZECHANGING_BUGS = value.equalsIgnoreCase("true");
        }
        if (name == PacketNames.ANIMAL_DISGUISE_ARMOR) {
            Morph.showArmor = value.equalsIgnoreCase("true");
        }
        if (name == PacketNames.ANIMAL_DISGUISE_HANDS) {
            Morph.showHandItems = value.equalsIgnoreCase("true");
        }
    }

    public static void handleNumberPacket(NumberPayload payload) {
        String nameStr = payload.name();
        PacketNames name = PacketNames.fromName(nameStr);
        double number = payload.number();
        int intNumber = (int)number;
        if (name == PacketNames.PLAYER_MIN_MSPT) {
            if (VersionControl.isDevVersion()) {
                Main.LOGGER.info("[PACKET_CLIENT] Updated min. player MSPT to {}", (Object)number);
            }
            TimeDilation.MIN_PLAYER_MSPT = (float)number;
        }
        if (name == PacketNames.SNAIL_AIR) {
            MainClient.snailAir = intNumber;
            MainClient.snailAirTimestamp = System.currentTimeMillis();
        }
        if (name == PacketNames.FAKE_THUNDER && class_310.method_1551().field_1687 != null) {
            class_310.method_1551().field_1687.method_8509(intNumber);
        }
        if (name == PacketNames.TAB_LIVES_CUTOFF) {
            MainClient.TAB_LIST_LIVES_CUTOFF = intNumber;
        }
        if (name == PacketNames.SIZESHIFTING_CHANGE) {
            MainClient.SIZESHIFTING_CHANGE = (float)number;
        }
    }

    public static void handleLongPacket(LongPayload payload) {
        String nameStr = payload.name();
        PacketNames name = PacketNames.fromName(nameStr);
        long number = payload.number();
        if (name == PacketNames.SUPERPOWER_COOLDOWN) {
            MainClient.SUPERPOWER_COOLDOWN_TIMESTAMP = number;
        }
        if (name == PacketNames.SHOW_VIGNETTE) {
            if (VersionControl.isDevVersion()) {
                Main.LOGGER.info("[PACKET_CLIENT] Showing vignette for {}", (Object)number);
            }
            VignetteRenderer.showVignetteFor(0.35f, number);
        }
        if (name == PacketNames.MIMICRY_COOLDOWN) {
            MainClient.MIMICRY_COOLDOWN_TIMESTAMP = number;
        }
        if (nameStr.startsWith(PacketNames.PLAYER_INVISIBLE.getName())) {
            try {
                UUID uuid = UUID.fromString(nameStr.replaceFirst(PacketNames.PLAYER_INVISIBLE.getName(), ""));
                if (number == 0L) {
                    MainClient.invisiblePlayers.remove(uuid);
                } else {
                    MainClient.invisiblePlayers.put(uuid, number);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (name == PacketNames.TIME_DILATION) {
            MainClient.TIME_DILATION_TIMESTAMP = number;
        }
        if (name == PacketNames.SESSION_TIMER) {
            MainClient.sessionTime = number;
            MainClient.sessionTimeLastUpdated = System.currentTimeMillis();
        }
        if (nameStr.startsWith(PacketNames.LIMITED_LIFE_TIMER.getName())) {
            MainClient.limitedLifeTimerColor = nameStr.replaceFirst(PacketNames.LIMITED_LIFE_TIMER.getName(), "");
            MainClient.limitedLifeLives = number;
            MainClient.limitedLifeTimeLastUpdated = System.currentTimeMillis();
        }
        if (name == PacketNames.CURSE_SLIDING) {
            MainClient.CURSE_SLIDING = number;
        }
    }

    public static void handlePlayerDisguise(PlayerDisguisePayload payload) {
        String nameStr = payload.name();
        PacketNames name = PacketNames.fromName(nameStr);
        String hiddenUUID = payload.hiddenUUID();
        String hiddenName = payload.hiddenName();
        String shownUUID = payload.shownUUID();
        String shownName = payload.shownName();
        if (name == PacketNames.PLAYER_DISGUISE) {
            if (shownName.isEmpty()) {
                MainClient.playerDisguiseNames.remove(hiddenName);
                try {
                    UUID hideUUID = UUID.fromString(hiddenUUID);
                    MainClient.playerDisguiseUUIDs.remove(hideUUID);
                }
                catch (Exception hideUUID) {}
            } else {
                MainClient.playerDisguiseNames.put(hiddenName, shownName);
                try {
                    UUID hideUUID = UUID.fromString(hiddenUUID);
                    UUID showUUID = UUID.fromString(shownUUID);
                    MainClient.playerDisguiseUUIDs.put(hideUUID, showUUID);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void handleHandshake(HandshakePayload payload) {
        MainClient.serverHandshake = HandshakeStatus.RECEIVED;
        String serverVersionStr = payload.modVersionStr();
        String serverCompatibilityStr = payload.compatibilityStr();
        String clientVersionStr = "dev-1.4.1.12";
        String clientCompatibilityStr = VersionControl.clientCompatibilityMin();
        int serverVersion = payload.modVersion();
        int serverCompatibility = payload.compatibility();
        int clientVersion = VersionControl.getModVersionInt(clientVersionStr);
        int clientCompatibility = VersionControl.getModVersionInt(clientCompatibilityStr);
        if (clientVersion < serverCompatibility) {
            class_5250 disconnectText = class_2561.method_43470((String)("[1Life Series Mod] Client-Server version mismatch!\nUpdate the client version to at least version " + serverCompatibilityStr));
            ClientUtils.disconnect((class_2561)disconnectText);
            return;
        }
        if (serverVersion < clientCompatibility) {
            class_5250 disconnectText = class_2561.method_43470((String)("[1Life Series Mod] Server-Client version mismatch!\nThe client version is too new for the server.\nEither update the server, or downgrade the client version to " + serverVersionStr));
            ClientUtils.disconnect((class_2561)disconnectText);
            return;
        }
        Main.LOGGER.info(TextUtils.formatString("[PACKET_CLIENT] Received handshake (from server): {{}, {}}", payload.modVersionStr(), payload.modVersion()));
        NetworkHandlerClient.sendHandshake();
    }

    public static void sendHandshake() {
        String clientVersionStr = "dev-1.4.1.12";
        String clientCompatibilityStr = VersionControl.clientCompatibilityMin();
        int clientVersion = VersionControl.getModVersionInt(clientVersionStr);
        int clientCompatibility = VersionControl.getModVersionInt(clientCompatibilityStr);
        HandshakePayload sendPayload = new HandshakePayload(clientVersionStr, clientVersion, clientCompatibilityStr, clientCompatibility);
        ClientPlayNetworking.send((class_8710)sendPayload);
        if (VersionControl.isDevVersion()) {
            Main.LOGGER.info("[PACKET_CLIENT] Sent handshake");
        }
    }

    public static void sendConfigUpdate(String configType, String id, List<String> args) {
        ConfigPayload configPacket = new ConfigPayload(configType, id, -1, "", "", args);
        ClientPlayNetworking.send((class_8710)configPacket);
    }

    public static void sendTriviaAnswer(int answer) {
        if (VersionControl.isDevVersion()) {
            Main.LOGGER.info("[PACKET_CLIENT] Sending trivia answer: {}", (Object)answer);
        }
        ClientPlayNetworking.send((class_8710)new NumberPayload(PacketNames.TRIVIA_ANSWER.getName(), answer));
    }

    public static void sendHoldingJumpPacket() {
        ClientPlayNetworking.send((class_8710)new StringPayload(PacketNames.HOLDING_JUMP.getName(), "true"));
    }

    public static void pressSuperpowerKey() {
        ClientPlayNetworking.send((class_8710)new StringPayload(PacketNames.SUPERPOWER_KEY.getName(), "true"));
    }

    public static void pressRunCommandKey() {
        ClientUtils.runCommand(MainClient.RUN_COMMAND);
    }

    public static void pressOpenConfigKey() {
        ClientUtils.runCommand("/lifeseries config");
    }

    public static void sendStringPacket(PacketNames name, String value) {
        ClientPlayNetworking.send((class_8710)new StringPayload(name.getName(), value));
    }

    public static void sendNumberPacket(PacketNames name, double value) {
        ClientPlayNetworking.send((class_8710)new NumberPayload(name.getName(), value));
    }
}

