/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.render;

import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mat0u5.lifeseries.MainClient;
import net.mat0u5.lifeseries.events.ClientKeybinds;
import net.mat0u5.lifeseries.features.Trivia;
import net.mat0u5.lifeseries.render.ClientRenderer;
import net.mat0u5.lifeseries.render.RenderUtils;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.utils.TextColors;
import net.mat0u5.lifeseries.utils.enums.SessionTimerStates;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

@Environment(value=EnvType.CLIENT)
public class TextHud {
    public static int sideTitleRemainTicks = 0;
    public static long lastSessionSeconds = 0L;
    public static long sessionSeconds = -1L;
    public static boolean sessionSecondChanged = true;
    private static long limitedLifeTime = -1L;
    private static long lastPressed = 0L;

    public static void renderText(class_332 context) {
        class_310 client = class_310.method_1551();
        if (client.field_1690.field_1842) {
            return;
        }
        int n = client.method_22683().method_4502();
        Objects.requireNonNull(client.field_1772);
        int yPos = n - (5 + (int)Math.ceil(9.0 * MainClient.TEXT_HUD_SCALE));
        yPos += TextHud.renderGameNotBroken(client, context, yPos);
        yPos += TextHud.renderSessionTimer(client, context, yPos);
        yPos += TextHud.renderLimitedLifeTimer(client, context, yPos);
        yPos += TextHud.renderMimicryTimer(client, context, yPos);
        yPos += TextHud.renderSuperpowerCooldown(client, context, yPos);
        yPos += TextHud.renderTriviaTimer(client, context, yPos);
        yPos += TextHud.renderSidetitle(client, context, yPos);
    }

    public static void tick() {
        if (sideTitleRemainTicks > 0) {
            --sideTitleRemainTicks;
        }
    }

    public static int renderSidetitle(class_310 client, class_332 context, int y) {
        if (MainClient.sideTitle == null) {
            return 0;
        }
        if (MainClient.sideTitle.getString().isEmpty()) {
            return 0;
        }
        if (sideTitleRemainTicks <= 0) {
            return 0;
        }
        return TextHud.drawHudText(client, context, MainClient.sideTitle, y);
    }

    public static int renderGameNotBroken(class_310 client, class_332 context, int y) {
        if (client.field_1724 == null) {
            return 0;
        }
        if (!ClientRenderer.isGameFullyFrozen) {
            return 0;
        }
        long currentMillis = System.currentTimeMillis();
        int guiScale = (Integer)client.field_1690.method_42474().method_41753();
        if (guiScale <= 3 && guiScale != 0) {
            Object textString = "Don't worry, the game is not broken ";
            textString = currentMillis % 1500L <= 750L ? "\u00a77\u00a7n" + (String)textString : "\u00a77" + (String)textString;
            textString = currentMillis % 500L <= 250L ? (String)textString + "/o/" : (String)textString + "\\o\\";
            class_5250 text = class_2561.method_43470((String)textString);
            return TextHud.drawHudText(client, context, (class_2561)text, y) - 5;
        }
        Object textString0 = "Don't worry,";
        Object textString1 = "the game isn't broken ";
        if (currentMillis % 1500L <= 750L) {
            textString0 = "\u00a77\u00a7n" + (String)textString0;
            textString1 = "\u00a77\u00a7n" + (String)textString1;
        } else {
            textString0 = "\u00a77" + (String)textString0;
            textString1 = "\u00a77" + (String)textString1;
        }
        textString1 = currentMillis % 500L <= 250L ? (String)textString1 + "/o/" : (String)textString1 + "\\o\\";
        class_5250 text0 = class_2561.method_43470((String)textString0);
        class_5250 text1 = class_2561.method_43470((String)textString1);
        int screenWidth = client.method_22683().method_4486();
        int x = screenWidth - 5;
        int draw1 = TextHud.drawHudText(client, context, (class_2561)text1, y);
        int n = x - (client.field_1772.method_27525((class_5348)text1) - client.field_1772.method_27525((class_5348)text0)) / 2;
        Objects.requireNonNull(client.field_1772);
        int draw2 = TextHud.drawHudText(client, context, (class_2561)text0, n, y - (9 + 1));
        return draw1 + draw2 - 5;
    }

    public static int renderSessionTimer(class_310 client, class_332 context, int y) {
        sessionSecondChanged = true;
        sessionSeconds = -1L;
        if (!MainClient.SESSION_TIMER) {
            return 0;
        }
        if (System.currentTimeMillis() - MainClient.sessionTimeLastUpdated > 15000L) {
            return 0;
        }
        if (MainClient.sessionTime == (long)SessionTimerStates.OFF.getValue()) {
            return 0;
        }
        class_5250 timerText = class_2561.method_43473();
        if (MainClient.sessionTime == (long)SessionTimerStates.ENDED.getValue()) {
            timerText = timerText.method_10852(class_2561.method_30163((String)"\u00a77Session has ended"));
        } else if (MainClient.sessionTime == (long)SessionTimerStates.PAUSED.getValue()) {
            timerText = timerText.method_10852(class_2561.method_30163((String)"\u00a77Session has been paused"));
        } else if (MainClient.sessionTime == (long)SessionTimerStates.NOT_STARTED.getValue()) {
            timerText = timerText.method_10852(class_2561.method_30163((String)"\u00a77Session has not started"));
        } else {
            long remainingTime = TextHud.roundTime(MainClient.sessionTime) - System.currentTimeMillis();
            sessionSeconds = (int)Math.ceil((double)remainingTime / 1000.0);
            if (lastSessionSeconds != sessionSeconds) {
                lastSessionSeconds = sessionSeconds;
            } else {
                sessionSecondChanged = false;
            }
            timerText = remainingTime < 0L ? timerText.method_10852(class_2561.method_30163((String)"\u00a77Session has ended")) : timerText.method_10852((class_2561)TextUtils.formatLoosely("\u00a77Session {}", OtherUtils.formatTimeMillis(remainingTime)));
        }
        return TextHud.drawHudText(client, context, (class_2561)timerText, y);
    }

    public static int renderLimitedLifeTimer(class_310 client, class_332 context, int y) {
        if (MainClient.clientCurrentSeason != Seasons.LIMITED_LIFE) {
            return 0;
        }
        if (System.currentTimeMillis() - MainClient.limitedLifeTimeLastUpdated > 15000L) {
            return 0;
        }
        class_5250 timerText = class_2561.method_43473();
        if (sessionSecondChanged || MainClient.sessionTime <= 0L || Math.abs(limitedLifeTime - MainClient.limitedLifeLives) > 10L) {
            limitedLifeTime = MainClient.limitedLifeLives;
        }
        if (limitedLifeTime == -1L) {
            timerText = timerText.method_10852((class_2561)TextUtils.formatLoosely("{}0:00:00", MainClient.limitedLifeTimerColor));
        } else {
            long remainingTime;
            long secondsDifference;
            long currentSeconds = limitedLifeTime;
            if (sessionSeconds != -1L && currentSeconds > 60L && Math.abs(secondsDifference = sessionSeconds % 60L - currentSeconds % 60L) <= 5L) {
                currentSeconds += secondsDifference;
            }
            timerText = (remainingTime = currentSeconds * 1000L) < 0L ? timerText.method_10852((class_2561)TextUtils.formatLoosely("{}0:00:00", MainClient.limitedLifeTimerColor)) : timerText.method_10852(class_2561.method_30163((String)(MainClient.limitedLifeTimerColor + OtherUtils.formatTimeMillis(remainingTime))));
        }
        return TextHud.drawHudText(client, context, (class_2561)timerText, y);
    }

    public static int renderTriviaTimer(class_310 client, class_332 context, int y) {
        if (!Trivia.isDoingTrivia()) {
            return 0;
        }
        if (client.field_1755 != null) {
            return 0;
        }
        long millisLeft = TextHud.roundTime(Trivia.getEndTimestamp()) - System.currentTimeMillis();
        class_2561 actualTimer = class_2561.method_30163((String)OtherUtils.formatTimeMillis(millisLeft));
        class_2561 timerText = class_2561.method_30163((String)"\u00a77Trivia timer: ");
        int screenWidth = client.method_22683().method_4486();
        int x = screenWidth - 5;
        if (millisLeft <= 5000L) {
            TextHud.drawHudText(client, context, TextColors.RED, actualTimer, x, y);
        } else if (millisLeft <= 30000L) {
            TextHud.drawHudText(client, context, TextColors.ORANGE, actualTimer, x, y);
        } else {
            TextHud.drawHudText(client, context, TextColors.WHITE, actualTimer, x, y);
        }
        return TextHud.drawHudText(client, context, timerText, x - client.field_1772.method_27525((class_5348)actualTimer), y);
    }

    public static int renderSuperpowerCooldown(class_310 client, class_332 context, int y) {
        boolean keyPressed;
        if (ClientKeybinds.superpower != null && ClientKeybinds.superpower.method_1434()) {
            lastPressed = System.currentTimeMillis();
        }
        if (MainClient.SUPERPOWER_COOLDOWN_TIMESTAMP == 0L) {
            return 0;
        }
        long currentMillis = System.currentTimeMillis();
        if (currentMillis >= MainClient.SUPERPOWER_COOLDOWN_TIMESTAMP) {
            return 0;
        }
        long millisLeft = TextHud.roundTime(MainClient.SUPERPOWER_COOLDOWN_TIMESTAMP) - currentMillis;
        if (millisLeft > 10000000L) {
            return 0;
        }
        long pressedAgo = System.currentTimeMillis() - lastPressed;
        boolean bl = keyPressed = pressedAgo < 500L;
        if (pressedAgo > 6000L) {
            return 0;
        }
        class_5250 timerText = TextUtils.formatLoosely("{}Superpower cooldown:\u00a7f {}", keyPressed ? "\u00a7c\u00a7n" : "\u00a77", OtherUtils.formatTimeMillis(millisLeft));
        return TextHud.drawHudText(client, context, (class_2561)timerText, y);
    }

    public static int renderMimicryTimer(class_310 client, class_332 context, int y) {
        if (MainClient.MIMICRY_COOLDOWN_TIMESTAMP == 0L) {
            return 0;
        }
        long currentMillis = System.currentTimeMillis();
        if (currentMillis >= MainClient.MIMICRY_COOLDOWN_TIMESTAMP) {
            return 0;
        }
        long millisLeft = TextHud.roundTime(MainClient.MIMICRY_COOLDOWN_TIMESTAMP) - currentMillis;
        if (millisLeft > 10000000L) {
            return 0;
        }
        class_5250 timerText = TextUtils.formatLoosely("\u00a77Mimic power cooldown: \u00a7f{}", OtherUtils.formatTimeMillis(millisLeft));
        return TextHud.drawHudText(client, context, (class_2561)timerText, y);
    }

    public static int drawHudText(class_310 client, class_332 context, class_2561 text, int y) {
        int screenWidth = client.method_22683().method_4486();
        int x = screenWidth - 5;
        return TextHud.drawHudText(client, context, text, x, y);
    }

    public static int drawHudText(class_310 client, class_332 context, class_2561 text, int x, int y) {
        return TextHud.drawHudText(client, context, TextColors.DEFAULT, text, x, y);
    }

    public static int drawHudText(class_310 client, class_332 context, int color, class_2561 text, int x, int y) {
        if (MainClient.TEXT_HUD_SCALE != 1.0) {
            RenderUtils.drawTextRightScaled(context, client.field_1772, color, text, x, y, (float)MainClient.TEXT_HUD_SCALE, (float)MainClient.TEXT_HUD_SCALE, true);
            Objects.requireNonNull(client.field_1772);
            return -((int)Math.ceil(9.0 * MainClient.TEXT_HUD_SCALE) + 5);
        }
        RenderUtils.drawTextRight(context, client.field_1772, color, text, x, y, true);
        Objects.requireNonNull(client.field_1772);
        return -9 - 5;
    }

    public static long roundTime(long time) {
        return time - time % 1000L;
    }
}

