/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.blacklist;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.Superpowers;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.SuperpowersWildcard;
import net.mat0u5.lifeseries.utils.other.IdentifierHelper;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.world.ItemStackUtils;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class Blacklist {
    public List<class_2960> loadedListItemIdentifier;
    public List<class_2960> loadedRecipeBlacklist;
    private List<class_1792> loadedListItem;
    private List<class_2248> loadedListBlock;
    private List<class_5321<class_1887>> loadedListEnchants;
    private List<class_5321<class_1887>> loadedBannedEnchants;
    private List<class_6880<class_1291>> loadedBannedEffects;
    public boolean CREATIVE_IGNORE_BLACKLIST = true;

    public List<String> loadItemBlacklist() {
        if (Main.seasonConfig == null) {
            return new ArrayList<String>();
        }
        String raw = (String)Main.seasonConfig.BLACKLIST_ITEMS.get(Main.seasonConfig);
        if ((raw = raw.replaceAll("\\[", "").replaceAll("]", "").replaceAll(" ", "")).isEmpty()) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(Arrays.asList(raw.split(",")));
    }

    public List<String> loadRecipeBlacklist() {
        if (Main.seasonConfig == null) {
            return new ArrayList<String>();
        }
        String raw = (String)Main.seasonConfig.BLACKLIST_RECIPES.get(Main.seasonConfig);
        if ((raw = raw.replaceAll("\\[", "").replaceAll("]", "").replaceAll(" ", "")).isEmpty()) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(Arrays.asList(raw.split(",")));
    }

    public List<String> loadBlockBlacklist() {
        if (Main.seasonConfig == null) {
            return new ArrayList<String>();
        }
        String raw = (String)Main.seasonConfig.BLACKLIST_BLOCKS.get(Main.seasonConfig);
        if ((raw = raw.replaceAll("\\[", "").replaceAll("]", "").replaceAll(" ", "")).isEmpty()) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(Arrays.asList(raw.split(",")));
    }

    public List<String> loadClampedEnchants() {
        if (Main.seasonConfig == null) {
            return new ArrayList<String>();
        }
        String raw = (String)Main.seasonConfig.BLACKLIST_CLAMPED_ENCHANTS.get(Main.seasonConfig);
        if ((raw = raw.replaceAll("\\[", "").replaceAll("]", "").replaceAll(" ", "")).isEmpty()) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(Arrays.asList(raw.split(",")));
    }

    public List<String> loadBlacklistedEnchants() {
        if (Main.seasonConfig == null) {
            return new ArrayList<String>();
        }
        String raw = (String)Main.seasonConfig.BLACKLIST_BANNED_ENCHANTS.get(Main.seasonConfig);
        if ((raw = raw.replaceAll("\\[", "").replaceAll("]", "").replaceAll(" ", "")).isEmpty()) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(Arrays.asList(raw.split(",")));
    }

    public List<String> loadBannedPotions() {
        if (Main.seasonConfig == null) {
            return new ArrayList<String>();
        }
        String raw = (String)Main.seasonConfig.BLACKLIST_BANNED_POTION_EFFECTS.get(Main.seasonConfig);
        if ((raw = raw.replaceAll("\\[", "").replaceAll("]", "").replaceAll(" ", "")).isEmpty()) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(Arrays.asList(raw.split(",")));
    }

    /*
     * WARNING - void declaration
     */
    public List<class_1792> getItemBlacklist() {
        if (this.loadedListItem != null) {
            return this.loadedListItem;
        }
        ArrayList<class_1792> newList = new ArrayList<class_1792>();
        ArrayList<class_2960> newListIdentifier = new ArrayList<class_2960>();
        for (String string : this.loadItemBlacklist()) {
            void var4_4;
            if (!string.contains(":")) {
                String string2 = "minecraft:" + string;
            }
            try {
                class_2960 id = IdentifierHelper.parse((String)var4_4);
                class_5321 key = class_5321.method_29179((class_5321)class_7923.field_41178.method_46765(), (class_2960)id);
                class_1792 item = (class_1792)class_7923.field_41178.method_29107(key);
                if (item != null) {
                    newListIdentifier.add(id);
                    newList.add(item);
                    continue;
                }
                OtherUtils.throwError("[CONFIG] Invalid item: " + (String)var4_4);
            }
            catch (Exception e) {
                OtherUtils.throwError("[CONFIG] Error parsing item ID: " + (String)var4_4);
            }
        }
        this.loadedListItem = newList;
        this.loadedListItemIdentifier = newListIdentifier;
        return newList;
    }

    /*
     * WARNING - void declaration
     */
    public List<class_2960> getRecipeBlacklist() {
        if (this.loadedRecipeBlacklist != null) {
            return this.loadedRecipeBlacklist;
        }
        ArrayList<class_2960> newList = new ArrayList<class_2960>();
        if (Main.seasonConfig != null && !((Boolean)Main.seasonConfig.SPAWNER_RECIPE.get(Main.seasonConfig)).booleanValue()) {
            newList.add(IdentifierHelper.mod("spawner_recipe"));
        }
        for (String string : this.loadRecipeBlacklist()) {
            void var3_3;
            if (!string.contains(":")) {
                String string2 = "minecraft:" + string;
            }
            try {
                class_2960 id = IdentifierHelper.parse((String)var3_3);
                class_5321 key = class_5321.method_29179((class_5321)class_7923.field_41178.method_46765(), (class_2960)id);
                class_1792 item = (class_1792)class_7923.field_41178.method_29107(key);
                if (item != null) {
                    newList.add(id);
                    continue;
                }
                OtherUtils.throwError("[CONFIG] Invalid item: " + (String)var3_3);
            }
            catch (Exception e) {
                OtherUtils.throwError("[CONFIG] Error parsing item ID: " + (String)var3_3);
            }
        }
        this.loadedRecipeBlacklist = newList;
        return newList;
    }

    /*
     * WARNING - void declaration
     */
    public List<class_2248> getBlockBlacklist() {
        if (this.loadedListBlock != null) {
            return this.loadedListBlock;
        }
        ArrayList<class_2248> newList = new ArrayList<class_2248>();
        for (String string : this.loadBlockBlacklist()) {
            void var3_3;
            if (!string.contains(":")) {
                String string2 = "minecraft:" + string;
            }
            try {
                class_2960 id = IdentifierHelper.parse((String)var3_3);
                class_5321 key = class_5321.method_29179((class_5321)class_7923.field_41175.method_46765(), (class_2960)id);
                class_2248 block = (class_2248)class_7923.field_41175.method_29107(key);
                if (block != null) {
                    newList.add(block);
                    continue;
                }
                OtherUtils.throwError("[CONFIG] Invalid block: " + (String)var3_3);
            }
            catch (Exception e) {
                OtherUtils.throwError("[CONFIG] Error parsing block ID: " + (String)var3_3);
            }
        }
        this.loadedListBlock = newList;
        return newList;
    }

    /*
     * WARNING - void declaration
     */
    public List<class_5321<class_1887>> getClampedEnchants() {
        if (Main.server == null) {
            return new ArrayList<class_5321<class_1887>>();
        }
        if (this.loadedListEnchants != null) {
            return this.loadedListEnchants;
        }
        ArrayList<class_5321<class_1887>> newList = new ArrayList<class_5321<class_1887>>();
        class_2378 enchantmentRegistry = Main.server.method_30611().method_30530(class_5321.method_29180((class_2960)IdentifierHelper.vanilla("enchantment")));
        for (String string : this.loadClampedEnchants()) {
            void var4_4;
            if (!string.contains(":")) {
                String string2 = "minecraft:" + string;
            }
            try {
                class_2960 id = IdentifierHelper.parse((String)var4_4);
                class_1887 enchantment = (class_1887)enchantmentRegistry.method_63535(id);
                if (enchantment != null) {
                    newList.add((class_5321<class_1887>)((class_5321)enchantmentRegistry.method_29113((Object)enchantment).orElseThrow()));
                    continue;
                }
                OtherUtils.throwError("[CONFIG] Invalid enchantment: " + (String)var4_4);
            }
            catch (Exception e) {
                OtherUtils.throwError("[CONFIG] Error parsing enchantment ID: " + (String)var4_4);
            }
        }
        this.loadedListEnchants = newList;
        return newList;
    }

    /*
     * WARNING - void declaration
     */
    public List<class_5321<class_1887>> getBannedEnchants() {
        if (Main.server == null) {
            return new ArrayList<class_5321<class_1887>>();
        }
        if (this.loadedBannedEnchants != null) {
            return this.loadedBannedEnchants;
        }
        ArrayList<class_5321<class_1887>> newList = new ArrayList<class_5321<class_1887>>();
        class_2378 enchantmentRegistry = Main.server.method_30611().method_30530(class_5321.method_29180((class_2960)IdentifierHelper.vanilla("enchantment")));
        for (String string : this.loadBlacklistedEnchants()) {
            void var4_4;
            if (!string.contains(":")) {
                String string2 = "minecraft:" + string;
            }
            try {
                class_2960 id = IdentifierHelper.parse((String)var4_4);
                class_1887 enchantment = (class_1887)enchantmentRegistry.method_63535(id);
                if (enchantment != null) {
                    newList.add((class_5321<class_1887>)((class_5321)enchantmentRegistry.method_29113((Object)enchantment).orElseThrow()));
                    continue;
                }
                OtherUtils.throwError("[CONFIG] Invalid enchantment: " + (String)var4_4);
            }
            catch (Exception e) {
                OtherUtils.throwError("[CONFIG] Error parsing enchantment ID: " + (String)var4_4);
            }
        }
        this.loadedBannedEnchants = newList;
        return newList;
    }

    /*
     * WARNING - void declaration
     */
    public List<class_6880<class_1291>> getBannedEffects() {
        if (Main.server == null) {
            return new ArrayList<class_6880<class_1291>>();
        }
        if (this.loadedBannedEffects != null) {
            return this.loadedBannedEffects;
        }
        ArrayList<class_6880<class_1291>> newList = new ArrayList<class_6880<class_1291>>();
        class_2378 effectsRegistry = Main.server.method_30611().method_30530(class_5321.method_29180((class_2960)IdentifierHelper.vanilla("mob_effect")));
        for (String string : this.loadBannedPotions()) {
            void var4_4;
            if (!string.contains(":")) {
                String string2 = "minecraft:" + string;
            }
            try {
                class_2960 id = IdentifierHelper.parse((String)var4_4);
                class_1291 enchantment = (class_1291)effectsRegistry.method_63535(id);
                if (enchantment != null) {
                    newList.add((class_6880<class_1291>)effectsRegistry.method_47983((Object)enchantment));
                    continue;
                }
                OtherUtils.throwError("[CONFIG] Invalid effect: " + (String)var4_4);
            }
            catch (Exception e) {
                OtherUtils.throwError("[CONFIG] Error parsing effect ID: " + (String)var4_4);
            }
        }
        this.loadedBannedEffects = newList;
        return newList;
    }

    public void reloadBlacklist() {
        if (Main.server == null) {
            return;
        }
        this.CREATIVE_IGNORE_BLACKLIST = (Boolean)Main.seasonConfig.CREATIVE_IGNORE_BLACKLIST.get(Main.seasonConfig);
        this.loadedListItem = null;
        this.loadedListBlock = null;
        this.loadedListEnchants = null;
        this.loadedBannedEnchants = null;
        this.loadedBannedEffects = null;
        this.loadedRecipeBlacklist = null;
        this.getItemBlacklist();
        this.getBlockBlacklist();
        this.getClampedEnchants();
        this.getBannedEnchants();
        this.getBannedEffects();
        this.getRecipeBlacklist();
    }

    public class_1269 onBlockUse(class_3222 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        if (player.method_7337() && this.CREATIVE_IGNORE_BLACKLIST) {
            return class_1269.field_5811;
        }
        this.processItemStack(player, player.method_5998(hand));
        class_2338 blockPos = hitResult.method_17777();
        class_2680 block = level.method_8320(blockPos);
        if (block.method_26215()) {
            return class_1269.field_5811;
        }
        if (this.getBlockBlacklist().contains(block.method_26204())) {
            level.method_8501(blockPos, class_2246.field_10124.method_9564());
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    public class_1269 onBlockAttack(class_3222 player, class_1937 level, class_2338 pos) {
        if (player.method_7337() && this.CREATIVE_IGNORE_BLACKLIST) {
            return class_1269.field_5811;
        }
        if (level.method_8608()) {
            return class_1269.field_5811;
        }
        class_2680 block = level.method_8320(pos);
        if (block.method_26215()) {
            return class_1269.field_5811;
        }
        if (this.getBlockBlacklist().contains(block.method_26204())) {
            level.method_8501(pos, class_2246.field_10124.method_9564());
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    public void onCollision(class_3222 player, class_1799 stack, CallbackInfo ci) {
        if (player.method_7337() && this.CREATIVE_IGNORE_BLACKLIST) {
            return;
        }
        this.processItemStack(player, stack);
    }

    public void onInventoryUpdated(class_3222 player) {
        if (Main.server == null) {
            return;
        }
        class_1661 inventory = player.method_31548();
        if (player.method_7337() && this.CREATIVE_IGNORE_BLACKLIST) {
            return;
        }
        for (int i = 0; i < inventory.method_5439(); ++i) {
            this.processItemStack(player, inventory.method_5438(i));
        }
        PlayerUtils.updatePlayerInventory(player);
    }

    public boolean isBlacklistedItemSimple(class_1799 itemStack) {
        return this.getItemBlacklist().contains(itemStack.method_7909());
    }

    public boolean isBlacklistedItem(class_1799 itemStack) {
        class_1792 item = itemStack.method_7909();
        if (this.getItemBlacklist().contains(item)) {
            return true;
        }
        if (item != class_1802.field_8574 && item != class_1802.field_8150 && item != class_1802.field_8436) {
            return false;
        }
        class_1844 potions = (class_1844)itemStack.method_57353().method_57829(class_9334.field_49651);
        if (potions == null) {
            return false;
        }
        for (class_1293 effect : potions.method_57397()) {
            if (!this.getBannedEffects().contains(effect.method_5579())) continue;
            return true;
        }
        return false;
    }

    public void processItemStack(class_3222 player, class_1799 itemStack) {
        if (player.method_7337() && this.CREATIVE_IGNORE_BLACKLIST) {
            return;
        }
        if (itemStack.method_7960()) {
            return;
        }
        if (itemStack.method_7909() == class_1802.field_8162) {
            return;
        }
        if (this.isBlacklistedItem(itemStack) && !ItemStackUtils.hasCustomComponentEntry(itemStack, "IgnoreBlacklist")) {
            itemStack.method_7939(0);
            player.method_31548().method_7381();
            return;
        }
        if (ItemStackUtils.hasCustomComponentEntry(itemStack, "FromSuperpower")) {
            boolean remove = true;
            if (ItemStackUtils.hasCustomComponentEntry(itemStack, "WindChargeSuperpower") && SuperpowersWildcard.hasActivatedPower(player, Superpowers.WIND_CHARGE)) {
                remove = false;
            }
            if (ItemStackUtils.hasCustomComponentEntry(itemStack, "FlightSuperpower") && SuperpowersWildcard.hasActivePower(player, Superpowers.FLIGHT)) {
                remove = false;
            }
            if (remove) {
                itemStack.method_7939(0);
                player.method_31548().method_7381();
                return;
            }
            return;
        }
        class_9304 enchants = (class_9304)itemStack.method_57353().method_57829(class_9334.field_49633);
        class_9304 enchantsStored = (class_9304)itemStack.method_57353().method_57829(class_9334.field_49643);
        if (enchants != null) {
            itemStack.method_57379(class_9334.field_49633, (Object)this.clampAndBlacklistEnchantments(enchants));
        }
        if (enchantsStored != null) {
            itemStack.method_57379(class_9334.field_49643, (Object)this.clampAndBlacklistEnchantments(enchantsStored));
        }
    }

    public class_9304 clampAndBlacklistEnchantments(class_9304 enchants) {
        class_9304 afterBlacklist = this.blacklistEnchantments(enchants);
        this.clampEnchantments(afterBlacklist);
        return afterBlacklist;
    }

    public class_9304 blacklistEnchantments(class_9304 enchants) {
        if (enchants.method_57543()) {
            return enchants;
        }
        List<class_5321<class_1887>> banned = this.getBannedEnchants();
        if (banned.isEmpty()) {
            return enchants;
        }
        ArrayList<Object2IntMap.Entry> toRemove = new ArrayList<Object2IntMap.Entry>();
        for (Object2IntMap.Entry enchant : enchants.method_57539()) {
            Optional enchantRegistry = ((class_6880)enchant.getKey()).method_40230();
            if (enchantRegistry.isEmpty() || !banned.contains(enchantRegistry.get())) continue;
            toRemove.add(enchant);
        }
        if (toRemove.isEmpty()) {
            return enchants;
        }
        class_9304.class_9305 builder = new class_9304.class_9305(class_9304.field_49385);
        for (Object2IntMap.Entry enchant : enchants.method_57539()) {
            if (toRemove.contains(enchant)) continue;
            builder.method_57550((class_6880)enchant.getKey(), enchant.getIntValue());
        }
        return builder.method_57549();
    }

    public void clampEnchantments(class_9304 enchants) {
        List<class_5321<class_1887>> clamp = this.getClampedEnchants();
        for (Object2IntMap.Entry enchant : enchants.method_57539()) {
            Optional enchantRegistry = ((class_6880)enchant.getKey()).method_40230();
            if (enchantRegistry.isEmpty() || !clamp.contains(enchantRegistry.get())) continue;
            enchant.setValue(1);
        }
    }
}

