/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.session;

import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.session.SessionTranscript;

public abstract class SessionAction {
    public boolean hasTriggered = false;
    public int triggerAtTicks;
    public String sessionMessage;
    public String sessionId;

    public SessionAction(int triggerAtTicks) {
        this.triggerAtTicks = triggerAtTicks;
    }

    public SessionAction(int triggerAtTicks, String message, String sessionId) {
        this.triggerAtTicks = triggerAtTicks;
        this.sessionMessage = message;
        this.sessionId = sessionId;
    }

    public boolean tick() {
        boolean shouldTrigger = this.shouldTrigger();
        if (this.hasTriggered && !shouldTrigger) {
            this.hasTriggered = false;
        }
        if (this.hasTriggered) {
            return true;
        }
        if (shouldTrigger) {
            this.hasTriggered = true;
            SessionTranscript.triggerSessionAction(this.sessionId);
            this.trigger();
            return true;
        }
        return false;
    }

    public boolean shouldTrigger() {
        if (this.triggerAtTicks >= 0) {
            int passedTime = Main.currentSession.getPassedTime();
            return passedTime >= this.triggerAtTicks;
        }
        int remainingTime = Main.currentSession.getRemainingTime();
        return remainingTime <= Math.abs(this.triggerAtTicks);
    }

    public int getTriggerTime() {
        return this.triggerAtTicks;
    }

    public abstract void trigger();
}

