/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.command.manager.Command;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.utils.enums.PacketNames;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class LifeSeriesCommand
extends Command {
    @Override
    public boolean isAllowed() {
        return true;
    }

    @Override
    public class_2561 getBannedText() {
        return class_2561.method_30163((String)"");
    }

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LifeSeriesCommand.literal("lifeseries").executes(context -> this.defaultCommand((class_2168)context.getSource()))).then(((LiteralArgumentBuilder)LifeSeriesCommand.literal("worlds").requires(PermissionManager::isAdmin)).executes(context -> this.getWorlds((class_2168)context.getSource())))).then(LifeSeriesCommand.literal("credits").executes(context -> this.getCredits((class_2168)context.getSource())))).then(LifeSeriesCommand.literal("discord").executes(context -> this.getDiscord((class_2168)context.getSource())))).then(LifeSeriesCommand.literal("getSeries").executes(context -> this.getSeason((class_2168)context.getSource())))).then(LifeSeriesCommand.literal("version").executes(context -> this.getVersion((class_2168)context.getSource())))).then(LifeSeriesCommand.literal("config").executes(context -> this.config((class_2168)context.getSource())))).then(LifeSeriesCommand.literal("wiki").executes(context -> this.wiki((class_2168)context.getSource())))).then(LifeSeriesCommand.literal("help").executes(context -> this.wiki((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)LifeSeriesCommand.literal("reload").requires(PermissionManager::isAdmin)).executes(context -> this.reload((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)LifeSeriesCommand.literal("chooseSeries").requires(source -> PermissionManager.isAdmin(source) && (NetworkHandlerServer.wasHandshakeSuccessful(source.method_44023()) || source.method_9228() == null))).executes(context -> this.chooseSeason((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)LifeSeriesCommand.literal("setSeries").requires(PermissionManager::isAdmin)).then(((RequiredArgumentBuilder)LifeSeriesCommand.argument("season", StringArgumentType.string()).suggests((context, builder) -> class_2172.method_9265(Main.ALLOWED_SEASON_NAMES, (SuggestionsBuilder)builder)).executes(context -> this.setSeason((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"season"), false))).then(LifeSeriesCommand.literal("confirm").executes(context -> this.setSeason((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"season"), true)))))).then(((LiteralArgumentBuilder)LifeSeriesCommand.literal("enable").requires(PermissionManager::isAdmin)).executes(context -> this.enableOrDisable((class_2168)context.getSource(), false)))).then(((LiteralArgumentBuilder)LifeSeriesCommand.literal("disable").requires(PermissionManager::isAdmin)).executes(context -> this.enableOrDisable((class_2168)context.getSource(), true))));
    }

    private int enableOrDisable(class_2168 source, boolean disabled) {
        OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("The Life Series has been {}", disabled ? "disabled" : "enabled"));
        Main.setDisabled(disabled);
        return 1;
    }

    public int chooseSeason(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (source.method_44023() == null) {
            return -1;
        }
        if (!NetworkHandlerServer.wasHandshakeSuccessful(source.method_44023())) {
            source.method_9213(class_2561.method_30163((String)"You must have the Life Series mod installed \u00a7nclient-side\u00a7r to open the season selection GUI."));
            source.method_9213(class_2561.method_30163((String)"Use the '/lifeseries setSeries <season>' command instead."));
            return -1;
        }
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"\u00a77Opening the season selection GUI..."));
        NetworkHandlerServer.sendStringPacket(source.method_44023(), PacketNames.SELECT_SEASON, Main.currentSeason.getSeason().getId());
        return 1;
    }

    public int setSeason(class_2168 source, String setTo, boolean confirmed) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (!Main.ALLOWED_SEASON_NAMES.contains(setTo)) {
            source.method_9213(class_2561.method_30163((String)"That is not a valid season!"));
            source.method_9213((class_2561)TextUtils.formatPlain("You must choose one of the following: {}", Main.ALLOWED_SEASON_NAMES));
            return -1;
        }
        if (confirmed) {
            this.setSeasonFinal(source, setTo);
        } else if (Main.currentSeason.getSeason() == Seasons.UNASSIGNED) {
            this.setSeasonFinal(source, setTo);
        } else {
            OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"\u00a77WARNING: you have already selected a season, changing it might cause some saved data to be lost (lives, ...)"));
            OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"\u00a77If you are sure, use '\u00a7f/lifeseries setSeries <season> confirm\u00a77'"));
        }
        return 1;
    }

    public void setSeasonFinal(class_2168 source, String setTo) {
        if (Main.changeSeasonTo(setTo)) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("\u00a77Changing the season to {}\u00a77...", setTo));
            PlayerUtils.broadcastMessage((class_2561)TextUtils.format("Successfully changed the season to {}", setTo).method_27692(class_124.field_1060));
        }
    }

    public int config(class_2168 source) {
        class_3222 self = source.method_44023();
        if (self == null) {
            return -1;
        }
        if (!NetworkHandlerServer.wasHandshakeSuccessful(self)) {
            source.method_9213(class_2561.method_30163((String)"You must have the Life Series mod installed \u00a7nclient-side\u00a7r to open the config GUI."));
            source.method_9213(class_2561.method_30163((String)"Either install the mod on the client on modify the config folder."));
            return -1;
        }
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"\u00a77Opening the config GUI..."));
        NetworkHandlerServer.sendStringPacket(self, PacketNames.CLEAR_CONFIG, "");
        if (PermissionManager.isAdmin(self)) {
            Main.seasonConfig.sendConfigTo(self);
        }
        NetworkHandlerServer.sendStringPacket(self, PacketNames.OPEN_CONFIG, "");
        return 1;
    }

    public int getWorlds(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        class_5250 worldSavesText = TextUtils.format("\u00a77If you want to play on the exact same world seeds as Grian did, click {}\u00a77 to open a dropbox where you can download the pre-made worlds.", TextUtils.openURLText("https://www.dropbox.com/scl/fo/jk9fhqx0jjbgeo2qa6v5i/AOZZxMx6S7MlS9HrIRJkkX4?rlkey=2khwcnf2zhgi6s4ik01e3z9d0&st=ghw1d8k6&dl=0"));
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)worldSavesText);
        return 1;
    }

    public int defaultCommand(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        this.getDiscord(source);
        return 1;
    }

    public int wiki(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        class_5250 text = TextUtils.format("\u00a77Click {}\u00a77 to open the Life Series Mod wiki", TextUtils.openURLText("https://mat0u5.github.io/LifeSeries-docs"));
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)text);
        return 1;
    }

    public int getDiscord(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        class_5250 text = TextUtils.format("\u00a77Click {}\u00a77 to join the mod development discord if you have any questions, issues, requests, or if you just want to hang out :)\"", TextUtils.openURLText("https://discord.gg/QWJxfb4zQZ"));
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)text);
        return 1;
    }

    public int getSeason(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("Current season: {}", Main.currentSeason.getSeason().getId()));
        if (source.method_44023() != null) {
            NetworkHandlerServer.sendStringPacket(source.method_44023(), PacketNames.SEASON_INFO, Main.currentSeason.getSeason().getId());
        }
        return 1;
    }

    public int getVersion(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("Mod version: {}", "dev-1.4.3.3"));
        return 1;
    }

    public int reload(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"\u00a77Reloading the Life Series..."));
        OtherUtils.reloadServer();
        return 1;
    }

    public int getCredits(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"\u00a77The Life Series was originally created by \u00a7fGrian\u00a77, and this mod, created by \u00a7fMat0u5\u00a77, aims to recreate every single season one-to-one."));
        OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"\u00a77This mod uses sounds created by \u00a7fOli (TheOrionSound)\u00a77, and uses recreated snail model (first created by \u00a7fDanny\u00a77), and a recreated trivia bot model (first created by \u00a7fHoffen\u00a77)."));
        return 1;
    }
}

