/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.snails;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.config.StringListConfig;
import net.mat0u5.lifeseries.entity.pathfinder.PathFinder;
import net.mat0u5.lifeseries.entity.snail.Snail;
import net.mat0u5.lifeseries.registries.MobRegistry;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcard;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcards;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;

public class Snails
extends Wildcard {
    public static StringListConfig snailNameConfig;
    public static Map<UUID, Snail> snails;
    public static Map<UUID, String> snailNames;
    long ticks = 0L;

    @Override
    public Wildcards getType() {
        return Wildcards.SNAILS;
    }

    @Override
    public void activate() {
        snails.clear();
        for (class_3222 player : Main.currentSeason.getAlivePlayers()) {
            if (player.method_29504()) continue;
            Snails.spawnSnailFor(player);
        }
        Snails.loadSnailNames();
        if (!Main.currentSession.statusStarted()) {
            PlayerUtils.broadcastMessageToAdmins(class_2561.method_30163((String)"\u00a77Use the \u00a7f'/snail ...'\u00a77 command to modify snail names and to get info on how to change snail textures."));
        }
        super.activate();
    }

    @Override
    public void deactivate() {
        snails.clear();
        Snails.killAllSnails();
        super.deactivate();
    }

    @Override
    public void tick() {
        ++this.ticks;
        if (this.ticks % 100L == 0L) {
            for (class_3222 player : Main.currentSeason.getAlivePlayers()) {
                if (player.method_29504()) continue;
                UUID playerUUID = player.method_5667();
                if (snails.containsKey(playerUUID)) {
                    Snail snail = snails.get(playerUUID);
                    if (snail != null && !snail.method_29504() && !snail.method_31481()) continue;
                    snails.remove(playerUUID);
                    Snails.spawnSnailFor(player);
                    continue;
                }
                Snails.spawnSnailFor(player);
            }
        }
    }

    public static void spawnSnailFor(class_3222 player) {
        class_2338 pos = Snail.getBlockPosNearTarget(player, 30.0);
        if (pos == null) {
            pos = player.method_24515().method_10069(0, 30, 0);
        }
        Snails.spawnSnailFor(player, pos);
    }

    public static void spawnSnailFor(class_3222 player, class_2338 pos) {
        if (player == null || pos == null) {
            return;
        }
        Snail snail = (Snail)MobRegistry.SNAIL.method_47821(PlayerUtils.getServerWorld(player), pos, class_3730.field_16462);
        if (snail != null) {
            snail.setBoundPlayer(player);
            snail.updateSkin(player);
            snails.put(player.method_5667(), snail);
        }
    }

    public static void killAllSnails() {
        if (Main.server == null) {
            return;
        }
        ArrayList<class_1297> toKill = new ArrayList<class_1297>();
        for (class_3218 world : Main.server.method_3738()) {
            for (class_1297 entity : world.method_27909()) {
                if (entity instanceof Snail) {
                    Snail snail = (Snail)entity;
                    if (!snail.fromTrivia) {
                        toKill.add(entity);
                    }
                }
                if (!(entity instanceof PathFinder)) continue;
                toKill.add(entity);
            }
        }
        toKill.forEach(class_1297::method_31472);
    }

    public static void reloadSnailNames() {
        for (Snail snail : snails.values()) {
            if (snail == null) {
                return;
            }
            snail.updateSnailName();
        }
    }

    public static void reloadSnailSkins() {
        for (Snail snail : snails.values()) {
            if (snail == null) {
                return;
            }
            snail.updateSkin(snail.getActualBoundPlayer());
        }
    }

    public static void setSnailName(class_3222 player, String name) {
        snailNames.put(player.method_5667(), name);
        Snails.reloadSnailNames();
        Snails.saveSnailNames();
    }

    public static void resetSnailName(class_3222 player) {
        snailNames.remove(player.method_5667());
        Snails.reloadSnailNames();
        Snails.saveSnailNames();
    }

    public static String getSnailName(class_3222 player) {
        if (snailNames.containsKey(player.method_5667())) {
            return snailNames.get(player.method_5667());
        }
        return TextUtils.formatString("{}'s Snail", player);
    }

    public static void saveSnailNames() {
        if (snailNameConfig == null) {
            Snails.loadConfig();
        }
        ArrayList<String> names = new ArrayList<String>();
        for (Map.Entry<UUID, String> entry : snailNames.entrySet()) {
            names.add(entry.getKey().toString() + "_" + entry.getValue().replaceAll("_", ""));
        }
        snailNameConfig.save(names);
    }

    public static void loadSnailNames() {
        if (snailNameConfig == null) {
            Snails.loadConfig();
        }
        HashMap<UUID, String> newNames = new HashMap<UUID, String>();
        for (String entry : snailNameConfig.load()) {
            String[] split;
            if (!entry.contains("_") || (split = entry.split("_")).length != 2) continue;
            try {
                UUID uuid = UUID.fromString(split[0]);
                newNames.put(uuid, split[1]);
            }
            catch (Exception exception) {}
        }
        snailNames = newNames;
    }

    public static void loadConfig() {
        snailNameConfig = new StringListConfig("./config/lifeseries/main", "DO_NOT_MODIFY_wildlife_snailnames.properties");
    }

    static {
        snails = new HashMap<UUID, Snail>();
        snailNames = new HashMap<UUID, String>();
    }
}

