/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.mixin;

import java.util.Objects;
import java.util.OptionalInt;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.entity.fakeplayer.FakePlayer;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_5454;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3222.class}, priority=1)
public class ServerPlayerEntityMixin {
    @Inject(method={"getRespawnTarget"}, at={@At(value="HEAD")})
    private void getRespawnTarget(boolean alive, class_5454.class_9823 postDimensionTransition, CallbackInfoReturnable<class_5454> cir) {
        if (!Main.isLogicalSide()) {
            return;
        }
        class_3222 player = (class_3222)this;
        UUID uuid = player.method_5667();
        TaskScheduler.scheduleTask(1, () -> Main.currentSeason.onPlayerRespawn(Objects.requireNonNull(Objects.requireNonNull(player.method_5682()).method_3760().method_14602(uuid))));
    }

    @Inject(method={"openHandledScreen"}, at={@At(value="HEAD")})
    private void onInventoryOpen(@Nullable class_3908 factory, CallbackInfoReturnable<OptionalInt> cir) {
        if (!Main.isLogicalSide()) {
            return;
        }
        class_3222 player = (class_3222)this;
        if (Main.blacklist != null) {
            TaskScheduler.scheduleTask(1, () -> {
                player.field_7512.method_7602().forEach(itemStack -> Main.blacklist.processItemStack(player, (class_1799)itemStack));
                PlayerUtils.updatePlayerInventory(player);
            });
        }
    }

    @Inject(method={"sendMessageToClient"}, at={@At(value="HEAD")}, cancellable=true)
    private void sendMessageToClient(class_2561 message, boolean overlay, CallbackInfo ci) {
        class_3222 player = (class_3222)this;
        if (player instanceof FakePlayer) {
            ci.cancel();
        }
    }

    @Inject(method={"acceptsMessage"}, at={@At(value="HEAD")}, cancellable=true)
    private void acceptsMessage(boolean overlay, CallbackInfoReturnable<Boolean> cir) {
        class_3222 player = (class_3222)this;
        if (player instanceof FakePlayer) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"acceptsChatMessage"}, at={@At(value="HEAD")}, cancellable=true)
    private void acceptsChatMessage(CallbackInfoReturnable<Boolean> cir) {
        class_3222 player = (class_3222)this;
        if (player instanceof FakePlayer) {
            cir.setReturnValue((Object)false);
        }
    }
}

