/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.resources.datapack;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.resources.ResourceHandler;
import net.mat0u5.lifeseries.resources.datapack.DatapackManager;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class DynamicDatapackManager {
    private static final String CONFIG_TABLE_TRIVIA = "./config/lifeseries/wildlife/trivia_reward_loottable_" + DatapackManager.getMinecraftVersion() + ".json";
    private static final String CONFIG_TABLE_TASK = "./config/lifeseries/secretlife/task_reward_loottable_" + DatapackManager.getMinecraftVersion() + ".json";
    private static final String LOCAL_TABLE_TRIVIA = "/assets/dynamicpack/loottables/trivia_reward_loottable" + DatapackManager.getResourceTriviaPackVersion() + ".json";
    private static final String LOCAL_TABLE_TASK = "/assets/dynamicpack/loottables/task_reward_loottable" + DatapackManager.getResourceTaskPackVersion() + ".json";
    private static final String LOCAL_MCMETA = "/assets/dynamicpack/pack.mcmeta";
    private static final String DATAPACK_MAIN = "Life Series Dynamic Datapack";
    private static final String DATAPACK_LOOTTABLE = "Life Series Dynamic Datapack/data/lifeseriesdynamic/loot_table";
    private static final String DATAPACK_MCMETA = "Life Series Dynamic Datapack/pack.mcmeta";
    private static final String DATAPACK_TABLE_TRIVIA = "Life Series Dynamic Datapack/data/lifeseriesdynamic/loot_table/trivia_reward_loottable.json";
    private static final String DATAPACK_TABLE_TASK = "Life Series Dynamic Datapack/data/lifeseriesdynamic/loot_table/task_reward_loottable.json";

    public static void onServerStarted(MinecraftServer server) {
        DynamicDatapackManager.createDatapack(server);
        DynamicDatapackManager.copyLootTables(server);
    }

    private static void createDatapack(MinecraftServer server) {
        Path datapackFolder = server.method_27050(class_5218.field_24186);
        ResourceHandler handler = new ResourceHandler();
        datapackFolder.resolve(DATAPACK_MAIN).toFile().mkdirs();
        datapackFolder.resolve(DATAPACK_LOOTTABLE).toFile().mkdirs();
        handler.copyBundledSingleFile(LOCAL_MCMETA, datapackFolder.resolve(DATAPACK_MCMETA));
    }

    public static void copyLootTables(MinecraftServer server) {
        File configTask;
        if (server == null) {
            return;
        }
        Path datapackFolder = server.method_27050(class_5218.field_24186);
        ResourceHandler handler = new ResourceHandler();
        File configTrivia = new File(CONFIG_TABLE_TRIVIA);
        if (!configTrivia.exists()) {
            handler.copyBundledSingleFile(LOCAL_TABLE_TRIVIA, configTrivia.toPath());
        }
        if (!(configTask = new File(CONFIG_TABLE_TASK)).exists()) {
            handler.copyBundledSingleFile(LOCAL_TABLE_TASK, configTask.toPath());
        }
        try {
            Files.copy(configTrivia.toPath(), datapackFolder.resolve(DATAPACK_TABLE_TRIVIA), StandardCopyOption.REPLACE_EXISTING);
            Files.copy(configTask.toPath(), datapackFolder.resolve(DATAPACK_TABLE_TASK), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            Main.LOGGER.error("Error copying loot tables: {}", (Object)e.getMessage());
        }
    }

    public static void disableDatapack() {
        OtherUtils.executeCommand("datapack disable \"file/Life Series Dynamic Datapack\"");
    }

    public static void enableDatapack() {
        OtherUtils.executeCommand("datapack enable \"file/Life Series Dynamic Datapack\"");
    }
}

